/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.SensorManager;
import jmri.SystemConnectionMemo;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.ActionRequestUpdateAllSensors;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;

public class ActionRequestUpdateAllSensorsSwing
extends AbstractDigitalActionSwing {
    private JComboBox<Connection> _connection;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        if (object != null && !(object instanceof ActionRequestUpdateAllSensors)) {
            throw new IllegalArgumentException("object must be an ActionRequestUpdateAllSensors but is a: " + object.getClass().getName());
        }
        ActionRequestUpdateAllSensors action = (ActionRequestUpdateAllSensors)object;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JPanel connectionPanel = new JPanel();
        connectionPanel.add(new JLabel(Bundle.getMessage("ActionRequestUpdateAllSensorsSwing_Connection")));
        this._connection = new JComboBox();
        this._connection.addItem(new Connection(null));
        List<SystemConnectionMemo> systemConnections = InstanceManager.getList(SystemConnectionMemo.class);
        for (SystemConnectionMemo connection : systemConnections) {
            if (!connection.provides(SensorManager.class)) continue;
            Connection c = new Connection(connection);
            this._connection.addItem(c);
            if (action == null || action.getMemo() != connection) continue;
            this._connection.setSelectedItem(c);
        }
        connectionPanel.add(this._connection);
        JPanel infoPanel = new JPanel();
        infoPanel.add(new JLabel(Bundle.getMessage("ActionRequestUpdateAllSensorsSwing_Info")));
        this.panel.add(connectionPanel);
        this.panel.add(infoPanel);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        SystemConnectionMemo memo = this._connection.getItemAt((int)this._connection.getSelectedIndex())._memo;
        ActionRequestUpdateAllSensors action = new ActionRequestUpdateAllSensors(systemName, userName, memo);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof ActionRequestUpdateAllSensors)) {
            throw new IllegalArgumentException("object must be an ActionRequestUpdateAllSensors but is a: " + object.getClass().getName());
        }
        ActionRequestUpdateAllSensors action = (ActionRequestUpdateAllSensors)object;
        action.setMemo(this._connection.getItemAt((int)this._connection.getSelectedIndex())._memo);
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ActionRequestUpdateAllSensors_Short");
    }

    @Override
    public void dispose() {
    }

    private static class Connection {
        private SystemConnectionMemo _memo;

        public Connection(SystemConnectionMemo memo) {
            this._memo = memo;
        }

        public String toString() {
            if (this._memo == null) {
                return Bundle.getMessage("ActionRequestUpdateAllSensorsSwing_AllConnections");
            }
            return this._memo.getUserName();
        }
    }
}

