/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionSound;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectEnumSwing;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionSoundSwing
extends AbstractDigitalActionSwing {
    public static final int NUM_COLUMNS_TEXT_FIELDS = 20;
    private LogixNG_SelectEnumSwing<ActionSound.Operation> _selectOperationSwing;
    private JTabbedPane _tabbedPaneSoundType;
    private JPanel _panelSoundTypeDirect;
    private JPanel _panelSoundTypeReference;
    private JPanel _panelSoundTypeLocalVariable;
    private JPanel _panelSoundTypeFormula;
    private JFileChooser soundFileChooser;
    private JTextField _soundTextField;
    private JTextField _soundReferenceTextField;
    private JTextField _soundLocalVariableTextField;
    private JTextField _soundFormulaTextField;
    private static final Logger log = LoggerFactory.getLogger(ActionSoundSwing.class);

    public ActionSoundSwing() {
    }

    public ActionSoundSwing(JDialog dialog) {
        super.setJDialog(dialog);
    }

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ActionSound action = (ActionSound)object;
        this._selectOperationSwing = new LogixNG_SelectEnumSwing(this.getJDialog(), this);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JPanel actionPanel = new JPanel();
        JPanel _tabbedPaneOperation = action != null ? this._selectOperationSwing.createPanel(action.getSelectEnum(), ActionSound.Operation.values()) : this._selectOperationSwing.createPanel(null, ActionSound.Operation.values());
        this._tabbedPaneSoundType = new JTabbedPane();
        this._panelSoundTypeDirect = new JPanel();
        this._panelSoundTypeReference = new JPanel();
        this._panelSoundTypeReference.setLayout(new BoxLayout(this._panelSoundTypeReference, 1));
        this._panelSoundTypeLocalVariable = new JPanel();
        this._panelSoundTypeLocalVariable.setLayout(new BoxLayout(this._panelSoundTypeLocalVariable, 1));
        this._panelSoundTypeFormula = new JPanel();
        this._panelSoundTypeFormula.setLayout(new BoxLayout(this._panelSoundTypeFormula, 1));
        this._tabbedPaneSoundType.addTab(NamedBeanAddressing.Direct.toString(), this._panelSoundTypeDirect);
        this._tabbedPaneSoundType.addTab(NamedBeanAddressing.Reference.toString(), this._panelSoundTypeReference);
        this._tabbedPaneSoundType.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelSoundTypeLocalVariable);
        this._tabbedPaneSoundType.addTab(NamedBeanAddressing.Formula.toString(), this._panelSoundTypeFormula);
        JButton _actionSelectFileButton = new JButton("...");
        _actionSelectFileButton.setMaximumSize(_actionSelectFileButton.getPreferredSize());
        _actionSelectFileButton.setToolTipText(Bundle.getMessage("FileButtonHint"));
        _actionSelectFileButton.addActionListener(e -> {
            this.soundFileChooser = new JmriJFileChooser(System.getProperty("user.dir") + File.separator + "resources" + File.separator + "sounds");
            this.soundFileChooser.setFileFilter(new FileNameExtensionFilter("wav sound files", "wav"));
            this.soundFileChooser.rescanCurrentDirectory();
            int retVal = this.soundFileChooser.showOpenDialog(null);
            if (retVal == 0) {
                try {
                    this._soundTextField.setText(FileUtil.getPortableFilename(this.soundFileChooser.getSelectedFile().getCanonicalPath()));
                }
                catch (IOException ex) {
                    log.error("exception setting file location", (Throwable)ex);
                    this._soundTextField.setText("");
                }
            }
        });
        this._panelSoundTypeDirect.add(_actionSelectFileButton);
        JPanel _soundTextPanel = new JPanel();
        _soundTextPanel.setLayout(new BoxLayout(_soundTextPanel, 1));
        this._soundTextField = new JTextField(30);
        _soundTextPanel.add(new JLabel(Bundle.getMessage("ActionSound_Sound")));
        _soundTextPanel.add(this._soundTextField);
        this._panelSoundTypeDirect.add(_soundTextPanel);
        this._soundReferenceTextField = new JTextField();
        this._soundReferenceTextField.setColumns(20);
        this._panelSoundTypeReference.add(new JLabel(Bundle.getMessage("ActionSound_Sound")));
        this._panelSoundTypeReference.add(this._soundReferenceTextField);
        this._soundLocalVariableTextField = new JTextField();
        this._soundLocalVariableTextField.setColumns(20);
        this._panelSoundTypeLocalVariable.add(new JLabel(Bundle.getMessage("ActionSound_Sound")));
        this._panelSoundTypeLocalVariable.add(this._soundLocalVariableTextField);
        this._soundFormulaTextField = new JTextField();
        this._soundFormulaTextField.setColumns(20);
        this._panelSoundTypeFormula.add(new JLabel(Bundle.getMessage("ActionSound_Sound")));
        this._panelSoundTypeFormula.add(this._soundFormulaTextField);
        if (action != null) {
            switch (action.getSoundAddressing()) {
                case Direct: {
                    this._tabbedPaneSoundType.setSelectedComponent(this._panelSoundTypeDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneSoundType.setSelectedComponent(this._panelSoundTypeReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneSoundType.setSelectedComponent(this._panelSoundTypeLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneSoundType.setSelectedComponent(this._panelSoundTypeFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getSoundAddressing().name());
                }
            }
            this._soundTextField.setText(action.getSound());
            this._soundReferenceTextField.setText(action.getSoundReference());
            this._soundLocalVariableTextField.setText(action.getSoundLocalVariable());
            this._soundFormulaTextField.setText(action.getSoundFormula());
        }
        JComponent[] components = new JComponent[]{_tabbedPaneOperation, this._tabbedPaneSoundType};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ActionSound_Components"), components);
        for (JComponent c : componentList) {
            actionPanel.add(c);
        }
        this.panel.add(actionPanel);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        block6: {
            ActionSound action = new ActionSound("IQDA1", null);
            this._selectOperationSwing.validate(action.getSelectEnum(), errorMessages);
            try {
                action.setSoundFormula(this._soundFormulaTextField.getText());
                if (this._tabbedPaneSoundType.getSelectedComponent() == this._panelSoundTypeDirect) {
                    action.setSoundAddressing(NamedBeanAddressing.Direct);
                    break block6;
                }
                if (this._tabbedPaneSoundType.getSelectedComponent() == this._panelSoundTypeReference) {
                    action.setSoundAddressing(NamedBeanAddressing.Reference);
                    break block6;
                }
                if (this._tabbedPaneSoundType.getSelectedComponent() == this._panelSoundTypeLocalVariable) {
                    action.setSoundAddressing(NamedBeanAddressing.LocalVariable);
                    break block6;
                }
                if (this._tabbedPaneSoundType.getSelectedComponent() == this._panelSoundTypeFormula) {
                    action.setSoundAddressing(NamedBeanAddressing.Formula);
                    break block6;
                }
                throw new IllegalArgumentException("_tabbedPaneSoundType has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
            }
        }
        return errorMessages.isEmpty();
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionSound action = new ActionSound(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        block7: {
            if (!(object instanceof ActionSound)) {
                throw new IllegalArgumentException("object must be an ActionSound but is a: " + object.getClass().getName());
            }
            ActionSound action = (ActionSound)object;
            this._selectOperationSwing.updateObject(action.getSelectEnum());
            try {
                if (this._tabbedPaneSoundType.getSelectedComponent() == this._panelSoundTypeDirect) {
                    action.setSoundAddressing(NamedBeanAddressing.Direct);
                    action.setSound(this._soundTextField.getText());
                    break block7;
                }
                if (this._tabbedPaneSoundType.getSelectedComponent() == this._panelSoundTypeReference) {
                    action.setSoundAddressing(NamedBeanAddressing.Reference);
                    action.setSoundReference(this._soundReferenceTextField.getText());
                    break block7;
                }
                if (this._tabbedPaneSoundType.getSelectedComponent() == this._panelSoundTypeLocalVariable) {
                    action.setSoundAddressing(NamedBeanAddressing.LocalVariable);
                    action.setSoundLocalVariable(this._soundLocalVariableTextField.getText());
                    break block7;
                }
                if (this._tabbedPaneSoundType.getSelectedComponent() == this._panelSoundTypeFormula) {
                    action.setSoundAddressing(NamedBeanAddressing.Formula);
                    action.setSoundFormula(this._soundFormulaTextField.getText());
                    break block7;
                }
                throw new IllegalArgumentException("_tabbedPaneAspectType has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ActionSound_Short");
    }

    @Override
    public void dispose() {
        this._selectOperationSwing.dispose();
    }
}

