/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.SystemConnectionMemo;
import jmri.ThrottleManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.ActionThrottleFunction;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectEnumSwing;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectIntegerSwing;

public class ActionThrottleFunctionSwing
extends AbstractDigitalActionSwing {
    private LogixNG_SelectIntegerSwing _selectAddressSwing;
    private LogixNG_SelectIntegerSwing _selectFunctionSwing;
    private LogixNG_SelectEnumSwing<ActionThrottleFunction.FunctionState> _selectOnOffSwing;
    private JComboBox<Connection> _connection;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ActionThrottleFunction action = (ActionThrottleFunction)object;
        if (action == null) {
            action = new ActionThrottleFunction("IQDA1", null);
        }
        this._selectAddressSwing = new LogixNG_SelectIntegerSwing(this.getJDialog(), this);
        this._selectFunctionSwing = new LogixNG_SelectIntegerSwing(this.getJDialog(), this);
        this._selectOnOffSwing = new LogixNG_SelectEnumSwing(this.getJDialog(), this);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JPanel selectPanel = new JPanel();
        JPanel _tabbedPaneAddress = this._selectAddressSwing.createPanel(action.getSelectAddress());
        JPanel _tabbedPaneFunction = this._selectFunctionSwing.createPanel(action.getSelectFunction());
        JPanel _tabbedPaneOnOff = this._selectOnOffSwing.createPanel(action.getSelectOnOff(), ActionThrottleFunction.FunctionState.values());
        JComponent[] components = new JComponent[]{_tabbedPaneAddress, _tabbedPaneFunction, _tabbedPaneOnOff};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ActionThrottleFunction_Components"), components);
        for (JComponent c : componentList) {
            selectPanel.add(c);
        }
        JPanel connectionPanel = new JPanel();
        connectionPanel.add(new JLabel(Bundle.getMessage("ActionThrottleFunctionSwing_Connection")));
        this._connection = new JComboBox();
        this._connection.addItem(new Connection(null));
        List<SystemConnectionMemo> systemConnections = InstanceManager.getList(SystemConnectionMemo.class);
        for (SystemConnectionMemo connection : systemConnections) {
            if (!connection.provides(ThrottleManager.class)) continue;
            Connection c = new Connection(connection);
            this._connection.addItem(c);
            if (object == null || action.getMemo() != connection) continue;
            this._connection.setSelectedItem(c);
        }
        connectionPanel.add(this._connection);
        this.panel.add(selectPanel);
        this.panel.add(connectionPanel);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        ActionThrottleFunction action = new ActionThrottleFunction("IQDA1", null);
        this._selectAddressSwing.validate(action.getSelectAddress(), errorMessages);
        this._selectFunctionSwing.validate(action.getSelectFunction(), errorMessages);
        this._selectOnOffSwing.validate(action.getSelectOnOff(), errorMessages);
        return errorMessages.isEmpty();
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionThrottleFunction action = new ActionThrottleFunction(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof ActionThrottleFunction)) {
            throw new IllegalArgumentException("object must be an ActionThrottleFunction but is a: " + object.getClass().getName());
        }
        ActionThrottleFunction action = (ActionThrottleFunction)object;
        this._selectAddressSwing.updateObject(action.getSelectAddress());
        this._selectFunctionSwing.updateObject(action.getSelectFunction());
        this._selectOnOffSwing.updateObject(action.getSelectOnOff());
        action.setMemo(this._connection.getItemAt((int)this._connection.getSelectedIndex())._memo);
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ActionThrottleFunction_Short");
    }

    @Override
    public void dispose() {
        this._selectAddressSwing.dispose();
        this._selectFunctionSwing.dispose();
        this._selectOnOffSwing.dispose();
    }

    private static class Connection {
        private SystemConnectionMemo _memo;

        public Connection(SystemConnectionMemo memo) {
            this._memo = memo;
        }

        public String toString() {
            if (this._memo == null) {
                return Bundle.getMessage("ActionThrottleFunctionSwing_DefaultConnection");
            }
            return this._memo.getUserName();
        }
    }
}

