/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.awt.Color;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.SystemConnectionMemo;
import jmri.ThrottleManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.ActionThrottle;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;

public class ActionThrottleSwing
extends AbstractDigitalActionSwing {
    private JComboBox<Connection> _connection;
    private JCheckBox _stopLocoWhenSwitchingLoco;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        if (object != null && !(object instanceof ActionThrottle)) {
            throw new IllegalArgumentException("object must be an ActionThrottle but is a: " + object.getClass().getName());
        }
        ActionThrottle action = (ActionThrottle)object;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JPanel queryPanel = new JPanel();
        queryPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel connectionPanel = new JPanel();
        connectionPanel.add(new JLabel(Bundle.getMessage("ActionThrottleSwing_Connection")));
        this._connection = new JComboBox();
        this._connection.addItem(new Connection(null));
        List<SystemConnectionMemo> systemConnections = InstanceManager.getList(SystemConnectionMemo.class);
        for (SystemConnectionMemo connection : systemConnections) {
            if (!connection.provides(ThrottleManager.class)) continue;
            Connection c = new Connection(connection);
            this._connection.addItem(c);
            if (action == null || action.getMemo() != connection) continue;
            this._connection.setSelectedItem(c);
        }
        connectionPanel.add(this._connection);
        this.panel.add(connectionPanel);
        this._stopLocoWhenSwitchingLoco = new JCheckBox(Bundle.getMessage("ActionThrottleSwing_StopLocoWhenSwitchingLoco"));
        if (action != null) {
            this._stopLocoWhenSwitchingLoco.setSelected(action.isStopLocoWhenSwitchingLoco());
        } else {
            this._stopLocoWhenSwitchingLoco.setSelected(true);
        }
        this.panel.add(this._stopLocoWhenSwitchingLoco);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionThrottle action = new ActionThrottle(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof ActionThrottle)) {
            throw new IllegalArgumentException("object must be an ActionThrottle but is a: " + object.getClass().getName());
        }
        ActionThrottle action = (ActionThrottle)object;
        action.setMemo(this._connection.getItemAt((int)this._connection.getSelectedIndex())._memo);
        action.setStopLocoWhenSwitchingLoco(this._stopLocoWhenSwitchingLoco.isSelected());
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ActionThrottle_Short");
    }

    @Override
    public void dispose() {
    }

    private static class Connection {
        private SystemConnectionMemo _memo;

        public Connection(SystemConnectionMemo memo) {
            this._memo = memo;
        }

        public String toString() {
            if (this._memo == null) {
                return Bundle.getMessage("ActionThrottleSwing_DefaultConnection");
            }
            return this._memo.getUserName();
        }
    }
}

