/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.awt.Color;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.ActionTimer;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.util.TimerUnit;
import jmri.util.swing.JComboBoxUtil;

public class ActionTimerSwing
extends AbstractDigitalActionSwing {
    public static final int MAX_NUM_TIMERS = 10;
    private JCheckBox _startImmediately;
    private JCheckBox _runContinuously;
    private JCheckBox _startAndStopByStartExpression;
    private JComboBox<TimerUnit> _unitComboBox;
    private JCheckBox _delayByLocalVariables;
    private JTextField _delayLocalVariablePrefix;
    private JTextField _numTimers;
    private JButton _addTimer;
    private JButton _removeTimer;
    private JTextField[] _timerSocketNames;
    private JTextField[] _timerDelays;
    private int numActions = 1;

    private String getNewSocketName(ActionTimer action) {
        int size = 12;
        String[] names = new String[size];
        names[0] = action.getStartExpressionSocket().getName();
        names[1] = action.getStopExpressionSocket().getName();
        for (int i = 0; i < 10; ++i) {
            names[2 + i] = this._timerSocketNames[i].getText();
        }
        return action.getNewSocketName(names);
    }

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        if (object != null && !(object instanceof ActionTimer)) {
            throw new IllegalArgumentException("object must be an ActionTimer but is a: " + object.getClass().getName());
        }
        ActionTimer action = object != null ? (ActionTimer)object : new ActionTimer("IQDA1", null);
        this.numActions = action.getNumActions();
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JPanel optionsPanel = new JPanel();
        JPanel leftOptionsPanel = new JPanel();
        leftOptionsPanel.setLayout(new BoxLayout(leftOptionsPanel, 1));
        this._startImmediately = new JCheckBox(Bundle.getMessage("ActionTimerSwing_StartImmediately"));
        this._runContinuously = new JCheckBox(Bundle.getMessage("ActionTimerSwing_RunContinuously"));
        this._startAndStopByStartExpression = new JCheckBox(Bundle.getMessage("ActionTimer_StartAndStopByStartExpression"));
        this._unitComboBox = new JComboBox();
        for (TimerUnit u : TimerUnit.values()) {
            this._unitComboBox.addItem(u);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._unitComboBox);
        this._unitComboBox.setSelectedItem((Object)action.getUnit());
        leftOptionsPanel.add(this._startImmediately);
        leftOptionsPanel.add(this._runContinuously);
        leftOptionsPanel.add(this._startAndStopByStartExpression);
        JPanel unitPanel = new JPanel();
        unitPanel.add(new JLabel(Bundle.getMessage("ActionTimerSwing_Unit")));
        unitPanel.add(this._unitComboBox);
        leftOptionsPanel.add(unitPanel);
        leftOptionsPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY));
        JPanel rightOptionsPanel = new JPanel();
        rightOptionsPanel.setLayout(new BoxLayout(rightOptionsPanel, 1));
        this._delayByLocalVariables = new JCheckBox(Bundle.getMessage("ActionTimerSwing_DelayByLocalVariables"));
        this._delayByLocalVariables.setSelected(action.isDelayByLocalVariables());
        this._delayByLocalVariables.addActionListener(evt -> this.updateEnableDisabled());
        this._delayLocalVariablePrefix = new JTextField(20);
        this._delayLocalVariablePrefix.setText(action.getDelayLocalVariablePrefix());
        rightOptionsPanel.add(this._delayByLocalVariables);
        rightOptionsPanel.add(new JLabel(Bundle.getMessage("ActionTimerSwing_DelayLocalVariablePrefix")));
        rightOptionsPanel.add(this._delayLocalVariablePrefix);
        optionsPanel.add(leftOptionsPanel);
        optionsPanel.add(rightOptionsPanel);
        JPanel numActionsPanel = new JPanel();
        this._numTimers = new JTextField(Integer.toString(this.numActions));
        this._numTimers.setColumns(2);
        this._numTimers.setEnabled(false);
        this._addTimer = new JButton(Bundle.getMessage("ActionTimerSwing_AddTimer"));
        this._addTimer.addActionListener(e -> {
            ++this.numActions;
            this._numTimers.setText(Integer.toString(this.numActions));
            if (this._timerSocketNames[this.numActions - 1].getText().trim().isEmpty()) {
                this._timerSocketNames[this.numActions - 1].setText(this.getNewSocketName(action));
            }
            this._timerSocketNames[this.numActions - 1].setEnabled(true);
            this._timerDelays[this.numActions - 1].setEnabled(true);
            if (this.numActions >= 10) {
                this._addTimer.setEnabled(false);
            }
            this._removeTimer.setEnabled(true);
        });
        if (this.numActions >= 10) {
            this._addTimer.setEnabled(false);
        }
        this._removeTimer = new JButton(Bundle.getMessage("ActionTimerSwing_RemoveTimer"));
        this._removeTimer.addActionListener(e -> {
            this._timerSocketNames[this.numActions - 1].setEnabled(false);
            this._timerDelays[this.numActions - 1].setEnabled(false);
            --this.numActions;
            this._numTimers.setText(Integer.toString(this.numActions));
            this._addTimer.setEnabled(true);
            if (this.numActions <= 1 || action.getNumActions() >= this.numActions && action.getActionSocket(this.numActions - 1).isConnected()) {
                this._removeTimer.setEnabled(false);
            }
        });
        if (this.numActions <= 1 || action.getActionSocket(this.numActions - 1).isConnected()) {
            this._removeTimer.setEnabled(false);
        }
        numActionsPanel.add(new JLabel(Bundle.getMessage("ActionTimerSwing_NumTimers")));
        numActionsPanel.add(this._numTimers);
        numActionsPanel.add(this._addTimer);
        numActionsPanel.add(this._removeTimer);
        JPanel timerDelaysPanel = new JPanel();
        timerDelaysPanel.setLayout(new BoxLayout(timerDelaysPanel, 1));
        timerDelaysPanel.add(new JLabel(Bundle.getMessage("ActionTimerSwing_TimerDelays")));
        JPanel timerDelaysSubPanel = new JPanel();
        this._timerSocketNames = new JTextField[10];
        this._timerDelays = new JTextField[10];
        for (int i = 0; i < 10; ++i) {
            JPanel delayPanel = new JPanel();
            delayPanel.setLayout(new BoxLayout(delayPanel, 1));
            this._timerDelays[i] = new JTextField("0");
            this._timerDelays[i].setColumns(7);
            this._timerDelays[i].setEnabled(false);
            delayPanel.add(this._timerDelays[i]);
            this._timerSocketNames[i] = new JTextField();
            this._timerSocketNames[i].setEnabled(false);
            delayPanel.add(this._timerSocketNames[i]);
            timerDelaysSubPanel.add(delayPanel);
            if (i >= action.getNumActions()) continue;
            String socketName = action.getActionSocket(i).getName();
            this._timerSocketNames[i].setText(socketName);
            this._timerSocketNames[i].setEnabled(true);
            this._timerDelays[i].setText(Integer.toString(action.getDelay(i)));
            this._timerDelays[i].setEnabled(true);
        }
        timerDelaysPanel.add(timerDelaysSubPanel);
        this.panel.add(optionsPanel);
        this.panel.add(numActionsPanel);
        this.panel.add(timerDelaysPanel);
        this._startImmediately.setSelected(action.isStartImmediately());
        this._runContinuously.setSelected(action.isRunContinuously());
        this._startAndStopByStartExpression.setSelected(action.isStartAndStopByStartExpression());
        this._numTimers.setText(Integer.toString(action.getNumActions()));
        this.updateEnableDisabled();
    }

    private void updateEnableDisabled() {
        this._delayLocalVariablePrefix.setEnabled(this._delayByLocalVariables.isSelected());
        for (int i = 0; i < 10; ++i) {
            this._timerDelays[i].setEnabled(!this._delayByLocalVariables.isSelected());
        }
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        ActionTimer tempAction = new ActionTimer("IQDA1", null);
        tempAction.setNumActions(this.numActions);
        for (int i = 0; i < this.numActions; ++i) {
            if (!tempAction.getActionSocket(i).validateName(this._timerSocketNames[i].getText())) {
                errorMessages.add(Bundle.getMessage("InvalidSocketName", this._timerSocketNames[i].getText()));
            }
            try {
                tempAction.setDelay(i, Integer.parseInt(this._timerDelays[i].getText()));
                if (tempAction.getDelay(i) >= 0) continue;
                errorMessages.add(Bundle.getMessage("ActionTimerSwing_NegativeDelay", this._timerDelays[i].getText(), this._timerSocketNames[i].getText()));
                continue;
            }
            catch (NumberFormatException e) {
                errorMessages.add(Bundle.getMessage("ActionTimerSwing_InvalidDelay", this._timerDelays[i].getText(), this._timerSocketNames[i].getText()));
            }
        }
        return errorMessages.isEmpty();
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionTimer action = new ActionTimer(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof ActionTimer)) {
            throw new IllegalArgumentException("object must be an ActionTimer but is a: " + object.getClass().getName());
        }
        ActionTimer action = (ActionTimer)object;
        action.setStartImmediately(this._startImmediately.isSelected());
        action.setRunContinuously(this._runContinuously.isSelected());
        action.setStartAndStopByStartExpression(this._startAndStopByStartExpression.isSelected());
        action.setUnit(this._unitComboBox.getItemAt(this._unitComboBox.getSelectedIndex()));
        action.setDelayByLocalVariables(this._delayByLocalVariables.isSelected());
        action.setDelayLocalVariablePrefix(this._delayLocalVariablePrefix.getText());
        action.setNumActions(this.numActions);
        for (int i = 0; i < this.numActions; ++i) {
            action.getActionSocket(i).setName(this._timerSocketNames[i].getText());
            action.setDelay(i, Integer.parseInt(this._timerDelays[i].getText()));
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ActionTimer_Short");
    }

    @Override
    public void dispose() {
    }
}

