/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.ShowDialog;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.actions.swing.ShowDialogTableModel;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;

public class ShowDialogSwing
extends AbstractDigitalActionSwing {
    private List<ButtonCheckBox> _buttonCheckBoxes;
    private JComboBox<ShowDialog.FormatType> _formatType;
    private JTextField _format;
    private JTable _showDialogTable;
    private ShowDialogTableModel _showDialogTableModel;
    private JCheckBox _modalCheckBox;
    private JCheckBox _multiLineCheckBox;
    private JTextField _localVariableForSelectedButton;
    private JTextField _localVariableForInputString;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        if (object != null && !(object instanceof ShowDialog)) {
            throw new IllegalArgumentException("object is not a ShowDialog: " + object.getClass().getName());
        }
        ShowDialog showDialog = (ShowDialog)object;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JPanel buttonCheckBoxPanel = new JPanel();
        buttonCheckBoxPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ShowDialog_Buttons")));
        this._buttonCheckBoxes = new ArrayList<ButtonCheckBox>();
        for (ShowDialog.Button button : ShowDialog.Button.values()) {
            ButtonCheckBox buttonCheckBox = new ButtonCheckBox(button, new JCheckBox(Integer.toString(button.getValue()) + ": " + button.toString()));
            this._buttonCheckBoxes.add(buttonCheckBox);
            buttonCheckBoxPanel.add(buttonCheckBox._checkBox);
            if (showDialog == null || !showDialog.getEnabledButtons().contains((Object)button)) continue;
            buttonCheckBox._checkBox.setSelected(true);
        }
        this.panel.add(buttonCheckBoxPanel);
        JPanel formatTypePanel = new JPanel();
        this._formatType = new JComboBox();
        for (ShowDialog.FormatType formatType : ShowDialog.FormatType.values()) {
            this._formatType.addItem(formatType);
        }
        formatTypePanel.add(new JLabel(Bundle.getMessage("ShowDialog_FormatType")));
        formatTypePanel.add(this._formatType);
        this.panel.add(formatTypePanel);
        JPanel formatPanel = new JPanel();
        this._format = new JTextField(40);
        formatPanel.add(new JLabel(Bundle.getMessage("ShowDialog_Format")));
        formatPanel.add(this._format);
        this.panel.add(formatPanel);
        this._showDialogTable = new JTable();
        if (showDialog != null) {
            ArrayList<ShowDialog.Data> dataList = new ArrayList<ShowDialog.Data>(showDialog.getDataList());
            this._showDialogTableModel = new ShowDialogTableModel(dataList);
        } else {
            this._showDialogTableModel = new ShowDialogTableModel(null);
        }
        this._showDialogTable.setModel(this._showDialogTableModel);
        this._showDialogTable.setDefaultRenderer(ShowDialog.DataType.class, new ShowDialogTableModel.CellRenderer());
        this._showDialogTable.setDefaultEditor(ShowDialog.DataType.class, new ShowDialogTableModel.DataTypeCellEditor());
        this._showDialogTableModel.setColumnsForComboBoxes(this._showDialogTable);
        this._showDialogTable.setDefaultRenderer(JButton.class, new ButtonRenderer());
        this._showDialogTable.setDefaultEditor(JButton.class, new ButtonEditor(new JButton()));
        JButton testButton = new JButton("XXXXXX");
        this._showDialogTable.setRowHeight(testButton.getPreferredSize().height);
        TableColumn deleteColumn = this._showDialogTable.getColumnModel().getColumn(3);
        deleteColumn.setMinWidth(testButton.getPreferredSize().width);
        deleteColumn.setMaxWidth(testButton.getPreferredSize().width);
        deleteColumn.setResizable(false);
        TableColumn dummyColumn = this._showDialogTable.getColumnModel().getColumn(3);
        dummyColumn.setMinWidth(0);
        dummyColumn.setPreferredWidth(0);
        dummyColumn.setMaxWidth(0);
        JScrollPane scrollpane = new JScrollPane(this._showDialogTable);
        scrollpane.setPreferredSize(new Dimension(400, 200));
        this.panel.add(scrollpane);
        JButton add = new JButton(Bundle.getMessage("ShowDialog_TableAdd"));
        buttonPanel.add(add);
        add.addActionListener(e -> this._showDialogTableModel.add());
        this._modalCheckBox = new JCheckBox(Bundle.getMessage("ShowDialog_Modal"));
        this.panel.add(this._modalCheckBox);
        this._multiLineCheckBox = new JCheckBox(Bundle.getMessage("ShowDialog_Multiline"));
        this.panel.add(this._multiLineCheckBox);
        this.panel.add(new JLabel(Bundle.getMessage("ShowDialog_MultilineHelp")));
        JPanel localVariableForSelectedButtonPanel = new JPanel();
        this._localVariableForSelectedButton = new JTextField(20);
        localVariableForSelectedButtonPanel.add(new JLabel(Bundle.getMessage("ShowDialog_LocalVariableForSelectedButton")));
        localVariableForSelectedButtonPanel.add(this._localVariableForSelectedButton);
        this.panel.add(localVariableForSelectedButtonPanel);
        JPanel localVariableForInputStringPanel = new JPanel();
        this._localVariableForInputString = new JTextField(20);
        localVariableForInputStringPanel.add(new JLabel(Bundle.getMessage("ShowDialog_LocalVariableForInputString")));
        localVariableForInputStringPanel.add(this._localVariableForInputString);
        this.panel.add(localVariableForInputStringPanel);
        if (showDialog != null) {
            this._modalCheckBox.setSelected(showDialog.getModal());
            this._multiLineCheckBox.setSelected(showDialog.getMultiLine());
            this._localVariableForSelectedButton.setText(showDialog.getLocalVariableForSelectedButton());
            this._localVariableForInputString.setText(showDialog.getLocalVariableForInputString());
            this._formatType.setSelectedItem((Object)showDialog.getFormatType());
            this._format.setText(showDialog.getFormat());
        }
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        boolean result = true;
        boolean hasEnabledButton = false;
        for (ButtonCheckBox buttonCheckBox : this._buttonCheckBoxes) {
            hasEnabledButton |= buttonCheckBox._checkBox.isSelected();
        }
        if (!hasEnabledButton) {
            errorMessages.add(Bundle.getMessage("ShowDialog_ErrorNoEnabledButton"));
            result = false;
        }
        for (ShowDialog.Data data : this._showDialogTableModel.getDataList()) {
            if (data.getDataType() != ShowDialog.DataType.Formula) continue;
            try {
                HashMap<String, Variable> variables = new HashMap<String, Variable>();
                RecursiveDescentParser parser = new RecursiveDescentParser(variables);
                parser.parseExpression(data.getData());
            }
            catch (ParserException e) {
                errorMessages.add(e.getLocalizedMessage());
                result = false;
            }
        }
        return result;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ShowDialog action = new ShowDialog(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof ShowDialog)) {
            throw new IllegalArgumentException("object is not a ShowDialog: " + object.getClass().getName());
        }
        ShowDialog showDialog = (ShowDialog)object;
        Set<ShowDialog.Button> enabledButtons = showDialog.getEnabledButtons();
        enabledButtons.clear();
        for (ButtonCheckBox buttonCheckBox : this._buttonCheckBoxes) {
            if (!buttonCheckBox._checkBox.isSelected()) continue;
            enabledButtons.add(buttonCheckBox._button);
        }
        showDialog.setLocalVariableForSelectedButton(this._localVariableForSelectedButton.getText());
        showDialog.setLocalVariableForInputString(this._localVariableForInputString.getText());
        showDialog.setFormatType(this._formatType.getItemAt(this._formatType.getSelectedIndex()));
        showDialog.setFormat(this._format.getText());
        showDialog.setModal(this._modalCheckBox.isSelected());
        showDialog.setMultiLine(this._multiLineCheckBox.isSelected());
        showDialog.setFormatType(this._formatType.getItemAt(this._formatType.getSelectedIndex()));
        showDialog.setFormat(this._format.getText());
        this._showDialogTable.editCellAt(0, 2);
        showDialog.getDataList().clear();
        for (ShowDialog.Data data : this._showDialogTableModel.getDataList()) {
            showDialog.getDataList().add(data);
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ShowDialog_Short");
    }

    @Override
    public void setDefaultValues() {
        boolean hasEnabledButton = false;
        for (ButtonCheckBox buttonCheckBox : this._buttonCheckBoxes) {
            hasEnabledButton |= buttonCheckBox._checkBox.isSelected();
        }
        if (!hasEnabledButton) {
            this._buttonCheckBoxes.get((int)0)._checkBox.setSelected(true);
        }
    }

    @Override
    public void dispose() {
    }

    private static class ButtonCheckBox {
        private final ShowDialog.Button _button;
        private final JCheckBox _checkBox;

        private ButtonCheckBox(ShowDialog.Button button, JCheckBox checkBox) {
            this._button = button;
            this._checkBox = checkBox;
        }
    }
}

