/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.WebRequest;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.actions.swing.WebRequestTableModel;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectCharsetSwing;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectEnumSwing;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectStringSwing;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;

public class WebRequestSwing
extends AbstractDigitalActionSwing {
    private JTabbedPane _tabbedPane;
    private JPanel _panelUrl;
    private JPanel _panelCharset;
    private JPanel _panelRequestMethod;
    private JPanel _panelUserAgent;
    private LogixNG_SelectStringSwing _selectUrlSwing;
    private LogixNG_SelectCharsetSwing _selectCharsetSwing;
    private LogixNG_SelectEnumSwing<WebRequest.RequestMethodType> _selectRequestMethodSwing;
    private LogixNG_SelectStringSwing _selectUserAgentSwing;
    private JTextField _localVariableForResponseCodeTextField;
    private JTextField _localVariableForReplyContentTextField;
    private JTextField _localVariableForCookiesTextField;
    private JTable _logDataTable;
    private WebRequestTableModel _logDataTableModel;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        JPanel tabbedPaneUserAgent;
        JPanel tabbedPaneRequestMethod;
        JPanel tabbedPaneCharset;
        JPanel tabbedPaneUrl;
        if (object != null && !(object instanceof WebRequest)) {
            throw new IllegalArgumentException("object must be an WebRequest but is a: " + object.getClass().getName());
        }
        this._tabbedPane = new JTabbedPane();
        this._panelUrl = new JPanel();
        this._panelCharset = new JPanel();
        this._panelRequestMethod = new JPanel();
        this._panelUserAgent = new JPanel();
        this._selectUrlSwing = new LogixNG_SelectStringSwing(this.getJDialog(), this);
        this._selectCharsetSwing = new LogixNG_SelectCharsetSwing(this.getJDialog(), this);
        this._selectRequestMethodSwing = new LogixNG_SelectEnumSwing(this.getJDialog(), this);
        this._selectUserAgentSwing = new LogixNG_SelectStringSwing(this.getJDialog(), this);
        WebRequest action = (WebRequest)object;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        if (action != null) {
            tabbedPaneUrl = this._selectUrlSwing.createPanel(action.getSelectUrl());
            tabbedPaneCharset = this._selectCharsetSwing.createPanel(action.getSelectCharset());
            tabbedPaneRequestMethod = this._selectRequestMethodSwing.createPanel(action.getSelectRequestMethod(), WebRequest.RequestMethodType.values());
            tabbedPaneUserAgent = this._selectUserAgentSwing.createPanel(action.getSelectUserAgent());
        } else {
            tabbedPaneUrl = this._selectUrlSwing.createPanel(null);
            tabbedPaneCharset = this._selectCharsetSwing.createPanel(null);
            tabbedPaneRequestMethod = this._selectRequestMethodSwing.createPanel(null, WebRequest.RequestMethodType.values());
            tabbedPaneUserAgent = this._selectUserAgentSwing.createPanel(null);
        }
        JLabel selectUrlLabel = new JLabel(Bundle.getMessage("WebRequestSwing_Url"));
        selectUrlLabel.setLabelFor(tabbedPaneUrl);
        JLabel selectCharsetLabel = new JLabel(Bundle.getMessage("WebRequestSwing_Charset"));
        selectCharsetLabel.setLabelFor(tabbedPaneCharset);
        JLabel selectRequestMethodLabel = new JLabel(Bundle.getMessage("WebRequestSwing_RequestMethod"));
        selectRequestMethodLabel.setLabelFor(tabbedPaneRequestMethod);
        JLabel selectUserAgentLabel = new JLabel(Bundle.getMessage("WebRequestSwing_UserAgent"));
        selectUserAgentLabel.setLabelFor(tabbedPaneUserAgent);
        this._panelUrl.add(selectUrlLabel);
        this._panelUrl.add(tabbedPaneUrl);
        this._panelCharset.add(selectCharsetLabel);
        this._panelCharset.add(tabbedPaneCharset);
        this._panelRequestMethod.add(selectRequestMethodLabel);
        this._panelRequestMethod.add(tabbedPaneRequestMethod);
        this._panelUserAgent.add(selectUserAgentLabel);
        this._panelUserAgent.add(tabbedPaneUserAgent);
        this._tabbedPane.addTab(Bundle.getMessage("WebRequestSwing_Url"), this._panelUrl);
        this._tabbedPane.addTab(Bundle.getMessage("WebRequestSwing_Charset"), this._panelCharset);
        this._tabbedPane.addTab(Bundle.getMessage("WebRequestSwing_RequestMethod"), this._panelRequestMethod);
        this._tabbedPane.addTab(Bundle.getMessage("WebRequestSwing_UserAgent"), this._panelUserAgent);
        JLabel localVariableForResponseCodeLabel = new JLabel(Bundle.getMessage("WebRequestSwing_LocalVariableForResponseCode"));
        this._localVariableForResponseCodeTextField = new JTextField();
        this._localVariableForResponseCodeTextField.setColumns(30);
        JLabel localVariableForReplyContentLabel = new JLabel(Bundle.getMessage("WebRequestSwing_LocalVariableForReplyContent"));
        this._localVariableForReplyContentTextField = new JTextField();
        this._localVariableForReplyContentTextField.setColumns(30);
        JLabel localVariableForCookiesLabel = new JLabel(Bundle.getMessage("WebRequestSwing_LocalVariableForCookies"));
        this._localVariableForCookiesTextField = new JTextField();
        this._localVariableForCookiesTextField.setColumns(30);
        this._logDataTable = new JTable();
        if (action != null) {
            ArrayList<WebRequest.Parameter> dataList = new ArrayList<WebRequest.Parameter>(action.getParameters());
            this._logDataTableModel = new WebRequestTableModel(dataList);
        } else {
            this._logDataTableModel = new WebRequestTableModel(null);
        }
        this._logDataTable.setModel(this._logDataTableModel);
        this._logDataTable.setDefaultRenderer(SymbolTable.InitialValueType.class, new WebRequestTableModel.CellRenderer());
        this._logDataTable.setDefaultEditor(SymbolTable.InitialValueType.class, new WebRequestTableModel.DataTypeCellEditor());
        this._logDataTableModel.setColumnsForComboBoxes(this._logDataTable);
        this._logDataTable.setDefaultRenderer(JButton.class, new ButtonRenderer());
        this._logDataTable.setDefaultEditor(JButton.class, new ButtonEditor(new JButton()));
        JButton testButton = new JButton("XXXXXX");
        this._logDataTable.setRowHeight(testButton.getPreferredSize().height);
        TableColumn deleteColumn = this._logDataTable.getColumnModel().getColumn(4);
        deleteColumn.setMinWidth(testButton.getPreferredSize().width);
        deleteColumn.setMaxWidth(testButton.getPreferredSize().width);
        deleteColumn.setResizable(false);
        TableColumn dummyColumn = this._logDataTable.getColumnModel().getColumn(4);
        dummyColumn.setMinWidth(0);
        dummyColumn.setPreferredWidth(0);
        dummyColumn.setMaxWidth(0);
        JScrollPane scrollpane = new JScrollPane(this._logDataTable);
        scrollpane.setPreferredSize(new Dimension(400, 200));
        JButton add = new JButton(Bundle.getMessage("WebRequest_TableAdd"));
        buttonPanel.add(add);
        add.addActionListener(e -> this._logDataTableModel.add());
        JLabel parametersLabel = new JLabel(Bundle.getMessage("WebRequest_Parameters"));
        parametersLabel.setAlignmentX(0.0f);
        scrollpane.setAlignmentX(0.0f);
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 3));
        tablePanel.add(parametersLabel);
        tablePanel.add(scrollpane);
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints constraint = new GridBagConstraints();
        Insets defaultInsets = constraint.insets;
        constraint.gridwidth = 1;
        constraint.gridheight = 1;
        constraint.gridx = 0;
        constraint.gridy = 0;
        constraint.gridwidth = 2;
        constraint.anchor = 10;
        this.panel.add((Component)this._tabbedPane, constraint);
        constraint.gridy = 1;
        constraint.insets = new Insets(10, 0, 10, 0);
        this.panel.add((Component)tablePanel, constraint);
        constraint.gridwidth = 1;
        constraint.gridy = 2;
        constraint.anchor = 13;
        constraint.insets = defaultInsets;
        this.panel.add((Component)localVariableForResponseCodeLabel, constraint);
        localVariableForResponseCodeLabel.setLabelFor(this._localVariableForResponseCodeTextField);
        constraint.gridy = 3;
        this.panel.add((Component)localVariableForReplyContentLabel, constraint);
        localVariableForReplyContentLabel.setLabelFor(this._localVariableForReplyContentTextField);
        constraint.gridy = 4;
        this.panel.add((Component)localVariableForCookiesLabel, constraint);
        localVariableForCookiesLabel.setLabelFor(this._localVariableForCookiesTextField);
        constraint.gridx = 1;
        constraint.gridy = 2;
        constraint.anchor = 13;
        this.panel.add((Component)this._localVariableForResponseCodeTextField, constraint);
        constraint.gridy = 3;
        this.panel.add((Component)this._localVariableForReplyContentTextField, constraint);
        constraint.gridy = 4;
        this.panel.add((Component)this._localVariableForCookiesTextField, constraint);
        if (action != null) {
            this._localVariableForResponseCodeTextField.setText(action.getLocalVariableForResponseCode());
            this._localVariableForReplyContentTextField.setText(action.getLocalVariableForReplyContent());
            this._localVariableForCookiesTextField.setText(action.getLocalVariableForCookies());
        }
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        WebRequest action = new WebRequest("IQDA1", null);
        this._selectUrlSwing.validate(action.getSelectUrl(), errorMessages);
        this._selectCharsetSwing.validate(action.getSelectCharset(), errorMessages);
        this._selectRequestMethodSwing.validate(action.getSelectRequestMethod(), errorMessages);
        this._selectUserAgentSwing.validate(action.getSelectUserAgent(), errorMessages);
        for (WebRequest.Parameter data : this._logDataTableModel.getDataList()) {
            if (data.getType() != SymbolTable.InitialValueType.Formula) continue;
            try {
                HashMap<String, Variable> variables = new HashMap<String, Variable>();
                RecursiveDescentParser parser = new RecursiveDescentParser(variables);
                parser.parseExpression(data.getData());
            }
            catch (ParserException e) {
                errorMessages.add(e.getLocalizedMessage());
            }
        }
        return errorMessages.isEmpty();
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        WebRequest action = new WebRequest(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof WebRequest)) {
            throw new IllegalArgumentException("object must be an WebRequest but is a: " + object.getClass().getName());
        }
        WebRequest action = (WebRequest)object;
        this._selectUrlSwing.updateObject(action.getSelectUrl());
        this._selectCharsetSwing.updateObject(action.getSelectCharset());
        this._selectRequestMethodSwing.updateObject(action.getSelectRequestMethod());
        this._selectUserAgentSwing.updateObject(action.getSelectUserAgent());
        action.setLocalVariableForResponseCode(this._localVariableForResponseCodeTextField.getText());
        action.setLocalVariableForReplyContent(this._localVariableForReplyContentTextField.getText());
        action.setLocalVariableForCookies(this._localVariableForCookiesTextField.getText());
        this._logDataTable.editCellAt(0, 2);
        action.getParameters().clear();
        for (WebRequest.Parameter data : this._logDataTableModel.getDataList()) {
            action.getParameters().add(data);
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("WebRequest_Short");
    }

    @Override
    public void dispose() {
        this._selectUrlSwing.dispose();
        this._selectCharsetSwing.dispose();
        this._selectRequestMethodSwing.dispose();
        this._selectUserAgentSwing.dispose();
    }
}

