/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.WebRequest;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.util.swing.JComboBoxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRequestTableModel
extends AbstractTableModel {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_DATA = 2;
    public static final int COLUMN_DELETE = 3;
    public static final int COLUMN_DUMMY = 4;
    private final List<WebRequest.Parameter> _parameterList = new ArrayList<WebRequest.Parameter>();
    private static final Logger log = LoggerFactory.getLogger(WebRequestTableModel.class);

    public WebRequestTableModel(Collection<WebRequest.Parameter> namedBeanReference) {
        if (namedBeanReference != null) {
            this._parameterList.addAll(namedBeanReference);
        }
    }

    @Override
    public int getRowCount() {
        return this._parameterList.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("WebRequest_ColumnName");
            }
            case 1: {
                return Bundle.getMessage("WebRequest_ColumnType");
            }
            case 2: {
                return Bundle.getMessage("WebRequest_ColumnData");
            }
            case 3: {
                return "";
            }
            case 4: {
                return "";
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: {
                return SymbolTable.InitialValueType.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return JButton.class;
            }
            case 4: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        WebRequest.Parameter ref = this._parameterList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                ref.setName((String)value);
                break;
            }
            case 1: {
                if (value != null) {
                    SymbolTable.InitialValueType oldType = ref.getType();
                    ref.setType((SymbolTable.InitialValueType)((Object)value));
                    if (oldType == ref.getType()) break;
                    ref.setData("");
                    break;
                }
                log.debug("Cannot set data type to null");
                break;
            }
            case 2: {
                ref.setData((String)value);
                break;
            }
            case 3: {
                this.delete(rowIndex);
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid column");
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this._parameterList.size()) {
            throw new IllegalArgumentException("Invalid row");
        }
        switch (columnIndex) {
            case 0: {
                return this._parameterList.get(rowIndex).getName();
            }
            case 1: {
                return this._parameterList.get(rowIndex).getType();
            }
            case 2: {
                return this._parameterList.get(rowIndex).getData();
            }
            case 3: {
                return Bundle.getMessage("ButtonDelete");
            }
            case 4: {
                return "";
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    public void setColumnsForComboBoxes(JTable table) {
        JComboBox beanTypeComboBox = new JComboBox();
        table.setRowHeight(beanTypeComboBox.getPreferredSize().height);
        table.getColumnModel().getColumn(1).setPreferredWidth(beanTypeComboBox.getPreferredSize().width + 4);
    }

    public void add() {
        int row = this._parameterList.size();
        this._parameterList.add(new WebRequest.Parameter("", SymbolTable.InitialValueType.LocalVariable, ""));
        this.fireTableRowsInserted(row, row);
    }

    private void delete(int row) {
        this._parameterList.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public List<WebRequest.Parameter> getDataList() {
        return this._parameterList;
    }

    public static class DataTypeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private SymbolTable.InitialValueType _beanType;

        @Override
        public Object getCellEditorValue() {
            return this._beanType;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                value = SymbolTable.InitialValueType.LocalVariable;
            }
            if (!(value instanceof SymbolTable.InitialValueType)) {
                throw new IllegalArgumentException("value is not an InitialValueType: " + value.getClass().getName());
            }
            JComboBox<SymbolTable.InitialValueType> returnValueTypeComboBox = new JComboBox<SymbolTable.InitialValueType>();
            for (SymbolTable.InitialValueType type : SymbolTable.InitialValueType.values()) {
                returnValueTypeComboBox.addItem(type);
            }
            JComboBoxUtil.setupComboBoxMaxRows(returnValueTypeComboBox);
            returnValueTypeComboBox.setSelectedItem(value);
            returnValueTypeComboBox.addActionListener(this);
            return returnValueTypeComboBox;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!(event.getSource() instanceof JComboBox)) {
                throw new IllegalArgumentException("value is not an JComboBox: " + event.getSource().getClass().getName());
            }
            JComboBox returnValueTypeComboBox = (JComboBox)event.getSource();
            this._beanType = (SymbolTable.InitialValueType)((Object)returnValueTypeComboBox.getItemAt(returnValueTypeComboBox.getSelectedIndex()));
        }
    }

    public static class CellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 1) {
                if (value == null) {
                    value = SymbolTable.InitialValueType.LocalVariable;
                }
                if (!(value instanceof SymbolTable.InitialValueType)) {
                    throw new IllegalArgumentException("value is not an InitialValueType: " + value.getClass().getName());
                }
            } else {
                throw new RuntimeException("Unknown column: " + Integer.toString(column));
            }
            this.setText(((SymbolTable.InitialValueType)((Object)value)).toString());
            return this;
        }
    }
}

