/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrit.logixng.AnalogExpressionBean;
import jmri.jmrit.logixng.AnalogExpressionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnalogExpression
extends AbstractBase
implements AnalogExpressionBean {
    private Base _parent = null;
    private int _state = 1;
    boolean _triggerOnChange = true;
    private static final Logger log = LoggerFactory.getLogger(AbstractAnalogExpression.class);

    public AbstractAnalogExpression(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        Manager.NameValidity isNameValid = InstanceManager.getDefault(AnalogExpressionManager.class).validSystemNameFormat(this.mSystemName);
        if (isNameValid != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("system name is not valid");
        }
    }

    @Override
    public Base getParent() {
        return this._parent;
    }

    @Override
    public void setParent(Base parent) {
        this._parent = parent;
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameAnalogExpression");
    }

    @Override
    public void setState(int s) throws JmriException {
        log.warn("Unexpected call to setState in AbstractAnalogExpression.");
        this._state = s;
    }

    @Override
    public int getState() {
        log.warn("Unexpected call to getState in AbstractAnalogExpression.");
        return this._state;
    }

    @Override
    public void setTriggerOnChange(boolean triggerOnChange) {
        this._triggerOnChange = triggerOnChange;
    }

    @Override
    public boolean getTriggerOnChange() {
        return this._triggerOnChange;
    }

    public String getNewSocketName() {
        for (int x = 1; x < 10000; ++x) {
            String name = "E" + Integer.toString(x);
            boolean validName = true;
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (!name.equals(this.getChild(i).getName())) continue;
                validName = false;
                break;
            }
            if (!validName) continue;
            return name;
        }
        throw new RuntimeException("Unable to find a new socket name");
    }
}

