/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalExpressionBean;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDigitalExpression
extends AbstractBase
implements DigitalExpressionBean {
    private Base _parent = null;
    private int _state = 1;
    private static final Logger log = LoggerFactory.getLogger(AbstractDigitalExpression.class);

    public AbstractDigitalExpression(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        Manager.NameValidity isNameValid = InstanceManager.getDefault(DigitalExpressionManager.class).validSystemNameFormat(this.mSystemName);
        if (isNameValid != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("system name is not valid");
        }
    }

    @Override
    public void notifyChangedResult(boolean oldResult, boolean newResult) {
        this.firePropertyChange("LastResultChanged", oldResult, newResult);
    }

    @Override
    public Base getParent() {
        return this._parent;
    }

    @Override
    public void setParent(Base parent) {
        this._parent = parent;
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameDigitalExpression");
    }

    @Override
    public void setState(int s) throws JmriException {
        log.warn("Unexpected call to setState in AbstractDigitalExpression.");
        this._state = s;
    }

    @Override
    public int getState() {
        log.warn("Unexpected call to getState in AbstractDigitalExpression.");
        return this._state;
    }

    public String getNewSocketName() {
        String[] names = new String[this.getChildCount()];
        for (int i = 0; i < this.getChildCount(); ++i) {
            names[i] = this.getChild(i).getName();
        }
        return AbstractDigitalExpression.getNewSocketName(names);
    }

    public static String getNewSocketName(String[] names) {
        for (int x = 1; x < 10000; ++x) {
            String name = "E" + Integer.toString(x);
            boolean validName = true;
            for (int i = 0; i < names.length; ++i) {
                if (!name.equals(names[i])) continue;
                validName = false;
                break;
            }
            if (!validName) continue;
            return name;
        }
        throw new RuntimeException("Unable to find a new socket name");
    }
}

