/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.AnalogExpressionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.expressions.AbstractAnalogExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.util.LogixNG_SelectString;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalogExpressionLocalVariable
extends AbstractAnalogExpression
implements PropertyChangeListener {
    private final LogixNG_SelectString _selectNamedBean = new LogixNG_SelectString(this, this);
    private static final Logger log = LoggerFactory.getLogger(AnalogExpressionLocalVariable.class);

    public AnalogExpressionLocalVariable(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        AnalogExpressionManager manager = InstanceManager.getDefault(AnalogExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        AnalogExpressionLocalVariable copy = new AnalogExpressionLocalVariable(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public LogixNG_SelectString getSelectNamedBean() {
        return this._selectNamedBean;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public double evaluate() throws JmriException {
        String localVariable = this._selectNamedBean.evaluateValue(this.getConditionalNG());
        if (localVariable == null) {
            return 0.0;
        }
        Object value = this.getConditionalNG().getSymbolTable().getValue(localVariable);
        if (value != null) {
            return TypeConversionUtil.convertToDouble(value, false);
        }
        return 0.0;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "AnalogExpressionLocalVariable_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "AnalogExpressionLocalVariable_Long", this._selectNamedBean.getDescription(locale));
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.getTriggerOnChange()) {
            this.getConditionalNG().execute();
        }
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: AnalogExpressionLocalVariable: bean = {}, report = {}", (Object)cdl, report);
    }
}

