/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.AnalogExpressionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleGenericExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.FemaleSocketOperation;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.expressions.AbstractAnalogExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.implementation.DefaultFemaleGenericExpressionSocket;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.GenericExpressionVariable;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalogFormula
extends AbstractAnalogExpression
implements FemaleSocketListener {
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private final List<ExpressionEntry> _expressionEntries = new ArrayList<ExpressionEntry>();
    private boolean _disableCheckForUnconnectedSocket = false;
    private static final Logger log = LoggerFactory.getLogger(AnalogFormula.class);

    public AnalogFormula(@Nonnull String sys, @CheckForNull String user) {
        super(sys, user);
        this._expressionEntries.add(new ExpressionEntry(this.createFemaleSocket(this, this, this.getNewSocketName())));
    }

    public AnalogFormula(@Nonnull String sys, @CheckForNull String user, List<SocketData> expressionSystemNames) {
        super(sys, user);
        this.setExpressionSystemNames(expressionSystemNames);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        AnalogExpressionManager manager = InstanceManager.getDefault(AnalogExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        AnalogFormula copy = new AnalogFormula(sysName, userName);
        copy.setComment(this.getComment());
        copy.setNumSockets(this.getChildCount());
        copy.setFormula(this._formula);
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    private void setExpressionSystemNames(List<SocketData> systemNames) {
        if (!this._expressionEntries.isEmpty()) {
            throw new RuntimeException("expression system names cannot be set more than once");
        }
        for (SocketData socketData : systemNames) {
            FemaleGenericExpressionSocket socket = this.createFemaleSocket(this, this, socketData._socketName);
            this._expressionEntries.add(new ExpressionEntry(socket, socketData._socketSystemName, socketData._manager));
        }
    }

    public String getExpressionSystemName(int index) {
        return this._expressionEntries.get((int)index)._socketSystemName;
    }

    public String getExpressionManager(int index) {
        return this._expressionEntries.get((int)index)._manager;
    }

    private FemaleGenericExpressionSocket createFemaleSocket(Base parent, FemaleSocketListener listener, String socketName) {
        return new DefaultFemaleGenericExpressionSocket(FemaleGenericExpressionSocket.SocketType.GENERIC, parent, listener, socketName);
    }

    public final void setFormula(String formula) throws ParserException {
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        RecursiveDescentParser parser = new RecursiveDescentParser(variables);
        for (int i = 0; i < this.getChildCount(); ++i) {
            GenericExpressionVariable v = new GenericExpressionVariable((FemaleGenericExpressionSocket)this.getChild(i));
            variables.put(v.getName(), v);
        }
        this._expressionNode = parser.parseExpression(formula);
        this._formula = formula;
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() {
        try {
            this.setFormula(this._formula);
        }
        catch (ParserException e) {
            log.error("Unexpected exception when parsing the formula", (Throwable)e);
        }
    }

    @Override
    public Category getCategory() {
        return Category.COMMON;
    }

    @Override
    public double evaluate() throws JmriException {
        if (this._formula.isEmpty()) {
            return 0.0;
        }
        return TypeConversionUtil.convertToDouble(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false);
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        return this._expressionEntries.get((int)index)._socket;
    }

    @Override
    public int getChildCount() {
        return this._expressionEntries.size();
    }

    public void setChildCount(int count) {
        ArrayList<FemaleGenericExpressionSocket> addList = new ArrayList<FemaleGenericExpressionSocket>();
        ArrayList<FemaleGenericExpressionSocket> removeList = new ArrayList<FemaleGenericExpressionSocket>();
        while (this._expressionEntries.size() > count) {
            int childNo = this._expressionEntries.size() - 1;
            FemaleGenericExpressionSocket socket = this._expressionEntries.get((int)childNo)._socket;
            if (socket.isConnected()) {
                socket.disconnect();
            }
            removeList.add(this._expressionEntries.get((int)childNo)._socket);
            this._expressionEntries.remove(childNo);
        }
        while (this._expressionEntries.size() < count) {
            FemaleGenericExpressionSocket socket = this.createFemaleSocket(this, this, this.getNewSocketName());
            this._expressionEntries.add(new ExpressionEntry(socket));
            addList.add(socket);
        }
        this.parseFormula();
        this.firePropertyChange("ChildCount", removeList, addList);
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "AnalogFormula_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        if (this._formula.isEmpty()) {
            return Bundle.getMessage(locale, "AnalogFormula_Long_Empty");
        }
        return Bundle.getMessage(locale, "AnalogFormula_Long", this._formula);
    }

    private void setNumSockets(int num) {
        ArrayList<FemaleGenericExpressionSocket> addList = new ArrayList<FemaleGenericExpressionSocket>();
        while (this._expressionEntries.size() < num) {
            FemaleGenericExpressionSocket socket = this.createFemaleSocket(this, this, this.getNewSocketName());
            this._expressionEntries.add(new ExpressionEntry(socket));
            addList.add(socket);
        }
        this.parseFormula();
        this.firePropertyChange("ChildCount", null, addList);
    }

    private void checkFreeSocket() {
        boolean hasFreeSocket = false;
        for (ExpressionEntry entry : this._expressionEntries) {
            hasFreeSocket |= !entry._socket.isConnected();
        }
        if (!hasFreeSocket) {
            FemaleGenericExpressionSocket socket = this.createFemaleSocket(this, this, this.getNewSocketName());
            this._expressionEntries.add(new ExpressionEntry(socket));
            ArrayList<FemaleGenericExpressionSocket> list = new ArrayList<FemaleGenericExpressionSocket>();
            list.add(socket);
            this.parseFormula();
            this.firePropertyChange("ChildCount", null, list);
        }
    }

    @Override
    public boolean isSocketOperationAllowed(int index, FemaleSocketOperation oper) {
        switch (oper) {
            case Remove: {
                return !this.getChild(index).isConnected();
            }
            case InsertBefore: {
                return true;
            }
            case InsertAfter: {
                return true;
            }
            case MoveUp: {
                return index > 0;
            }
            case MoveDown: {
                return index + 1 < this.getChildCount();
            }
        }
        throw new UnsupportedOperationException("Oper is unknown" + oper.name());
    }

    private void insertNewSocket(int index) {
        FemaleGenericExpressionSocket socket = this.createFemaleSocket(this, this, this.getNewSocketName());
        this._expressionEntries.add(index, new ExpressionEntry(socket));
        ArrayList<FemaleGenericExpressionSocket> addList = new ArrayList<FemaleGenericExpressionSocket>();
        addList.add(socket);
        this.parseFormula();
        this.firePropertyChange("ChildCount", null, addList);
    }

    private void removeSocket(int index) {
        ArrayList<FemaleGenericExpressionSocket> removeList = new ArrayList<FemaleGenericExpressionSocket>();
        removeList.add(this._expressionEntries.remove((int)index)._socket);
        this.parseFormula();
        this.firePropertyChange("ChildCount", removeList, null);
    }

    private void moveSocketDown(int index) {
        ExpressionEntry temp = this._expressionEntries.get(index);
        this._expressionEntries.set(index, this._expressionEntries.get(index + 1));
        this._expressionEntries.set(index + 1, temp);
        ArrayList<FemaleGenericExpressionSocket> list = new ArrayList<FemaleGenericExpressionSocket>();
        list.add(this._expressionEntries.get((int)index)._socket);
        list.add(this._expressionEntries.get((int)index)._socket);
        this.parseFormula();
        this.firePropertyChange("ChildReorder", null, list);
    }

    @Override
    public void doSocketOperation(int index, FemaleSocketOperation oper) {
        switch (oper) {
            case Remove: {
                if (this.getChild(index).isConnected()) {
                    throw new UnsupportedOperationException("Socket is connected");
                }
                this.removeSocket(index);
                break;
            }
            case InsertBefore: {
                this.insertNewSocket(index);
                break;
            }
            case InsertAfter: {
                this.insertNewSocket(index + 1);
                break;
            }
            case MoveUp: {
                if (index == 0) {
                    throw new UnsupportedOperationException("cannot move up first child");
                }
                this.moveSocketDown(index - 1);
                break;
            }
            case MoveDown: {
                if (index + 1 == this.getChildCount()) {
                    throw new UnsupportedOperationException("cannot move down last child");
                }
                this.moveSocketDown(index);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Oper is unknown" + oper.name());
            }
        }
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (this._disableCheckForUnconnectedSocket) {
            return;
        }
        for (ExpressionEntry entry : this._expressionEntries) {
            if (socket != entry._socket) continue;
            entry._socketSystemName = socket.getConnectedSocket().getSystemName();
            entry._manager = socket.getConnectedSocket().getManager().getClass().getName();
        }
        this.checkFreeSocket();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        for (ExpressionEntry entry : this._expressionEntries) {
            if (socket != entry._socket) continue;
            entry._socketSystemName = null;
            entry._manager = null;
            break;
        }
    }

    @Override
    public void socketNameChanged(FemaleSocket socket) {
        this.parseFormula();
    }

    @Override
    public void setup() {
        this._disableCheckForUnconnectedSocket = true;
        for (ExpressionEntry ee : this._expressionEntries) {
            try {
                if (!ee._socket.isConnected() || !ee._socket.getConnectedSocket().getSystemName().equals(ee._socketSystemName)) {
                    String socketSystemName = ee._socketSystemName;
                    String manager = ee._manager;
                    ee._socket.disconnect();
                    if (socketSystemName == null) continue;
                    Manager<? extends MaleSocket> m = InstanceManager.getDefault(LogixNG_Manager.class).getManager(manager);
                    MaleSocket maleSocket = m.getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        ee._socket.connect(maleSocket);
                        maleSocket.setup();
                        continue;
                    }
                    log.error("cannot load analog expression {}", (Object)socketSystemName);
                    continue;
                }
                ee._socket.getConnectedSocket().setup();
            }
            catch (SocketAlreadyConnectedException ex) {
                throw new RuntimeException("socket is already connected");
            }
        }
        this.parseFormula();
        this.checkFreeSocket();
        this._disableCheckForUnconnectedSocket = false;
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: Expression AnalogFormula: bean = {}, f = \"{}\", cdl = {}", new Object[]{bean, this.getFormula(), cdl});
        if (bean != null) {
            String formula = this.getFormula();
            String uname = bean.getUserName();
            if (formula.contains(bean.getSystemName()) || uname != null && formula.contains(uname)) {
                report.add(new NamedBeanUsageReport("LogixNGExpression", cdl, this.getLongDescription()));
            }
        }
    }

    public static class ExpressionEntry {
        private final FemaleGenericExpressionSocket _socket;
        private String _socketSystemName;
        public String _manager;

        public ExpressionEntry(FemaleGenericExpressionSocket socket, String socketSystemName, String manager) {
            this._socket = socket;
            this._socketSystemName = socketSystemName;
            this._manager = manager;
        }

        private ExpressionEntry(FemaleGenericExpressionSocket socket) {
            this._socket = socket;
        }
    }

    public static class SocketData {
        public final String _socketName;
        public final String _socketSystemName;
        public final String _manager;

        public SocketData(String socketName, String socketSystemName, String manager) {
            this._socketName = socketName;
            this._socketSystemName = socketSystemName;
            this._manager = manager;
        }
    }
}

