/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.FemaleSocketOperation;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Antecedent
extends AbstractDigitalExpression
implements FemaleSocketListener {
    static final ResourceBundle rbx = ResourceBundle.getBundle("jmri.jmrit.conditional.ConditionalBundle");
    private String _antecedent = "";
    private final List<ExpressionEntry> _expressionEntries = new ArrayList<ExpressionEntry>();
    private boolean disableCheckForUnconnectedSocket = false;
    private static final Logger log = LoggerFactory.getLogger(Antecedent.class);

    public Antecedent(@Nonnull String sys, @CheckForNull String user) {
        super(sys, user);
        this._expressionEntries.add(new ExpressionEntry(InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, this.getNewSocketName())));
    }

    public Antecedent(@Nonnull String sys, @CheckForNull String user, List<Map.Entry<String, String>> expressionSystemNames) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this.setExpressionSystemNames(expressionSystemNames);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        Antecedent copy = new Antecedent(sysName, userName);
        copy.setComment(this.getComment());
        copy.setNumSockets(this.getChildCount());
        copy.setAntecedent(this._antecedent);
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    private void setExpressionSystemNames(List<Map.Entry<String, String>> systemNames) {
        if (!this._expressionEntries.isEmpty()) {
            throw new RuntimeException("expression system names cannot be set more than once");
        }
        for (Map.Entry<String, String> entry : systemNames) {
            FemaleDigitalExpressionSocket socket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, entry.getKey());
            this._expressionEntries.add(new ExpressionEntry(socket, entry.getValue()));
        }
    }

    public String getExpressionSystemName(int index) {
        return this._expressionEntries.get((int)index)._socketSystemName;
    }

    @Override
    public Category getCategory() {
        return Category.COMMON;
    }

    @Override
    public boolean evaluate() throws JmriException {
        boolean result;
        if (this._antecedent.isEmpty()) {
            return false;
        }
        char[] ch = this._antecedent.toCharArray();
        int n = 0;
        for (int j = 0; j < ch.length; ++j) {
            if (ch[j] == ' ') continue;
            if (ch[j] == '{' || ch[j] == '[') {
                ch[j] = 40;
            } else if (ch[j] == '}' || ch[j] == ']') {
                ch[j] = 41;
            }
            ch[n++] = ch[j];
        }
        try {
            ArrayList<ExpressionEntry> list = new ArrayList<ExpressionEntry>();
            for (ExpressionEntry e : this._expressionEntries) {
                list.add(e);
            }
            DataPair dp = this.parseCalculate(new String(ch, 0, n), list);
            result = dp.result;
        }
        catch (IndexOutOfBoundsException | NumberFormatException | JmriException nfe) {
            result = false;
            log.error("{} parseCalculation error antecedent= {}, ex= {}: {}", new Object[]{this.getDisplayName(), this._antecedent, nfe.getClass().getName(), nfe.getMessage()});
        }
        return result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        return this._expressionEntries.get((int)index)._socket;
    }

    @Override
    public int getChildCount() {
        return this._expressionEntries.size();
    }

    public void setChildCount(int count) {
        ArrayList<FemaleDigitalExpressionSocket> addList = new ArrayList<FemaleDigitalExpressionSocket>();
        ArrayList<FemaleDigitalExpressionSocket> removeList = new ArrayList<FemaleDigitalExpressionSocket>();
        while (this._expressionEntries.size() > count) {
            int childNo = this._expressionEntries.size() - 1;
            FemaleDigitalExpressionSocket socket = this._expressionEntries.get((int)childNo)._socket;
            if (socket.isConnected()) {
                socket.disconnect();
            }
            removeList.add(this._expressionEntries.get((int)childNo)._socket);
            this._expressionEntries.remove(childNo);
        }
        while (this._expressionEntries.size() < count) {
            FemaleDigitalExpressionSocket socket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, this.getNewSocketName());
            this._expressionEntries.add(new ExpressionEntry(socket));
            addList.add(socket);
        }
        this.firePropertyChange("ChildCount", removeList, addList);
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Antecedent_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        if (this._antecedent.isEmpty()) {
            return Bundle.getMessage(locale, "Antecedent_Long_Empty");
        }
        return Bundle.getMessage(locale, "Antecedent_Long", this._antecedent);
    }

    public String getAntecedent() {
        return this._antecedent;
    }

    public final void setAntecedent(String antecedent) throws JmriException {
        this._antecedent = antecedent;
    }

    private void setNumSockets(int num) {
        ArrayList<FemaleDigitalExpressionSocket> addList = new ArrayList<FemaleDigitalExpressionSocket>();
        while (this._expressionEntries.size() < num) {
            FemaleDigitalExpressionSocket socket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, this.getNewSocketName());
            this._expressionEntries.add(new ExpressionEntry(socket));
            addList.add(socket);
        }
        this.firePropertyChange("ChildCount", null, addList);
    }

    private void checkFreeSocket() {
        boolean hasFreeSocket = false;
        for (ExpressionEntry entry : this._expressionEntries) {
            hasFreeSocket |= !entry._socket.isConnected();
        }
        if (!hasFreeSocket) {
            FemaleDigitalExpressionSocket socket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, this.getNewSocketName());
            this._expressionEntries.add(new ExpressionEntry(socket));
            ArrayList<FemaleDigitalExpressionSocket> list = new ArrayList<FemaleDigitalExpressionSocket>();
            list.add(socket);
            this.firePropertyChange("ChildCount", null, list);
        }
    }

    @Override
    public boolean isSocketOperationAllowed(int index, FemaleSocketOperation oper) {
        switch (oper) {
            case Remove: {
                return !this.getChild(index).isConnected();
            }
            case InsertBefore: {
                return true;
            }
            case InsertAfter: {
                return true;
            }
            case MoveUp: {
                return index > 0;
            }
            case MoveDown: {
                return index + 1 < this.getChildCount();
            }
        }
        throw new UnsupportedOperationException("Oper is unknown" + oper.name());
    }

    private void insertNewSocket(int index) {
        FemaleDigitalExpressionSocket socket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, this.getNewSocketName());
        this._expressionEntries.add(index, new ExpressionEntry(socket));
        ArrayList<FemaleDigitalExpressionSocket> addList = new ArrayList<FemaleDigitalExpressionSocket>();
        addList.add(socket);
        this.firePropertyChange("ChildCount", null, addList);
    }

    private void removeSocket(int index) {
        ArrayList<FemaleDigitalExpressionSocket> removeList = new ArrayList<FemaleDigitalExpressionSocket>();
        removeList.add(this._expressionEntries.remove((int)index)._socket);
        this.firePropertyChange("ChildCount", removeList, null);
    }

    private void moveSocketDown(int index) {
        ExpressionEntry temp = this._expressionEntries.get(index);
        this._expressionEntries.set(index, this._expressionEntries.get(index + 1));
        this._expressionEntries.set(index + 1, temp);
        ArrayList<FemaleDigitalExpressionSocket> list = new ArrayList<FemaleDigitalExpressionSocket>();
        list.add(this._expressionEntries.get((int)index)._socket);
        list.add(this._expressionEntries.get((int)index)._socket);
        this.firePropertyChange("ChildReorder", null, list);
    }

    @Override
    public void doSocketOperation(int index, FemaleSocketOperation oper) {
        switch (oper) {
            case Remove: {
                if (this.getChild(index).isConnected()) {
                    throw new UnsupportedOperationException("Socket is connected");
                }
                this.removeSocket(index);
                break;
            }
            case InsertBefore: {
                this.insertNewSocket(index);
                break;
            }
            case InsertAfter: {
                this.insertNewSocket(index + 1);
                break;
            }
            case MoveUp: {
                if (index == 0) {
                    throw new UnsupportedOperationException("cannot move up first child");
                }
                this.moveSocketDown(index - 1);
                break;
            }
            case MoveDown: {
                if (index + 1 == this.getChildCount()) {
                    throw new UnsupportedOperationException("cannot move down last child");
                }
                this.moveSocketDown(index);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Oper is unknown" + oper.name());
            }
        }
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (this.disableCheckForUnconnectedSocket) {
            return;
        }
        for (ExpressionEntry entry : this._expressionEntries) {
            if (socket != entry._socket) continue;
            entry._socketSystemName = socket.getConnectedSocket().getSystemName();
        }
        this.checkFreeSocket();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        for (ExpressionEntry entry : this._expressionEntries) {
            if (socket != entry._socket) continue;
            entry._socketSystemName = null;
            break;
        }
    }

    @Override
    public void setup() {
        this.disableCheckForUnconnectedSocket = true;
        for (ExpressionEntry ee : this._expressionEntries) {
            try {
                if (!ee._socket.isConnected() || !ee._socket.getConnectedSocket().getSystemName().equals(ee._socketSystemName)) {
                    String socketSystemName = ee._socketSystemName;
                    ee._socket.disconnect();
                    if (socketSystemName == null) continue;
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        ee._socket.connect(maleSocket);
                        maleSocket.setup();
                        continue;
                    }
                    log.error("cannot load digital expression {}", (Object)socketSystemName);
                    continue;
                }
                ee._socket.getConnectedSocket().setup();
            }
            catch (SocketAlreadyConnectedException ex) {
                throw new RuntimeException("socket is already connected");
            }
        }
        this.checkFreeSocket();
        this.disableCheckForUnconnectedSocket = false;
    }

    public String validateAntecedent(String ant, List<ExpressionEntry> expressionEntryList) throws JmriException {
        char[] ch = ant.toCharArray();
        int n = 0;
        for (int j = 0; j < ch.length; ++j) {
            if (ch[j] == ' ') continue;
            if (ch[j] == '{' || ch[j] == '[') {
                ch[j] = 40;
            } else if (ch[j] == '}' || ch[j] == ']') {
                ch[j] = 41;
            }
            ch[n++] = ch[j];
        }
        int count = 0;
        for (int j = 0; j < n; ++j) {
            if (ch[j] == '(') {
                ++count;
            }
            if (ch[j] != ')') continue;
            --count;
        }
        if (count > 0) {
            return MessageFormat.format(rbx.getString("ParseError7"), Character.valueOf(')'));
        }
        if (count < 0) {
            return MessageFormat.format(rbx.getString("ParseError7"), Character.valueOf('('));
        }
        try {
            DataPair dp = this.parseCalculate(new String(ch, 0, n), expressionEntryList);
            if (n != dp.indexCount) {
                return MessageFormat.format(rbx.getString("ParseError4"), Character.valueOf(ch[dp.indexCount - 1]));
            }
            int index = dp.argsUsed.nextClearBit(0);
            if (index >= 0 && index < expressionEntryList.size()) {
                return MessageFormat.format(rbx.getString("ParseError5"), expressionEntryList.size(), index + 1);
            }
        }
        catch (IndexOutOfBoundsException | NumberFormatException | JmriException nfe) {
            return rbx.getString("ParseError6") + nfe.getMessage();
        }
        return null;
    }

    DataPair parseCalculate(String s, List<ExpressionEntry> expressionEntryList) throws JmriException {
        s = s.toUpperCase();
        BitSet argsUsed = new BitSet(expressionEntryList.size());
        DataPair dp = null;
        boolean leftArg = false;
        boolean rightArg = false;
        int oper = 4;
        int k = -1;
        int i = 0;
        if (s.charAt(i) == '(') {
            dp = this.parseCalculate(s.substring(++i), expressionEntryList);
            leftArg = dp.result;
            i += dp.indexCount;
            argsUsed.or(dp.argsUsed);
        } else if (s.charAt(i) == 'R') {
            try {
                k = Integer.parseInt(String.valueOf(s.substring(i + 1, i + 3)));
                i += 2;
            }
            catch (IndexOutOfBoundsException | NumberFormatException nfe) {
                k = Integer.parseInt(String.valueOf(s.charAt(++i)));
            }
            leftArg = expressionEntryList.get((int)(k - 1))._socket.evaluate();
            ++i;
            argsUsed.set(k - 1);
        } else if ("NOT".equals(s.substring(i, i + 3))) {
            if (s.charAt(i += 3) == '(') {
                dp = this.parseCalculate(s.substring(++i), expressionEntryList);
                leftArg = dp.result;
                i += dp.indexCount;
                argsUsed.or(dp.argsUsed);
            } else if (s.charAt(i) == 'R') {
                try {
                    k = Integer.parseInt(String.valueOf(s.substring(i + 1, i + 3)));
                    i += 2;
                }
                catch (IndexOutOfBoundsException | NumberFormatException nfe) {
                    k = Integer.parseInt(String.valueOf(s.charAt(++i)));
                }
                leftArg = expressionEntryList.get((int)(k - 1))._socket.evaluate();
                ++i;
                argsUsed.set(k - 1);
            } else {
                throw new JmriException(MessageFormat.format(rbx.getString("ParseError1"), s.substring(i)));
            }
            leftArg = !leftArg;
        } else {
            throw new JmriException(MessageFormat.format(rbx.getString("ParseError9"), s));
        }
        while (i < s.length()) {
            if (s.charAt(i) != ')') {
                if ("AND".equals(s.substring(i, i + 3))) {
                    i += 3;
                    oper = 1;
                } else if ("OR".equals(s.substring(i, i + 2))) {
                    i += 2;
                    oper = 5;
                } else {
                    throw new JmriException(MessageFormat.format(rbx.getString("ParseError2"), s.substring(i)));
                }
                if (s.charAt(i) == '(') {
                    dp = this.parseCalculate(s.substring(++i), expressionEntryList);
                    rightArg = dp.result;
                    i += dp.indexCount;
                    argsUsed.or(dp.argsUsed);
                } else if (s.charAt(i) == 'R') {
                    try {
                        k = Integer.parseInt(String.valueOf(s.substring(i + 1, i + 3)));
                        i += 2;
                    }
                    catch (IndexOutOfBoundsException | NumberFormatException nfe) {
                        k = Integer.parseInt(String.valueOf(s.charAt(++i)));
                    }
                    rightArg = expressionEntryList.get((int)(k - 1))._socket.evaluate();
                    ++i;
                    argsUsed.set(k - 1);
                } else if ("NOT".equals(s.substring(i, i + 3))) {
                    if (s.charAt(i += 3) == '(') {
                        dp = this.parseCalculate(s.substring(++i), expressionEntryList);
                        rightArg = dp.result;
                        i += dp.indexCount;
                        argsUsed.or(dp.argsUsed);
                    } else if (s.charAt(i) == 'R') {
                        try {
                            k = Integer.parseInt(String.valueOf(s.substring(i + 1, i + 3)));
                            i += 2;
                        }
                        catch (IndexOutOfBoundsException | NumberFormatException nfe) {
                            k = Integer.parseInt(String.valueOf(s.charAt(++i)));
                        }
                        rightArg = expressionEntryList.get((int)(k - 1))._socket.evaluate();
                        ++i;
                        argsUsed.set(k - 1);
                    } else {
                        throw new JmriException(MessageFormat.format(rbx.getString("ParseError3"), s.substring(i)));
                    }
                    rightArg = !rightArg;
                } else {
                    throw new JmriException(MessageFormat.format(rbx.getString("ParseError9"), s.substring(i)));
                }
                if (oper == 1) {
                    leftArg = leftArg && rightArg;
                    continue;
                }
                if (oper != 5) continue;
                leftArg = leftArg || rightArg;
                continue;
            }
            ++i;
            break;
        }
        dp = new DataPair();
        dp.result = leftArg;
        dp.indexCount = i;
        dp.argsUsed = argsUsed;
        return dp;
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    public static class ExpressionEntry {
        private String _socketSystemName;
        private final FemaleDigitalExpressionSocket _socket;

        public ExpressionEntry(FemaleDigitalExpressionSocket socket, String socketSystemName) {
            this._socketSystemName = socketSystemName;
            this._socket = socket;
        }

        private ExpressionEntry(FemaleDigitalExpressionSocket socket) {
            this._socket = socket;
        }
    }

    static class DataPair {
        boolean result = false;
        int indexCount = 0;
        BitSet argsUsed = null;

        DataPair() {
        }
    }
}

