/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.jmrix.JmrixConfigPane;

public class ConnectionName
extends AbstractDigitalExpression
implements PropertyChangeListener {
    private String _manufacturer = JmrixConfigPane.NONE_SELECTED;
    private String _connectionName = JmrixConfigPane.NONE_SELECTED;

    public ConnectionName(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ConnectionName copy = new ConnectionName(sysName, userName);
        copy.setComment(this.getComment());
        copy._manufacturer = this._manufacturer;
        copy._connectionName = this._connectionName;
        return manager.registerExpression(copy);
    }

    public void setManufacturer(String manufacturer) {
        this._manufacturer = manufacturer;
    }

    public String getManufacturer() {
        return this._manufacturer;
    }

    public void setConnectionName(String name) {
        this._connectionName = name;
    }

    public String getConnectionName() {
        return this._connectionName;
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    @Override
    public boolean evaluate() throws JmriException {
        ConnectionConfigManager manager = InstanceManager.getDefault(ConnectionConfigManager.class);
        for (ConnectionConfig cc : manager.getConnections()) {
            if (!cc.getManufacturer().equals(this._manufacturer) || !cc.name().equals(this._connectionName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ConnectionName_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "ConnectionName_Long", this._manufacturer, this._connectionName);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }
}

