/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.ModuleManager;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.parser.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitalCallModule
extends AbstractDigitalExpression
implements PropertyChangeListener,
VetoableChangeListener {
    private final LogixNG_SelectNamedBean<Module> _selectNamedBean = new LogixNG_SelectNamedBean<Module>(this, Module.class, InstanceManager.getDefault(ModuleManager.class), this);
    private final List<Module.ParameterData> _parameterData = new ArrayList<Module.ParameterData>();
    private static final Logger log = LoggerFactory.getLogger(DigitalCallModule.class);

    public DigitalCallModule(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        DigitalCallModule copy = new DigitalCallModule(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        for (Module.ParameterData data : this._parameterData) {
            copy.addParameter(data.getName(), data.getInitialValueType(), data.getInitialValueData(), data.getReturnValueType(), data.getReturnValueData());
        }
        return manager.registerExpression(copy);
    }

    public LogixNG_SelectNamedBean<Module> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    @Override
    public Category getCategory() {
        return Category.FLOW_CONTROL;
    }

    public void returnSymbols(DefaultSymbolTable symbolTable, Collection<Module.ParameterData> symbolDefinitions) throws JmriException {
        block5: for (Module.ParameterData parameter : symbolDefinitions) {
            Object returnValue = symbolTable.getValue(parameter.getName());
            switch (parameter.getReturnValueType()) {
                case None: {
                    continue block5;
                }
                case LocalVariable: {
                    symbolTable.getPrevSymbolTable().setValue(parameter.getReturnValueData(), returnValue);
                    continue block5;
                }
                case Memory: {
                    Memory m = (Memory)InstanceManager.getDefault(MemoryManager.class).getNamedBean(parameter.getReturnValueData());
                    if (m == null) continue block5;
                    m.setValue(returnValue);
                    continue block5;
                }
            }
            log.error("definition.returnValueType has invalid value: {}", (Object)parameter.getReturnValueType().name());
            throw new IllegalArgumentException("definition._returnValueType has invalid value: " + parameter.getReturnValueType().name());
        }
    }

    @Override
    public boolean evaluate() throws JmriException {
        Module module = this._selectNamedBean.evaluateNamedBean(this.getConditionalNG());
        if (module == null) {
            return false;
        }
        FemaleSocket femaleSocket = module.getRootSocket();
        if (!(femaleSocket instanceof FemaleDigitalExpressionSocket)) {
            log.error("module.rootSocket is not a FemaleDigitalExpressionSocket");
            return false;
        }
        ConditionalNG conditionalNG = this.getConditionalNG();
        int currentStackPos = conditionalNG.getStack().getCount();
        DefaultSymbolTable newSymbolTable = new DefaultSymbolTable(conditionalNG);
        newSymbolTable.createSymbols(conditionalNG.getSymbolTable(), this._parameterData);
        newSymbolTable.createSymbols(module.getLocalVariables());
        conditionalNG.setSymbolTable(newSymbolTable);
        boolean result = ((FemaleDigitalExpressionSocket)femaleSocket).evaluate();
        this.returnSymbols(newSymbolTable, this._parameterData);
        conditionalNG.getStack().setCount(currentStackPos);
        conditionalNG.setSymbolTable(newSymbolTable.getPrevSymbolTable());
        return result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "DigitalCallModule_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String moduleName = this._selectNamedBean.getDescription(locale);
        return Bundle.getMessage(locale, "DigitalCallModule_Long", moduleName);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectNamedBean.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectNamedBean.unregisterListeners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    public void addParameter(String name, SymbolTable.InitialValueType initialValueType, String initialValueData, Module.ReturnValueType returnValueType, String returnValueData) {
        this._parameterData.add(new Module.ParameterData(name, initialValueType, initialValueData, returnValueType, returnValueData));
    }

    public List<Module.ParameterData> getParameterData() {
        return this._parameterData;
    }
}

