/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import jmri.Audio;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.Is_IsNot_Enum;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionAudio
extends AbstractDigitalExpression
implements PropertyChangeListener {
    private final LogixNG_SelectNamedBean<Audio> _selectNamedBean = new LogixNG_SelectNamedBean<Audio>(this, Audio.class, InstanceManager.getDefault(AudioManager.class), this);
    private boolean _hasChangedState = false;
    private Is_IsNot_Enum _is_IsNot = Is_IsNot_Enum.Is;
    private NamedBeanAddressing _stateAddressing = NamedBeanAddressing.Direct;
    private AudioState _audioState = AudioState.Initial;
    private String _stateReference = "";
    private String _stateLocalVariable = "";
    private String _stateFormula = "";
    private ExpressionNode _stateExpressionNode;
    private boolean _checkOnlyOnChange;
    private static final Logger log = LoggerFactory.getLogger(ExpressionAudio.class);

    public ExpressionAudio(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionAudio copy = new ExpressionAudio(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        copy.set_Is_IsNot(this._is_IsNot);
        copy.setStateAddressing(this._stateAddressing);
        copy.setBeanState(this._audioState);
        copy.setStateReference(this._stateReference);
        copy.setStateLocalVariable(this._stateLocalVariable);
        copy.setStateFormula(this._stateFormula);
        copy.setCheckOnlyOnChange(this._checkOnlyOnChange);
        return manager.registerExpression(copy);
    }

    public LogixNG_SelectNamedBean<Audio> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public void set_Is_IsNot(Is_IsNot_Enum is_IsNot) {
        this._is_IsNot = is_IsNot;
    }

    public Is_IsNot_Enum get_Is_IsNot() {
        return this._is_IsNot;
    }

    public void setStateAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._stateAddressing = addressing;
        this.parseStateFormula();
    }

    public NamedBeanAddressing getStateAddressing() {
        return this._stateAddressing;
    }

    public void setBeanState(AudioState state) {
        this._audioState = state;
    }

    public AudioState getBeanState() {
        return this._audioState;
    }

    public void setStateReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._stateReference = reference;
    }

    public String getStateReference() {
        return this._stateReference;
    }

    public void setStateLocalVariable(@Nonnull String localVariable) {
        this._stateLocalVariable = localVariable;
    }

    public String getStateLocalVariable() {
        return this._stateLocalVariable;
    }

    public void setStateFormula(@Nonnull String formula) throws ParserException {
        this._stateFormula = formula;
        this.parseStateFormula();
    }

    public String getStateFormula() {
        return this._stateFormula;
    }

    private void parseStateFormula() throws ParserException {
        if (this._stateAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._stateExpressionNode = parser.parseExpression(this._stateFormula);
        } else {
            this._stateExpressionNode = null;
        }
    }

    public void setCheckOnlyOnChange(boolean triggerOnlyOnChange) {
        this._checkOnlyOnChange = triggerOnlyOnChange;
    }

    public boolean isCheckOnlyOnChange() {
        return this._checkOnlyOnChange;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getNewState() throws JmriException {
        switch (this._stateAddressing) {
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._stateReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._stateLocalVariable), false);
            }
            case Formula: {
                return this._stateExpressionNode != null ? TypeConversionUtil.convertToString(this._stateExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._stateAddressing.name());
    }

    @Override
    public boolean evaluate() throws JmriException {
        Audio audio = this._selectNamedBean.evaluateNamedBean(this.getConditionalNG());
        if (audio == null) {
            return false;
        }
        AudioState checkAudioState = this._stateAddressing == NamedBeanAddressing.Direct ? this._audioState : AudioState.valueOf(this.getNewState());
        int currentState = audio.getState();
        if (this._checkOnlyOnChange && !this._hasChangedState) {
            return false;
        }
        this._hasChangedState = false;
        if (this._is_IsNot == Is_IsNot_Enum.Is) {
            return currentState == checkAudioState.getID();
        }
        return currentState != checkAudioState.getID();
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Audio_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String state;
        String namedBean = this._selectNamedBean.getDescription(locale);
        switch (this._stateAddressing) {
            case Direct: {
                state = Bundle.getMessage(locale, "AddressByDirect", this._audioState._text);
                break;
            }
            case Reference: {
                state = Bundle.getMessage(locale, "AddressByReference", this._stateReference);
                break;
            }
            case LocalVariable: {
                state = Bundle.getMessage(locale, "AddressByLocalVariable", this._stateLocalVariable);
                break;
            }
            case Formula: {
                state = Bundle.getMessage(locale, "AddressByFormula", this._stateFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._stateAddressing.name());
            }
        }
        if (this._checkOnlyOnChange) {
            return Bundle.getMessage(locale, "Audio_Long4", namedBean, this._is_IsNot.toString(), state, Bundle.getMessage(locale, "Audio_CheckOnlyOnChange"));
        }
        return Bundle.getMessage(locale, "Audio_Long3", namedBean, this._is_IsNot.toString(), state);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            this._selectNamedBean.addPropertyChangeListener(this);
            this._selectNamedBean.registerListeners();
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._selectNamedBean.removePropertyChangeListener(this);
            this._selectNamedBean.unregisterListeners();
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!Objects.equals(evt.getNewValue(), evt.getOldValue())) {
            this._hasChangedState = true;
        }
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ExpressionAudio: bean = {}, report = {}", (Object)cdl, report);
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Expression);
    }

    public static enum AudioState {
        Initial(0, Bundle.getMessage("Audio_StateInitial")),
        Stopped(16, Bundle.getMessage("Audio_StateStopped")),
        Playing(17, Bundle.getMessage("Audio_StatePlaying")),
        Empty(32, Bundle.getMessage("Audio_StateEmpty")),
        Loaded(33, Bundle.getMessage("Audio_StateLoaded")),
        Positioned(48, Bundle.getMessage("Audio_StatePositioned")),
        Moving(49, Bundle.getMessage("Audio_StateMoving"));

        private final int _id;
        private final String _text;

        private AudioState(int id, String text) {
            this._id = id;
            this._text = text;
        }

        public int getID() {
            return this._id;
        }

        public String toString() {
            return this._text;
        }
    }
}

