/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.Is_IsNot_Enum;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.LogixNG_SelectString;
import jmri.jmrit.logixng.util.parser.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionBlock
extends AbstractDigitalExpression
implements PropertyChangeListener {
    private final LogixNG_SelectNamedBean<Block> _selectNamedBean = new LogixNG_SelectNamedBean<Block>(this, Block.class, InstanceManager.getDefault(BlockManager.class), this);
    private Is_IsNot_Enum _is_IsNot = Is_IsNot_Enum.Is;
    private final LogixNG_SelectEnum<BlockState> _selectEnum = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])BlockState.values(), (Enum)BlockState.Occupied, (PropertyChangeListener)this);
    private final LogixNG_SelectString _selectBlockValue = new LogixNG_SelectString(this, this);
    private static final Logger log = LoggerFactory.getLogger(ExpressionBlock.class);

    public ExpressionBlock(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionBlock copy = new ExpressionBlock(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        this._selectEnum.copy(copy._selectEnum);
        this._selectBlockValue.copy(copy._selectBlockValue);
        copy.set_Is_IsNot(this._is_IsNot);
        return manager.registerExpression(copy);
    }

    public LogixNG_SelectNamedBean<Block> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectEnum<BlockState> getSelectEnum() {
        return this._selectEnum;
    }

    public LogixNG_SelectString getSelectBlockValue() {
        return this._selectBlockValue;
    }

    public void set_Is_IsNot(Is_IsNot_Enum is_IsNot) {
        this._is_IsNot = is_IsNot;
    }

    public Is_IsNot_Enum get_Is_IsNot() {
        return this._is_IsNot;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    public boolean isBlockAllocated(Block block) {
        boolean result = false;
        LayoutBlock layoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(block);
        if (layoutBlock != null) {
            result = layoutBlock.getUseExtraColor();
        }
        return result;
    }

    @Override
    public boolean evaluate() throws JmriException {
        ConditionalNG conditionalNG = this.getConditionalNG();
        Block block = this._selectNamedBean.evaluateNamedBean(conditionalNG);
        if (block == null) {
            return false;
        }
        BlockState checkBlockState = this._selectEnum.evaluateEnum(conditionalNG);
        int currentState = block.getState();
        switch (checkBlockState) {
            case Other: {
                if (currentState != 2 && currentState != 4) {
                    currentState = BlockState.Other.getID();
                    break;
                }
                currentState = 0;
                break;
            }
            case Allocated: {
                boolean cuurrentAllocation = this.isBlockAllocated(block);
                currentState = cuurrentAllocation ? BlockState.Allocated.getID() : 0;
                break;
            }
            case ValueMatches: {
                String blockValue = this._selectBlockValue.evaluateValue(conditionalNG);
                currentState = blockValue.equals(block.getValue()) ? BlockState.ValueMatches.getID() : 0;
                break;
            }
        }
        if (this._is_IsNot == Is_IsNot_Enum.Is) {
            return currentState == checkBlockState.getID();
        }
        return currentState != checkBlockState.getID();
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Block_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String state;
        String namedBean = this._selectNamedBean.getDescription(locale);
        if (this._selectEnum.isDirectAddressing()) {
            BlockState blockState = this._selectEnum.getEnum();
            if (blockState == BlockState.ValueMatches) {
                String bundleKey = "Block_Long_Value";
                String equalsString = this._is_IsNot == Is_IsNot_Enum.Is ? Bundle.getMessage("Block_Equal") : Bundle.getMessage("Block_NotEqual");
                return Bundle.getMessage(locale, bundleKey, namedBean, equalsString, this._selectBlockValue.getDescription(locale));
            }
            if (blockState == BlockState.Other) {
                String state2 = Bundle.getMessage(locale, "AddressByDirect", blockState._text);
                return Bundle.getMessage(locale, "Block_Long", namedBean, "", state2);
            }
            state = Bundle.getMessage(locale, "AddressByDirect", blockState._text);
        } else {
            state = this._selectEnum.getDescription(locale);
        }
        return Bundle.getMessage(locale, "Block_Long", namedBean, this._is_IsNot.toString(), state);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            this._selectNamedBean.addPropertyChangeListener(this);
            this._selectNamedBean.registerListeners();
            this._selectEnum.registerListeners();
            this._selectBlockValue.registerListeners();
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._selectNamedBean.removePropertyChangeListener(this);
            this._selectNamedBean.unregisterListeners();
            this._selectEnum.unregisterListeners();
            this._selectBlockValue.unregisterListeners();
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ExpressionBlock: bean = {}, report = {}", (Object)cdl, report);
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Expression);
    }

    public static enum BlockState {
        Occupied(2, Bundle.getMessage("Block_StateOccupied")),
        NotOccupied(4, Bundle.getMessage("Block_StateNotOccupied")),
        Other(-1, Bundle.getMessage("Block_StateOther")),
        Allocated(-2, Bundle.getMessage("Block_Allocated")),
        ValueMatches(-3, Bundle.getMessage("Block_ValueMatches"));

        private final int _id;
        private final String _text;

        private BlockState(int id, String text) {
            this._id = id;
            this._text = text;
        }

        public int getID() {
            return this._id;
        }

        public String toString() {
            return this._text;
        }
    }
}

