/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimerTask;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Timebase;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.Is_IsNot_Enum;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionClock
extends AbstractDigitalExpression
implements PropertyChangeListener {
    private Is_IsNot_Enum _is_IsNot = Is_IsNot_Enum.Is;
    private Type _type = Type.FastClock;
    private Timebase _fastClock;
    private int _beginTime = 0;
    private int _endTime = 0;
    TimerTask timerTask = null;
    private int milisInAMinute = 60000;
    private static final Logger log = LoggerFactory.getLogger(ExpressionClock.class);

    public ExpressionClock(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionClock copy = new ExpressionClock(sysName, userName);
        copy.setComment(this.getComment());
        copy.set_Is_IsNot(this._is_IsNot);
        copy.setType(this._type);
        copy.setRange(this._beginTime, this._endTime);
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    public void set_Is_IsNot(Is_IsNot_Enum is_IsNot) {
        this._is_IsNot = is_IsNot;
    }

    public Is_IsNot_Enum get_Is_IsNot() {
        return this._is_IsNot;
    }

    public void setType(Type type) {
        this.assertListenersAreNotRegistered(log, "setType");
        this._type = type;
        this._fastClock = this._type == Type.FastClock ? InstanceManager.getDefault(Timebase.class) : null;
    }

    public Type getType() {
        return this._type;
    }

    public void setRange(int beginTime, int endTime) {
        this.assertListenersAreNotRegistered(log, "setRange");
        this._beginTime = beginTime;
        this._endTime = endTime;
    }

    public int getBeginTime() {
        return this._beginTime;
    }

    public int getEndTime() {
        return this._endTime;
    }

    public static String formatTime(int minutes) {
        String hhmm = "00:00";
        if (minutes >= 0 && minutes < 1440) {
            hhmm = String.format("%02d:%02d", minutes / 60, minutes % 60);
        }
        return hhmm;
    }

    @Override
    public boolean evaluate() {
        boolean result;
        Calendar currentTime = null;
        switch (this._type) {
            case SystemClock: {
                currentTime = Calendar.getInstance();
                break;
            }
            case FastClock: {
                if (this._fastClock == null) {
                    return false;
                }
                currentTime = Calendar.getInstance();
                currentTime.setTime(this._fastClock.getTime());
                break;
            }
            default: {
                throw new UnsupportedOperationException("_type has unknown value: " + this._type.name());
            }
        }
        int currentMinutes = currentTime.get(11) * 60 + currentTime.get(12);
        if (this._beginTime <= this._endTime) {
            result = this._beginTime <= currentMinutes && currentMinutes <= this._endTime;
        } else {
            boolean bl = result = this._beginTime <= currentMinutes || currentMinutes <= this._endTime;
        }
        if (this._is_IsNot == Is_IsNot_Enum.Is) {
            return result;
        }
        return !result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Clock_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        switch (this._type) {
            case SystemClock: {
                return Bundle.getMessage(locale, "Clock_Long_SystemClock", this._is_IsNot.toString(), ExpressionClock.formatTime(this._beginTime), ExpressionClock.formatTime(this._endTime));
            }
            case FastClock: {
                return Bundle.getMessage(locale, "Clock_Long_FastClock", this._is_IsNot.toString(), ExpressionClock.formatTime(this._beginTime), ExpressionClock.formatTime(this._endTime));
            }
        }
        throw new RuntimeException("Unknown value of _timerType: " + this._type.name());
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            switch (this._type) {
                case SystemClock: {
                    this.scheduleTimer();
                    break;
                }
                case FastClock: {
                    this._fastClock.addPropertyChangeListener("time", this);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("_type has unknown value: " + this._type.name());
                }
            }
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            switch (this._type) {
                case SystemClock: {
                    if (this.timerTask == null) break;
                    this.timerTask.cancel();
                    break;
                }
                case FastClock: {
                    if (this._fastClock == null) break;
                    this._fastClock.removePropertyChangeListener("time", this);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("_type has unknown value: " + this._type.name());
                }
            }
            this._listenersAreRegistered = false;
        }
    }

    private void scheduleTimer() {
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                ExpressionClock.this.propertyChange(null);
            }
        };
        TimerUtil.schedule(this.timerTask, System.currentTimeMillis() % (long)this.milisInAMinute, (long)this.milisInAMinute);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
    }

    public static enum Type {
        FastClock(Bundle.getMessage("ClockTypeFastClock")),
        SystemClock(Bundle.getMessage("ClockTypeSystemClock"));

        private final String _text;

        private Type(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

