/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimerTask;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.Is_IsNot_Enum;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.util.ProtectedTimerTask;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.TimerUtil;

public class ExpressionLinuxLinePower
extends AbstractDigitalExpression
implements PropertyChangeListener {
    private Is_IsNot_Enum _is_IsNot = Is_IsNot_Enum.Is;
    private ProtectedTimerTask _timerTask;
    private final int _delay = 5;
    private boolean _lastResult;
    private JmriException _thrownException;

    public ExpressionLinuxLinePower(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        try {
            this._lastResult = this.internalEvaluate();
        }
        catch (JmriException e) {
            this._thrownException = e;
        }
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionLinuxLinePower copy = new ExpressionLinuxLinePower(sysName, userName);
        copy.setComment(this.getComment());
        copy.set_Is_IsNot(this._is_IsNot);
        return manager.registerExpression(copy);
    }

    public void set_Is_IsNot(Is_IsNot_Enum is_IsNot) {
        this._is_IsNot = is_IsNot;
    }

    public Is_IsNot_Enum get_Is_IsNot() {
        return this._is_IsNot;
    }

    @Override
    public Category getCategory() {
        return Category.LINUX;
    }

    private List<String> getLinuxPowerSupplies() throws IOException, NoPowerSuppliesException {
        ArrayList<String> powerSupplies = new ArrayList<String>();
        Process process = Runtime.getRuntime().exec(new String[]{"upower", "-e"});
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = buffer.readLine()) != null) {
                powerSupplies.add(line);
            }
        }
        if (powerSupplies.isEmpty()) {
            throw new NoPowerSuppliesException();
        }
        return powerSupplies;
    }

    public boolean isLinePowerOnline() throws IOException, JmriException {
        boolean isPowerOnline = false;
        for (String powerSupply : this.getLinuxPowerSupplies()) {
            Process process = Runtime.getRuntime().exec(new String[]{"upower", "-i", powerSupply});
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                boolean linePowerFound = false;
                while ((line = buffer.readLine()) != null) {
                    if (line.isBlank()) continue;
                    if (!line.startsWith("  ")) {
                        throw new JmriException("Unknown string. It doesn't start with two spaces.");
                    }
                    line = line.substring(2);
                    if ("line-power".equals(line)) {
                        linePowerFound = true;
                        continue;
                    }
                    if (line.startsWith("  ")) {
                        String[] parts;
                        line = line.substring(2);
                        if (!linePowerFound || !line.startsWith("online:") || !"yes".equals((parts = line.split("\\s+"))[1])) continue;
                        isPowerOnline = true;
                        continue;
                    }
                    linePowerFound = false;
                }
            }
        }
        return isPowerOnline;
    }

    private boolean internalEvaluate() throws JmriException {
        try {
            if (this._is_IsNot == Is_IsNot_Enum.Is) {
                return this.isLinePowerOnline();
            }
            return !this.isLinePowerOnline();
        }
        catch (IOException e) {
            throw new JmriException("IO Exception: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean evaluate() throws JmriException {
        if (this._thrownException != null) {
            JmriException e = this._thrownException;
            this._thrownException = null;
            throw e;
        }
        return this.internalEvaluate();
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "LinuxLinePower_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "LinuxLinePower_Long", this._is_IsNot.toString());
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            this._timerTask = new ProtectedTimerTask(){

                @Override
                public void execute() {
                    try {
                        boolean _lastLastResult = ExpressionLinuxLinePower.this._lastResult;
                        ExpressionLinuxLinePower.this._lastResult = ExpressionLinuxLinePower.this.internalEvaluate();
                        if (ExpressionLinuxLinePower.this._lastResult != _lastLastResult) {
                            ExpressionLinuxLinePower.this.getConditionalNG().execute();
                        }
                    }
                    catch (JmriException e) {
                        ExpressionLinuxLinePower.this._thrownException = e;
                    }
                }
            };
            TimerUtil.schedule((TimerTask)this._timerTask, 5000L, 5000L);
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._timerTask.cancel();
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    public static class NoPowerSuppliesException
    extends JmriException {
        public NoPowerSuppliesException() {
            super(Bundle.getMessage("LinuxLinePower_NoPowerSuppliesException"));
        }
    }
}

