/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.LogixNG_SelectTable;
import jmri.util.CompareUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionLocalVariable
extends AbstractDigitalExpression
implements PropertyChangeListener {
    private String _localVariable;
    private VariableOperation _variableOperation = VariableOperation.Equal;
    private CompareUtil.CompareType _compareType = CompareUtil.CompareType.NumberOrString;
    private CompareTo _compareTo = CompareTo.Value;
    private boolean _caseInsensitive = false;
    private String _constantValue = "";
    private final LogixNG_SelectNamedBean<Memory> _selectMemoryNamedBean = new LogixNG_SelectNamedBean<Memory>(this, Memory.class, InstanceManager.getDefault(MemoryManager.class), this);
    private String _otherLocalVariable = "";
    private String _regEx = "";
    private boolean _listenToMemory = true;
    private final LogixNG_SelectTable _selectTable = new LogixNG_SelectTable(this, () -> this._compareTo == CompareTo.Table);
    private static final Logger log = LoggerFactory.getLogger(ExpressionLocalVariable.class);

    public ExpressionLocalVariable(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionLocalVariable copy = new ExpressionLocalVariable(sysName, userName);
        copy.setComment(this.getComment());
        copy.setLocalVariable(this._localVariable);
        copy.setVariableOperation(this._variableOperation);
        copy.setCompareType(this._compareType);
        copy.setCompareTo(this._compareTo);
        copy.setCaseInsensitive(this._caseInsensitive);
        copy.setConstantValue(this._constantValue);
        this._selectMemoryNamedBean.copy(copy._selectMemoryNamedBean);
        copy.setOtherLocalVariable(this._otherLocalVariable);
        copy.setRegEx(this._regEx);
        this._selectTable.copy(copy._selectTable);
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public LogixNG_SelectNamedBean<Memory> getSelectMemoryNamedBean() {
        return this._selectMemoryNamedBean;
    }

    public void setLocalVariable(String variableName) {
        this.assertListenersAreNotRegistered(log, "setLocalVariable");
        this._localVariable = variableName;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setOtherLocalVariable(@Nonnull String localVariable) {
        this.assertListenersAreNotRegistered(log, "setOtherLocalVariable");
        this._otherLocalVariable = localVariable;
    }

    public String getOtherLocalVariable() {
        return this._otherLocalVariable;
    }

    public LogixNG_SelectTable getSelectTable() {
        return this._selectTable;
    }

    public void setConstantValue(String constantValue) {
        this._constantValue = constantValue;
    }

    public String getConstantValue() {
        return this._constantValue;
    }

    public void setRegEx(String regEx) {
        this._regEx = regEx;
    }

    public String getRegEx() {
        return this._regEx;
    }

    public void setListenToMemory(boolean listenToMemory) {
        this._listenToMemory = listenToMemory;
    }

    public boolean getListenToMemory() {
        return this._listenToMemory;
    }

    public void setVariableOperation(VariableOperation variableOperation) {
        this._variableOperation = variableOperation;
    }

    public VariableOperation getVariableOperation() {
        return this._variableOperation;
    }

    public void setCompareType(CompareUtil.CompareType compareType) {
        this._compareType = compareType;
    }

    public CompareUtil.CompareType getCompareType() {
        return this._compareType;
    }

    public void setCompareTo(CompareTo compareTo) {
        this._compareTo = compareTo;
    }

    public CompareTo getCompareTo() {
        return this._compareTo;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this._caseInsensitive = caseInsensitive;
    }

    public boolean getCaseInsensitive() {
        return this._caseInsensitive;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getString(Object o) {
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    private boolean matchRegex(String memoryValue, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(memoryValue);
        return m.matches();
    }

    @Override
    public boolean evaluate() throws JmriException {
        boolean result;
        if (this._localVariable == null) {
            return false;
        }
        String variableValue = this.getString(this.getConditionalNG().getSymbolTable().getValue(this._localVariable));
        String otherValue = null;
        switch (this._compareTo) {
            case Value: {
                otherValue = this._constantValue;
                break;
            }
            case Memory: {
                Memory memory = this._selectMemoryNamedBean.evaluateNamedBean(this.getConditionalNG());
                otherValue = this.getString(memory.getValue());
                break;
            }
            case Table: {
                otherValue = this.getString(this._selectTable.evaluateTableData(this.getConditionalNG()));
                break;
            }
            case LocalVariable: {
                otherValue = TypeConversionUtil.convertToString(this.getConditionalNG().getSymbolTable().getValue(this._otherLocalVariable), false);
                break;
            }
            case RegEx: {
                break;
            }
            default: {
                throw new IllegalArgumentException("_compareTo has unknown value: " + this._compareTo.name());
            }
        }
        switch (this._variableOperation) {
            case LessThan: 
            case LessThanOrEqual: 
            case Equal: 
            case NotEqual: 
            case GreaterThanOrEqual: 
            case GreaterThan: {
                result = CompareUtil.compare(this._compareType, this._variableOperation._oper, variableValue, otherValue, this._caseInsensitive);
                break;
            }
            case IsNull: {
                result = variableValue == null;
                break;
            }
            case IsNotNull: {
                result = variableValue != null;
                break;
            }
            case MatchRegex: {
                result = this.matchRegex(variableValue, this._regEx);
                break;
            }
            case NotMatchRegex: {
                result = !this.matchRegex(variableValue, this._regEx);
                break;
            }
            default: {
                throw new IllegalArgumentException("_memoryOperation has unknown value: " + this._variableOperation.name());
            }
        }
        return result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "LocalVariable_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String other1;
        String message;
        String variableName = this._localVariable == null || this._localVariable.isEmpty() ? Bundle.getMessage(locale, "BeanNotSelected") : this._localVariable;
        String memoryName = this._selectMemoryNamedBean.getDescription(locale);
        String other2 = null;
        String other3 = null;
        switch (this._compareTo) {
            case Value: {
                message = "LocalVariable_Long_CompareConstant";
                other1 = this._constantValue;
                break;
            }
            case Memory: {
                message = "LocalVariable_Long_CompareMemory";
                other1 = memoryName;
                break;
            }
            case LocalVariable: {
                message = "LocalVariable_Long_CompareLocalVariable";
                other1 = this._otherLocalVariable;
                break;
            }
            case Table: {
                message = "LocalVariable_Long_CompareTable";
                other1 = this._selectTable.getTableNameDescription(locale);
                other2 = this._selectTable.getTableRowDescription(locale);
                other3 = this._selectTable.getTableColumnDescription(locale);
                break;
            }
            case RegEx: {
                message = "LocalVariable_Long_CompareRegEx";
                other1 = this._regEx;
                break;
            }
            default: {
                throw new IllegalArgumentException("_compareTo has unknown value: " + this._compareTo.name());
            }
        }
        switch (this._variableOperation) {
            case LessThan: 
            case LessThanOrEqual: 
            case Equal: 
            case NotEqual: 
            case GreaterThanOrEqual: 
            case GreaterThan: {
                return Bundle.getMessage(locale, message, variableName, this._variableOperation._text, other1, other2, other3);
            }
            case IsNull: 
            case IsNotNull: {
                return Bundle.getMessage(locale, "LocalVariable_Long_CompareNull", variableName, this._variableOperation._text);
            }
            case MatchRegex: 
            case NotMatchRegex: {
                return Bundle.getMessage(locale, "LocalVariable_Long_CompareRegEx", variableName, this._variableOperation._text, other1);
            }
        }
        throw new IllegalArgumentException("_variableOperation has unknown value: " + this._variableOperation.name());
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered && this._listenToMemory) {
            this._selectMemoryNamedBean.addPropertyChangeListener("value", this);
            this._selectMemoryNamedBean.registerListeners();
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered && this._listenToMemory) {
            this._selectMemoryNamedBean.removePropertyChangeListener("value", this);
            this._selectMemoryNamedBean.unregisterListeners();
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ExpressionLocalVariable: bean = {}, report = {}", (Object)cdl, report);
        this._selectMemoryNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Expression);
    }

    public static enum CompareTo {
        Value(Bundle.getMessage("LocalVariable_CompareTo_Value")),
        Memory(Bundle.getMessage("LocalVariable_CompareTo_Memory")),
        LocalVariable(Bundle.getMessage("LocalVariable_CompareTo_LocalVariable")),
        Table(Bundle.getMessage("LocalVariable_CompareTo_Table")),
        RegEx(Bundle.getMessage("LocalVariable_CompareTo_RegularExpression"));

        private final String _text;

        private CompareTo(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum VariableOperation {
        LessThan(CompareUtil.CompareOperation.LessThan, null, true),
        LessThanOrEqual(CompareUtil.CompareOperation.LessThanOrEqual, null, true),
        Equal(CompareUtil.CompareOperation.Equal, null, true),
        GreaterThanOrEqual(CompareUtil.CompareOperation.GreaterThanOrEqual, null, true),
        GreaterThan(CompareUtil.CompareOperation.GreaterThan, null, true),
        NotEqual(CompareUtil.CompareOperation.NotEqual, null, true),
        IsNull(null, Bundle.getMessage("LocalVariableOperation_IsNull"), false),
        IsNotNull(null, Bundle.getMessage("LocalVariableOperation_IsNotNull"), false),
        MatchRegex(null, Bundle.getMessage("LocalVariableOperation_MatchRegEx"), true),
        NotMatchRegex(null, Bundle.getMessage("LocalVariableOperation_NotMatchRegEx"), true);

        private final CompareUtil.CompareOperation _oper;
        private final String _text;
        private final boolean _extraValue;

        private VariableOperation(CompareUtil.CompareOperation oper, String text, boolean extraValue) {
            this._oper = oper;
            this._text = oper != null ? oper.toString() : text;
            this._extraValue = extraValue;
        }

        public String toString() {
            return this._text;
        }

        public boolean hasExtraValue() {
            return this._extraValue;
        }
    }
}

