/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.PowerManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.Is_IsNot_Enum;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.util.parser.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionPower
extends AbstractDigitalExpression
implements PropertyChangeListener {
    private Is_IsNot_Enum _is_IsNot = Is_IsNot_Enum.Is;
    private PowerState _powerState = PowerState.On;
    private boolean _ignoreUnknownState = true;
    private static final Logger log = LoggerFactory.getLogger(ExpressionPower.class);

    public ExpressionPower(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionPower copy = new ExpressionPower(sysName, userName);
        copy.setComment(this.getComment());
        copy.set_Is_IsNot(this._is_IsNot);
        copy.setBeanState(this._powerState);
        copy.setIgnoreUnknownState(this._ignoreUnknownState);
        return manager.registerExpression(copy);
    }

    public void set_Is_IsNot(Is_IsNot_Enum is_IsNot) {
        this._is_IsNot = is_IsNot;
    }

    public Is_IsNot_Enum get_Is_IsNot() {
        return this._is_IsNot;
    }

    public void setBeanState(PowerState state) {
        this._powerState = state;
    }

    public PowerState getBeanState() {
        return this._powerState;
    }

    public void setIgnoreUnknownState(boolean ignoreUnknownState) {
        this._ignoreUnknownState = ignoreUnknownState;
    }

    public boolean isIgnoreUnknownState() {
        return this._ignoreUnknownState;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public boolean evaluate() throws JmriException {
        boolean result;
        PowerState checkPowerState = this._powerState;
        PowerState currentPowerState = PowerState.get(InstanceManager.getDefault(PowerManager.class).getPower());
        if (this._powerState == PowerState.OnOrOff) {
            result = currentPowerState == PowerState.On || currentPowerState == PowerState.Off;
        } else {
            boolean bl = result = currentPowerState == checkPowerState;
        }
        if (this._is_IsNot == Is_IsNot_Enum.Is) {
            return result;
        }
        return !result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Power_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        if (this._ignoreUnknownState) {
            return Bundle.getMessage(locale, "Power_Long3", this._is_IsNot.toString(), this._powerState._text, Bundle.getMessage(locale, "Power_IgnoreUnknownState"));
        }
        return Bundle.getMessage(locale, "Power_Long2", this._is_IsNot.toString(), this._powerState._text);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            InstanceManager.getDefault(PowerManager.class).addPropertyChangeListener("power", this);
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            InstanceManager.getDefault(PowerManager.class).removePropertyChangeListener("power", this);
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this._ignoreUnknownState && "power".equals(evt.getPropertyName()) && evt.getNewValue().equals(1)) {
            log.debug("Ignoring unknown state");
            return;
        }
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    public static enum PowerState {
        On(2, Bundle.getMessage("PowerStateOn")),
        Off(4, Bundle.getMessage("PowerStateOff")),
        Idle(8, Bundle.getMessage("PowerStateIdle")),
        Unknown(1, Bundle.getMessage("PowerStateUnknown")),
        OnOrOff(-1, Bundle.getMessage("PowerStateOnOrOff"));

        private final int _id;
        private final String _text;

        private PowerState(int id, String text) {
            this._id = id;
            this._text = text;
        }

        public static PowerState get(int id) {
            switch (id) {
                case 4: {
                    return Off;
                }
                case 2: {
                    return On;
                }
                case 8: {
                    return Idle;
                }
                case 1: {
                    return Unknown;
                }
            }
            throw new IllegalArgumentException("Unknown state: " + Integer.toString(id));
        }

        public int getID() {
            return this._id;
        }

        public String toString() {
            return this._text;
        }
    }
}

