/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionReporter
extends AbstractDigitalExpression
implements PropertyChangeListener {
    private final LogixNG_SelectNamedBean<Reporter> _selectNamedBean = new LogixNG_SelectNamedBean<Reporter>(this, Reporter.class, InstanceManager.getDefault(ReporterManager.class), this);
    private final LogixNG_SelectNamedBean<Memory> _selectMemoryNamedBean = new LogixNG_SelectNamedBean<Memory>(this, Memory.class, InstanceManager.getDefault(MemoryManager.class), this);
    private ReporterValue _reporterValue = ReporterValue.CurrentReport;
    private ReporterOperation _reporterOperation = ReporterOperation.Equal;
    private CompareTo _compareTo = CompareTo.Value;
    private boolean _caseInsensitive = false;
    private String _constantValue = "";
    private String _localVariable = "";
    private String _regEx = "";
    private boolean _listenToMemory = true;
    private static final Logger log = LoggerFactory.getLogger(ExpressionReporter.class);

    public ExpressionReporter(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionReporter copy = new ExpressionReporter(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        this._selectMemoryNamedBean.copy(copy._selectMemoryNamedBean);
        copy.setReporterValue(this._reporterValue);
        copy.setReporterOperation(this._reporterOperation);
        copy.setCompareTo(this._compareTo);
        copy.setCaseInsensitive(this._caseInsensitive);
        copy.setConstantValue(this._constantValue);
        copy.setListenToMemory(this._listenToMemory);
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public LogixNG_SelectNamedBean<Reporter> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectNamedBean<Memory> getSelectMemoryNamedBean() {
        return this._selectMemoryNamedBean;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this.assertListenersAreNotRegistered(log, "setLocalVariable");
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setConstantValue(String constantValue) {
        this._constantValue = constantValue;
    }

    public String getConstantValue() {
        return this._constantValue;
    }

    public void setRegEx(String regEx) {
        this._regEx = regEx;
    }

    public String getRegEx() {
        return this._regEx;
    }

    public void setListenToMemory(boolean listenToMemory) {
        this._listenToMemory = listenToMemory;
    }

    public boolean getListenToMemory() {
        return this._listenToMemory;
    }

    public void setReporterValue(ReporterValue reporterValue) {
        this._reporterValue = reporterValue;
    }

    public ReporterValue getReporterValue() {
        return this._reporterValue;
    }

    public void setReporterOperation(ReporterOperation reporterOperation) {
        this._reporterOperation = reporterOperation;
    }

    public ReporterOperation getReporterOperation() {
        return this._reporterOperation;
    }

    public void setCompareTo(CompareTo compareTo) {
        this._compareTo = compareTo;
    }

    public CompareTo getCompareTo() {
        return this._compareTo;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this._caseInsensitive = caseInsensitive;
    }

    public boolean getCaseInsensitive() {
        return this._caseInsensitive;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getString(Object o) {
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    private boolean compare(String value1, String value2, boolean caseInsensitive) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        value1 = value1.trim();
        value2 = value2.trim();
        try {
            int n1 = Integer.parseInt(value1);
            try {
                int n2 = Integer.parseInt(value2);
                log.debug("Compare numbers: n1= {} to n2= {}", (Object)n1, (Object)n2);
                switch (this._reporterOperation) {
                    case LessThan: {
                        return n1 < n2;
                    }
                    case LessThanOrEqual: {
                        return n1 <= n2;
                    }
                    case Equal: {
                        return n1 == n2;
                    }
                    case NotEqual: {
                        return n1 != n2;
                    }
                    case GreaterThanOrEqual: {
                        return n1 >= n2;
                    }
                    case GreaterThan: {
                        return n1 > n2;
                    }
                }
                throw new IllegalArgumentException("_reporterOperation has unknown value: " + this._reporterOperation.name());
            }
            catch (NumberFormatException nfe) {
                return this._reporterOperation == ReporterOperation.NotEqual;
            }
        }
        catch (NumberFormatException nfe) {
            try {
                Integer.parseInt(value2);
                return this._reporterOperation == ReporterOperation.NotEqual;
            }
            catch (NumberFormatException numberFormatException) {
                log.debug("Compare Strings: value1= {} to value2= {}", (Object)value1, (Object)value2);
                int compare = caseInsensitive ? value1.compareToIgnoreCase(value2) : value1.compareTo(value2);
                switch (this._reporterOperation) {
                    case LessThan: {
                        if (compare >= 0) break;
                        return true;
                    }
                    case LessThanOrEqual: {
                        if (compare > 0) break;
                        return true;
                    }
                    case Equal: {
                        if (compare != 0) break;
                        return true;
                    }
                    case NotEqual: {
                        if (compare == 0) break;
                        return true;
                    }
                    case GreaterThanOrEqual: {
                        if (compare < 0) break;
                        return true;
                    }
                    case GreaterThan: {
                        if (compare <= 0) break;
                        return true;
                    }
                    default: {
                        throw new IllegalArgumentException("_reporterOperation has unknown value: " + this._reporterOperation.name());
                    }
                }
                return false;
            }
        }
    }

    private boolean matchRegex(String reporterValue, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(reporterValue);
        return m.matches();
    }

    @Override
    public boolean evaluate() throws JmriException {
        boolean result;
        Object obj;
        Reporter reporter = this._selectNamedBean.evaluateNamedBean(this.getConditionalNG());
        if (reporter == null) {
            return false;
        }
        switch (this._reporterValue) {
            case CurrentReport: {
                obj = reporter.getCurrentReport();
                break;
            }
            case LastReport: {
                obj = reporter.getLastReport();
                break;
            }
            case State: {
                obj = reporter.getState();
                break;
            }
            default: {
                throw new IllegalArgumentException("_reporterValue has unknown value: " + this._reporterValue.name());
            }
        }
        String reporterValue = this.getString(obj);
        String otherValue = null;
        switch (this._compareTo) {
            case Value: {
                otherValue = this._constantValue;
                break;
            }
            case Memory: {
                Memory memory = this._selectMemoryNamedBean.evaluateNamedBean(this.getConditionalNG());
                otherValue = this.getString(memory.getValue());
                break;
            }
            case LocalVariable: {
                otherValue = TypeConversionUtil.convertToString(this.getConditionalNG().getSymbolTable().getValue(this._localVariable), false);
                break;
            }
            case RegEx: {
                break;
            }
            default: {
                throw new IllegalArgumentException("_compareTo has unknown value: " + this._compareTo.name());
            }
        }
        switch (this._reporterOperation) {
            case LessThan: 
            case LessThanOrEqual: 
            case Equal: 
            case NotEqual: 
            case GreaterThanOrEqual: 
            case GreaterThan: {
                result = this.compare(reporterValue, otherValue, this._caseInsensitive);
                break;
            }
            case IsNull: {
                result = reporterValue == null;
                break;
            }
            case IsNotNull: {
                result = reporterValue != null;
                break;
            }
            case MatchRegex: {
                result = this.matchRegex(reporterValue, this._regEx);
                break;
            }
            case NotMatchRegex: {
                result = !this.matchRegex(reporterValue, this._regEx);
                break;
            }
            default: {
                throw new IllegalArgumentException("_reporterOperation has unknown value: " + this._reporterOperation.name());
            }
        }
        return result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Reporter_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String other;
        String message;
        String reporterName = this._selectNamedBean.getDescription(locale);
        String memoryName = this._selectMemoryNamedBean.getDescription(locale);
        switch (this._compareTo) {
            case Value: {
                message = "Reporter_Long_CompareConstant";
                other = this._constantValue;
                break;
            }
            case Memory: {
                message = "Reporter_Long_CompareMemory";
                other = memoryName;
                break;
            }
            case LocalVariable: {
                message = "Reporter_Long_CompareLocalVariable";
                other = this._localVariable;
                break;
            }
            case RegEx: {
                message = "Reporter_Long_CompareRegEx";
                other = this._regEx;
                break;
            }
            default: {
                throw new IllegalArgumentException("_compareTo has unknown value: " + this._compareTo.name());
            }
        }
        switch (this._reporterOperation) {
            case LessThan: 
            case LessThanOrEqual: 
            case Equal: 
            case NotEqual: 
            case GreaterThanOrEqual: 
            case GreaterThan: {
                return Bundle.getMessage(locale, message, reporterName, this._reporterValue._text, this._reporterOperation._text, other);
            }
            case IsNull: 
            case IsNotNull: {
                return Bundle.getMessage(locale, "Reporter_Long_CompareNull", reporterName, this._reporterValue._text, this._reporterOperation._text);
            }
            case MatchRegex: 
            case NotMatchRegex: {
                return Bundle.getMessage(locale, "Reporter_Long_CompareRegEx", reporterName, this._reporterValue._text, this._reporterOperation._text, other);
            }
        }
        throw new IllegalArgumentException("_reporterOperation has unknown value: " + this._reporterOperation.name());
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            switch (this._reporterValue) {
                case CurrentReport: {
                    this._selectNamedBean.addPropertyChangeListener("currentReport", this);
                    break;
                }
                case LastReport: {
                    this._selectNamedBean.addPropertyChangeListener("lastReport", this);
                    break;
                }
                case State: {
                    break;
                }
            }
            if (this._listenToMemory) {
                this._selectMemoryNamedBean.addPropertyChangeListener("value", this);
            }
            this._selectNamedBean.registerListeners();
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._selectNamedBean.removePropertyChangeListener("currentReport", this);
            this._selectNamedBean.removePropertyChangeListener("lastReport", this);
            if (this._listenToMemory) {
                this._selectMemoryNamedBean.removePropertyChangeListener("value", this);
            }
            this._selectNamedBean.unregisterListeners();
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ExpressionReporter: bean = {}, report = {}", (Object)cdl, report);
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Expression);
        this._selectMemoryNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Expression);
    }

    public static enum CompareTo {
        Value(Bundle.getMessage("Reporter_CompareTo_Value")),
        Memory(Bundle.getMessage("Reporter_CompareTo_Memory")),
        LocalVariable(Bundle.getMessage("Reporter_CompareTo_LocalVariable")),
        RegEx(Bundle.getMessage("Reporter_CompareTo_RegularExpression"));

        private final String _text;

        private CompareTo(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum ReporterOperation {
        LessThan(Bundle.getMessage("ReporterOperation_LessThan"), true),
        LessThanOrEqual(Bundle.getMessage("ReporterOperation_LessThanOrEqual"), true),
        Equal(Bundle.getMessage("ReporterOperation_Equal"), true),
        GreaterThanOrEqual(Bundle.getMessage("ReporterOperation_GreaterThanOrEqual"), true),
        GreaterThan(Bundle.getMessage("ReporterOperation_GreaterThan"), true),
        NotEqual(Bundle.getMessage("ReporterOperation_NotEqual"), true),
        IsNull(Bundle.getMessage("ReporterOperation_IsNull"), false),
        IsNotNull(Bundle.getMessage("ReporterOperation_IsNotNull"), false),
        MatchRegex(Bundle.getMessage("ReporterOperation_MatchRegEx"), true),
        NotMatchRegex(Bundle.getMessage("ReporterOperation_NotMatchRegEx"), true);

        private final String _text;
        private final boolean _extraValue;

        private ReporterOperation(String text, boolean extraValue) {
            this._text = text;
            this._extraValue = extraValue;
        }

        public String toString() {
            return this._text;
        }

        public boolean hasExtraValue() {
            return this._extraValue;
        }
    }

    public static enum ReporterValue {
        CurrentReport(Bundle.getMessage("Reporter_Value_CurrentReport")),
        LastReport(Bundle.getMessage("Reporter_Value_LastReport")),
        State(Bundle.getMessage("Reporter_Value_State"));

        private final String _text;

        private ReporterValue(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

