/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.LogixNG_ScriptBindings;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.script.ScriptEngineSelector;
import jmri.util.FileUtil;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionScript
extends AbstractDigitalExpression
implements PropertyChangeListener {
    private NamedBeanAddressing _operationAddressing = NamedBeanAddressing.Direct;
    private OperationType _operationType = OperationType.SingleLineCommand;
    private String _operationReference = "";
    private String _operationLocalVariable = "";
    private String _operationFormula = "";
    private ExpressionNode _operationExpressionNode;
    private NamedBeanAddressing _scriptAddressing = NamedBeanAddressing.Direct;
    private String _script = "";
    private String _scriptReference = "";
    private String _scriptLocalVariable = "";
    private String _scriptFormula = "";
    private ExpressionNode _scriptExpressionNode;
    private String _registerScript = "";
    private String _unregisterScript = "";
    private final ScriptEngineSelector _scriptEngineSelector = new ScriptEngineSelector();
    private static final Logger log = LoggerFactory.getLogger(ExpressionScript.class);

    public ExpressionScript(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionScript copy = new ExpressionScript(sysName, userName);
        copy.setComment(this.getComment());
        copy.setScript(this._script);
        copy.setOperationAddressing(this._operationAddressing);
        copy.setOperationType(this._operationType);
        copy.setOperationFormula(this._operationFormula);
        copy.setOperationLocalVariable(this._operationLocalVariable);
        copy.setOperationReference(this._operationReference);
        copy.setScriptAddressing(this._scriptAddressing);
        copy.setScriptFormula(this._scriptFormula);
        copy.setScriptLocalVariable(this._scriptLocalVariable);
        copy.setScriptReference(this._scriptReference);
        copy.setRegisterListenerScript(this._registerScript);
        copy.setUnregisterListenerScript(this._unregisterScript);
        return manager.registerExpression(copy);
    }

    public ScriptEngineSelector getScriptEngineSelector() {
        return this._scriptEngineSelector;
    }

    public void setOperationAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._operationAddressing = addressing;
        this.parseOperationFormula();
    }

    public NamedBeanAddressing getOperationAddressing() {
        return this._operationAddressing;
    }

    public void setOperationType(OperationType operationType) {
        this._operationType = operationType;
    }

    public OperationType getOperationType() {
        return this._operationType;
    }

    public void setOperationReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._operationReference = reference;
    }

    public String getOperationReference() {
        return this._operationReference;
    }

    public void setOperationLocalVariable(@Nonnull String localVariable) {
        this._operationLocalVariable = localVariable;
    }

    public String getOperationLocalVariable() {
        return this._operationLocalVariable;
    }

    public void setOperationFormula(@Nonnull String formula) throws ParserException {
        this._operationFormula = formula;
        this.parseOperationFormula();
    }

    public String getOperationFormula() {
        return this._operationFormula;
    }

    private void parseOperationFormula() throws ParserException {
        if (this._operationAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._operationExpressionNode = parser.parseExpression(this._operationFormula);
        } else {
            this._operationExpressionNode = null;
        }
    }

    public void setScriptAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._scriptAddressing = addressing;
        this.parseScriptFormula();
    }

    public NamedBeanAddressing getScriptAddressing() {
        return this._scriptAddressing;
    }

    public void setScript(String script) {
        this._script = script == null ? "" : script;
    }

    public String getScript() {
        return this._script;
    }

    public void setScriptReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._scriptReference = reference;
    }

    public String getScriptReference() {
        return this._scriptReference;
    }

    public void setScriptLocalVariable(@Nonnull String localVariable) {
        this._scriptLocalVariable = localVariable;
    }

    public String getScriptLocalVariable() {
        return this._scriptLocalVariable;
    }

    public void setScriptFormula(@Nonnull String formula) throws ParserException {
        this._scriptFormula = formula;
        this.parseScriptFormula();
    }

    public String getScriptFormula() {
        return this._scriptFormula;
    }

    private void parseScriptFormula() throws ParserException {
        if (this._scriptAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._scriptExpressionNode = parser.parseExpression(this._scriptFormula);
        } else {
            this._scriptExpressionNode = null;
        }
    }

    public void setRegisterListenerScript(String script) {
        this._registerScript = script == null ? "" : script;
    }

    public String getRegisterListenerScript() {
        return this._registerScript;
    }

    public void setUnregisterListenerScript(String script) {
        this._unregisterScript = script == null ? "" : script;
    }

    public String getUnregisterListenerScript() {
        return this._unregisterScript;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getTheScript() throws JmriException {
        switch (this._scriptAddressing) {
            case Direct: {
                return this._script;
            }
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._scriptReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._scriptLocalVariable), false);
            }
            case Formula: {
                return this._scriptExpressionNode != null ? TypeConversionUtil.convertToString(this._scriptExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : "";
            }
        }
        throw new IllegalArgumentException("invalid _scriptAddressing state: " + this._scriptAddressing.name());
    }

    private OperationType getOperation() throws JmriException {
        String oper = "";
        try {
            switch (this._operationAddressing) {
                case Direct: {
                    return this._operationType;
                }
                case Reference: {
                    oper = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._operationReference);
                    return OperationType.valueOf(oper);
                }
                case LocalVariable: {
                    SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                    oper = TypeConversionUtil.convertToString(symbolTable.getValue(this._operationLocalVariable), false);
                    return OperationType.valueOf(oper);
                }
                case Formula: {
                    if (this._scriptExpressionNode != null) {
                        oper = TypeConversionUtil.convertToString(this._operationExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false);
                        return OperationType.valueOf(oper);
                    }
                    return null;
                }
            }
            throw new IllegalArgumentException("invalid _addressing state: " + this._operationAddressing.name());
        }
        catch (IllegalArgumentException e) {
            throw new JmriException("Unknown operation: " + oper, e);
        }
    }

    @Override
    public boolean evaluate() throws JmriException {
        OperationType operation = this.getOperation();
        String script = this.getTheScript();
        SimpleBindings bindings = new SimpleBindings();
        MutableBoolean result = new MutableBoolean(false);
        LogixNG_ScriptBindings.addScriptBindings(bindings);
        SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
        bindings.put("symbolTable", (Object)symbolTable);
        bindings.put("result", (Object)result);
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            ScriptEngineSelector.Engine engine = this._scriptEngineSelector.getSelectedEngine();
            if (engine == null) {
                throw new JmriException("Script engine is null");
            }
            switch (operation) {
                case RunScript: {
                    try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(FileUtil.getExternalFilename(script)), StandardCharsets.UTF_8);){
                        engine.getScriptEngine().eval((Reader)reader, bindings);
                    }
                    catch (IOException | ScriptException e) {
                        log.warn("cannot execute script", (Throwable)e);
                    }
                    break;
                }
                case SingleLineCommand: {
                    try {
                        Object theScript = engine.isJython() ? String.format("import jmri%n", new Object[0]) + script : script;
                        engine.getScriptEngine().eval((String)theScript, bindings);
                    }
                    catch (ScriptException e) {
                        log.warn("cannot execute script", (Throwable)e);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _stateAddressing state: " + this._scriptAddressing.name());
                }
            }
        });
        return result.booleanValue();
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ExpressionScript_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String script;
        String operation;
        switch (this._operationAddressing) {
            case Direct: {
                operation = Bundle.getMessage(locale, "AddressByDirect", this._operationType._text);
                break;
            }
            case Reference: {
                operation = Bundle.getMessage(locale, "AddressByReference", this._operationReference);
                break;
            }
            case LocalVariable: {
                operation = Bundle.getMessage(locale, "AddressByLocalVariable", this._operationLocalVariable);
                break;
            }
            case Formula: {
                operation = Bundle.getMessage(locale, "AddressByFormula", this._operationFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _operationAddressing state: " + this._operationAddressing.name());
            }
        }
        switch (this._scriptAddressing) {
            case Direct: {
                script = Bundle.getMessage(locale, "AddressByDirect", this._script);
                break;
            }
            case Reference: {
                script = Bundle.getMessage(locale, "AddressByReference", this._scriptReference);
                break;
            }
            case LocalVariable: {
                script = Bundle.getMessage(locale, "AddressByLocalVariable", this._scriptLocalVariable);
                break;
            }
            case Formula: {
                script = Bundle.getMessage(locale, "AddressByFormula", this._scriptFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._scriptAddressing.name());
            }
        }
        if (this._operationAddressing == NamedBeanAddressing.Direct) {
            return Bundle.getMessage(locale, "ExpressionScript_Long", operation, script);
        }
        return Bundle.getMessage(locale, "ExpressionScript_LongUnknownOper", operation, script);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            this._listenersAreRegistered = true;
            if (!this._registerScript.trim().isEmpty()) {
                SimpleBindings bindings = new SimpleBindings();
                MutableBoolean result = new MutableBoolean(false);
                LogixNG_ScriptBindings.addScriptBindings(bindings);
                bindings.put("result", (Object)result);
                bindings.put("self", (Object)this);
                ThreadingUtil.runOnLayout(() -> {
                    ScriptEngineSelector.Engine engine = this._scriptEngineSelector.getSelectedEngine();
                    if (engine == null) {
                        log.error("Script engine is null", (Throwable)new JmriException());
                        return;
                    }
                    try {
                        Object theScript = engine.isJython() ? String.format("import jmri%n", new Object[0]) + this._registerScript : this._registerScript;
                        engine.getScriptEngine().eval((String)theScript, bindings);
                    }
                    catch (RuntimeException | ScriptException e) {
                        log.warn("cannot execute script during registerListeners", (Throwable)e);
                    }
                });
            }
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._listenersAreRegistered = false;
            if (!this._unregisterScript.trim().isEmpty()) {
                SimpleBindings bindings = new SimpleBindings();
                MutableBoolean result = new MutableBoolean(false);
                LogixNG_ScriptBindings.addScriptBindings(bindings);
                bindings.put("result", (Object)result);
                bindings.put("self", (Object)this);
                ThreadingUtil.runOnLayout(() -> {
                    ScriptEngineSelector.Engine engine = this._scriptEngineSelector.getSelectedEngine();
                    if (engine == null) {
                        log.error("Script engine is null", (Throwable)new JmriException());
                        return;
                    }
                    try {
                        Object theScript = engine.isJython() ? String.format("import jmri%n", new Object[0]) + this._unregisterScript : this._unregisterScript;
                        engine.getScriptEngine().eval((String)theScript, bindings);
                    }
                    catch (RuntimeException | ScriptException e) {
                        log.warn("cannot execute script during unregisterListeners", (Throwable)e);
                    }
                });
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    public static enum OperationType {
        RunScript(Bundle.getMessage("ExpressionScript_RunScript")),
        SingleLineCommand(Bundle.getMessage("ExpressionScript_SingleLineCommand"));

        private final String _text;

        private OperationType(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

