/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.Section;
import jmri.SectionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.Is_IsNot_Enum;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.parser.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionSection
extends AbstractDigitalExpression
implements PropertyChangeListener {
    private final LogixNG_SelectNamedBean<Section> _selectNamedBean = new LogixNG_SelectNamedBean<Section>(this, Section.class, InstanceManager.getDefault(SectionManager.class), this);
    private Is_IsNot_Enum _is_IsNot = Is_IsNot_Enum.Is;
    private final LogixNG_SelectEnum<SectionState> _selectEnum = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])SectionState.values(), (Enum)SectionState.Free, (PropertyChangeListener)this);
    private static final Logger log = LoggerFactory.getLogger(ExpressionSection.class);

    public ExpressionSection(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionSection copy = new ExpressionSection(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        this._selectEnum.copy(copy._selectEnum);
        copy.set_Is_IsNot(this._is_IsNot);
        return manager.registerExpression(copy);
    }

    public LogixNG_SelectNamedBean<Section> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectEnum<SectionState> getSelectEnum() {
        return this._selectEnum;
    }

    public void set_Is_IsNot(Is_IsNot_Enum is_IsNot) {
        this._is_IsNot = is_IsNot;
    }

    public Is_IsNot_Enum get_Is_IsNot() {
        return this._is_IsNot;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public boolean evaluate() throws JmriException {
        ConditionalNG conditionalNG = this.getConditionalNG();
        Section section = this._selectNamedBean.evaluateNamedBean(conditionalNG);
        if (section == null) {
            return false;
        }
        SectionState checkSectionState = this._selectEnum.evaluateEnum(conditionalNG);
        int currentState = section.getState();
        if (this._is_IsNot == Is_IsNot_Enum.Is) {
            return currentState == checkSectionState.getID();
        }
        return currentState != checkSectionState.getID();
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Section_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String state;
        String namedBean = this._selectNamedBean.getDescription(locale);
        if (this._selectEnum.isDirectAddressing()) {
            SectionState sectionState = this._selectEnum.getEnum();
            state = Bundle.getMessage(locale, "AddressByDirect", sectionState._text);
        } else {
            state = this._selectEnum.getDescription(locale);
        }
        return Bundle.getMessage(locale, "Section_Long", namedBean, this._is_IsNot.toString(), state);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            this._selectNamedBean.addPropertyChangeListener(this);
            this._selectNamedBean.registerListeners();
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._selectNamedBean.removePropertyChangeListener(this);
            this._selectNamedBean.unregisterListeners();
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ExpressionSection: bean = {}, report = {}", (Object)cdl, report);
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Expression);
    }

    public static enum SectionState {
        Free(2, Bundle.getMessage("Section_StateFree")),
        Forward(4, Bundle.getMessage("Section_StateForward")),
        Reverse(8, Bundle.getMessage("Section_StateReverse"));

        private final int _id;
        private final String _text;

        private SectionState(int id, String text) {
            this._id = id;
            this._text = text;
        }

        public int getID() {
            return this._id;
        }

        public String toString() {
            return this._text;
        }
    }
}

