/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.parser.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionSensorEdge
extends AbstractDigitalExpression
implements PropertyChangeListener {
    private final LogixNG_SelectNamedBean<Sensor> _selectNamedBean = new LogixNG_SelectNamedBean<Sensor>(this, Sensor.class, InstanceManager.getDefault(SensorManager.class), this);
    private final LogixNG_SelectEnum<SensorState> _selectEnumFromState = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])SensorState.values(), (Enum)SensorState.Active, (PropertyChangeListener)this);
    private final LogixNG_SelectEnum<SensorState> _selectEnumToState = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])SensorState.values(), (Enum)SensorState.Active, (PropertyChangeListener)this);
    private boolean _onlyTrueOnce = false;
    SensorState lastSensorState = null;
    SensorState currentSensorState = null;
    private static final Logger log = LoggerFactory.getLogger(ExpressionSensorEdge.class);

    public ExpressionSensorEdge(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._selectNamedBean.setOnlyDirectAddressingAllowed();
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionSensorEdge copy = new ExpressionSensorEdge(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        this._selectEnumFromState.copy(copy._selectEnumFromState);
        this._selectEnumToState.copy(copy._selectEnumToState);
        copy.setOnlyTrueOnce(this._onlyTrueOnce);
        return manager.registerExpression(copy);
    }

    public LogixNG_SelectNamedBean<Sensor> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectEnum<SensorState> getSelectEnumFromState() {
        return this._selectEnumFromState;
    }

    public LogixNG_SelectEnum<SensorState> getSelectEnumToState() {
        return this._selectEnumToState;
    }

    public void setOnlyTrueOnce(boolean onlyTrueOnce) {
        this._onlyTrueOnce = onlyTrueOnce;
    }

    public boolean getOnlyTrueOnce() {
        return this._onlyTrueOnce;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public boolean evaluate() throws JmriException {
        boolean result;
        Sensor sensor = this._selectNamedBean.evaluateNamedBean(this.getConditionalNG());
        if (sensor == null) {
            return false;
        }
        SensorState checkSensorFromState = this._selectEnumFromState.evaluateEnum(this.getConditionalNG());
        SensorState checkSensorToState = this._selectEnumToState.evaluateEnum(this.getConditionalNG());
        boolean bl = result = this.lastSensorState == checkSensorFromState && this.currentSensorState == checkSensorToState;
        if (this._onlyTrueOnce) {
            this.lastSensorState = null;
            this.currentSensorState = null;
        }
        return result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "SensorEdge_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String namedBean = this._selectNamedBean.getDescription(locale);
        String fromState = this._selectEnumFromState.getDescription(locale);
        String toState = this._selectEnumToState.getDescription(locale);
        if (this._onlyTrueOnce) {
            return Bundle.getMessage(locale, "SensorEdge_LongOnlyTrueOnce", namedBean, fromState, toState);
        }
        return Bundle.getMessage(locale, "SensorEdge_Long", namedBean, fromState, toState);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            this._selectNamedBean.addPropertyChangeListener("KnownState", this);
            this._selectNamedBean.registerListeners();
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._selectNamedBean.removePropertyChangeListener("KnownState", this);
            this._selectNamedBean.unregisterListeners();
            this._listenersAreRegistered = false;
            this.lastSensorState = null;
            this.currentSensorState = null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("KnownState".equals(evt.getPropertyName())) {
            Object oldState = evt.getOldValue();
            Object newState = evt.getNewValue();
            this.lastSensorState = oldState != null ? SensorState.get((Integer)oldState) : null;
            this.currentSensorState = newState != null ? SensorState.get((Integer)newState) : null;
            this.getConditionalNG().execute();
        }
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ExpressionSensorEdge: bean = {}, report = {}", (Object)cdl, report);
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Expression);
    }

    public static enum SensorState {
        Unknown(4, Bundle.getMessage("BeanStateUnknown")),
        Inconsistent(2, Bundle.getMessage("BeanStateInconsistent")),
        Inactive(4, Bundle.getMessage("SensorStateInactive")),
        Active(2, Bundle.getMessage("SensorStateActive"));

        private final int _id;
        private final String _text;

        private SensorState(int id, String text) {
            this._id = id;
            this._text = text;
        }

        public static SensorState get(int id) {
            switch (id) {
                case 1: {
                    return Inactive;
                }
                case 8: {
                    return Active;
                }
                case 4: {
                    return Inactive;
                }
                case 2: {
                    return Active;
                }
            }
            return null;
        }

        public int getID() {
            return this._id;
        }

        public String toString() {
            return this._text;
        }
    }
}

