/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionSignalHead
extends AbstractDigitalExpression
implements PropertyChangeListener,
VetoableChangeListener {
    private final LogixNG_SelectNamedBean<SignalHead> _selectNamedBean = new LogixNG_SelectNamedBean<SignalHead>(this, SignalHead.class, InstanceManager.getDefault(SignalHeadManager.class), this);
    private NamedBeanAddressing _queryAddressing = NamedBeanAddressing.Direct;
    private QueryType _queryType = QueryType.Appearance;
    private String _queryReference = "";
    private String _queryLocalVariable = "";
    private String _queryFormula = "";
    private ExpressionNode _queryExpressionNode;
    private NamedBeanAddressing _appearanceAddressing = NamedBeanAddressing.Direct;
    private int _signalHeadAppearance = 0;
    private String _appearanceReference = "";
    private String _appearanceLocalVariable = "";
    private String _appearanceFormula = "";
    private ExpressionNode _appearanceExpressionNode;
    private final LogixNG_SelectNamedBean<SignalHead> _selectExampleNamedBean = new LogixNG_SelectNamedBean<SignalHead>(this, SignalHead.class, InstanceManager.getDefault(SignalHeadManager.class), this);
    private static final Logger log = LoggerFactory.getLogger(ExpressionSignalHead.class);

    public ExpressionSignalHead(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionSignalHead copy = new ExpressionSignalHead(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        copy.setAppearance(this._signalHeadAppearance);
        copy.setQueryAddressing(this._queryAddressing);
        copy.setQueryType(this._queryType);
        copy.setQueryFormula(this._queryFormula);
        copy.setQueryLocalVariable(this._queryLocalVariable);
        copy.setQueryReference(this._queryReference);
        copy.setAppearanceAddressing(this._appearanceAddressing);
        copy.setAppearanceFormula(this._appearanceFormula);
        copy.setAppearanceLocalVariable(this._appearanceLocalVariable);
        copy.setAppearanceReference(this._appearanceReference);
        this._selectExampleNamedBean.copy(copy._selectExampleNamedBean);
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public LogixNG_SelectNamedBean<SignalHead> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectNamedBean<SignalHead> getSelectExampleNamedBean() {
        return this._selectExampleNamedBean;
    }

    public void setQueryAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._queryAddressing = addressing;
        this.parseQueryFormula();
    }

    public NamedBeanAddressing getQueryAddressing() {
        return this._queryAddressing;
    }

    public void setQueryType(QueryType queryType) {
        this._queryType = queryType;
    }

    public QueryType getQueryType() {
        return this._queryType;
    }

    public void setQueryReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._queryReference = reference;
    }

    public String getQueryReference() {
        return this._queryReference;
    }

    public void setQueryLocalVariable(@Nonnull String localVariable) {
        this._queryLocalVariable = localVariable;
    }

    public String getQueryLocalVariable() {
        return this._queryLocalVariable;
    }

    public void setQueryFormula(@Nonnull String formula) throws ParserException {
        this._queryFormula = formula;
        this.parseQueryFormula();
    }

    public String getQueryFormula() {
        return this._queryFormula;
    }

    private void parseQueryFormula() throws ParserException {
        if (this._queryAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._queryExpressionNode = parser.parseExpression(this._queryFormula);
        } else {
            this._queryExpressionNode = null;
        }
    }

    public void setAppearanceAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._appearanceAddressing = addressing;
        this.parseAppearanceFormula();
    }

    public NamedBeanAddressing getAppearanceAddressing() {
        return this._appearanceAddressing;
    }

    public void setAppearance(int appearance) {
        this._signalHeadAppearance = appearance;
    }

    public int getAppearance() {
        return this._signalHeadAppearance;
    }

    public void setAppearanceReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._appearanceReference = reference;
    }

    public String getAppearanceReference() {
        return this._appearanceReference;
    }

    public void setAppearanceLocalVariable(@Nonnull String localVariable) {
        this._appearanceLocalVariable = localVariable;
    }

    public String getAppearanceLocalVariable() {
        return this._appearanceLocalVariable;
    }

    public void setAppearanceFormula(@Nonnull String formula) throws ParserException {
        this._appearanceFormula = formula;
        this.parseAppearanceFormula();
    }

    public String getAppearanceFormula() {
        return this._appearanceFormula;
    }

    private void parseAppearanceFormula() throws ParserException {
        if (this._appearanceAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._appearanceExpressionNode = parser.parseExpression(this._appearanceFormula);
        } else {
            this._appearanceExpressionNode = null;
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private int getAppearanceFromName(String name, SignalHead signalHead) {
        if (signalHead == null) {
            throw new UnsupportedOperationException("_signalHeadHandle is null");
        }
        String[] keys = signalHead.getValidStateKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (!name.equals(keys[i])) continue;
            return signalHead.getValidStates()[i];
        }
        throw new IllegalArgumentException("Appearance " + name + " is not valid for signal head " + signalHead.getSystemName());
    }

    private int getNewAppearance(ConditionalNG conditionalNG, SignalHead signalHead) throws JmriException {
        switch (this._appearanceAddressing) {
            case Direct: {
                return this._signalHeadAppearance;
            }
            case Reference: {
                return this.getAppearanceFromName(ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._appearanceReference), signalHead);
            }
            case LocalVariable: {
                SymbolTable symbolTable = conditionalNG.getSymbolTable();
                return this.getAppearanceFromName(TypeConversionUtil.convertToString(symbolTable.getValue(this._appearanceLocalVariable), false), signalHead);
            }
            case Formula: {
                return this._appearanceExpressionNode != null ? this.getAppearanceFromName(TypeConversionUtil.convertToString(this._appearanceExpressionNode.calculate(conditionalNG.getSymbolTable()), false), signalHead) : -1;
            }
        }
        throw new IllegalArgumentException("invalid _aspectAddressing state: " + this._appearanceAddressing.name());
    }

    private QueryType getQuery(ConditionalNG conditionalNG) throws JmriException {
        String oper = "";
        try {
            switch (this._queryAddressing) {
                case Direct: {
                    return this._queryType;
                }
                case Reference: {
                    oper = ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._queryReference);
                    return QueryType.valueOf(oper);
                }
                case LocalVariable: {
                    SymbolTable symbolTable = conditionalNG.getSymbolTable();
                    oper = TypeConversionUtil.convertToString(symbolTable.getValue(this._queryLocalVariable), false);
                    return QueryType.valueOf(oper);
                }
                case Formula: {
                    if (this._appearanceExpressionNode != null) {
                        oper = TypeConversionUtil.convertToString(this._queryExpressionNode.calculate(conditionalNG.getSymbolTable()), false);
                        return QueryType.valueOf(oper);
                    }
                    return null;
                }
            }
            throw new IllegalArgumentException("invalid _addressing state: " + this._queryAddressing.name());
        }
        catch (IllegalArgumentException e) {
            throw new JmriException("Unknown query: " + oper, e);
        }
    }

    @Override
    public boolean evaluate() throws JmriException {
        ConditionalNG conditionalNG = this.getConditionalNG();
        SignalHead signalHead = this._selectNamedBean.evaluateNamedBean(conditionalNG);
        if (signalHead == null) {
            return false;
        }
        QueryType query = this.getQuery(conditionalNG);
        boolean result = false;
        switch (query) {
            case Appearance: {
                int queryAppearance = this.getNewAppearance(conditionalNG, signalHead);
                if (queryAppearance == -1) break;
                result = signalHead.getAppearance() == queryAppearance;
                break;
            }
            case NotAppearance: {
                int queryAppearance = this.getNewAppearance(conditionalNG, signalHead);
                if (queryAppearance == -1) break;
                result = signalHead.getAppearance() != queryAppearance;
                break;
            }
            case Lit: {
                result = signalHead.getLit();
                break;
            }
            case NotLit: {
                result = !signalHead.getLit();
                break;
            }
            case Held: {
                result = signalHead.getHeld();
                break;
            }
            case NotHeld: {
                result = !signalHead.getHeld();
                break;
            }
            default: {
                throw new RuntimeException("Unknown enum: " + this._queryType.name());
            }
        }
        return result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "SignalHead_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String appearance;
        String query;
        String namedBean = this._selectNamedBean.getDescription(locale);
        switch (this._queryAddressing) {
            case Direct: {
                query = Bundle.getMessage(locale, "AddressByDirect", this._queryType._text);
                break;
            }
            case Reference: {
                query = Bundle.getMessage(locale, "AddressByReference", this._queryReference);
                break;
            }
            case LocalVariable: {
                query = Bundle.getMessage(locale, "AddressByLocalVariable", this._queryLocalVariable);
                break;
            }
            case Formula: {
                query = Bundle.getMessage(locale, "AddressByFormula", this._queryFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _queryAddressing state: " + this._queryAddressing.name());
            }
        }
        switch (this._appearanceAddressing) {
            case Direct: {
                SignalHead signalHead = null;
                if (this._selectNamedBean.getAddressing() == NamedBeanAddressing.Direct) {
                    if (this._selectNamedBean.getNamedBean() != null) {
                        signalHead = this._selectNamedBean.getNamedBeanIfDirectAddressing();
                    }
                } else if (this._selectExampleNamedBean.getNamedBean() != null) {
                    signalHead = this._selectExampleNamedBean.getNamedBeanIfDirectAddressing();
                }
                String a = "";
                if (signalHead != null) {
                    a = signalHead.getAppearanceName(this._signalHeadAppearance);
                }
                appearance = Bundle.getMessage(locale, "AddressByDirect", a);
                break;
            }
            case Reference: {
                appearance = Bundle.getMessage(locale, "AddressByReference", this._appearanceReference);
                break;
            }
            case LocalVariable: {
                appearance = Bundle.getMessage(locale, "AddressByLocalVariable", this._appearanceLocalVariable);
                break;
            }
            case Formula: {
                appearance = Bundle.getMessage(locale, "AddressByFormula", this._appearanceFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._appearanceAddressing.name());
            }
        }
        if (this._queryAddressing == NamedBeanAddressing.Direct) {
            if (this._queryType == QueryType.Appearance) {
                return Bundle.getMessage(locale, "SignalHead_LongAppearance", namedBean, appearance);
            }
            if (this._queryType == QueryType.NotAppearance) {
                return Bundle.getMessage(locale, "SignalHead_LongNotAppearance", namedBean, appearance);
            }
            return Bundle.getMessage(locale, "SignalHead_Long", namedBean, query);
        }
        return Bundle.getMessage(locale, "SignalHead_LongUnknownOper", namedBean, query, appearance);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        SignalHead signalHead = this._selectNamedBean.getNamedBeanIfDirectAddressing();
        if (!this._listenersAreRegistered && signalHead != null) {
            switch (this._queryType) {
                case Appearance: 
                case NotAppearance: {
                    signalHead.addPropertyChangeListener("Appearance", this);
                    break;
                }
                case Lit: 
                case NotLit: {
                    signalHead.addPropertyChangeListener("Lit", this);
                    break;
                }
                case Held: 
                case NotHeld: {
                    signalHead.addPropertyChangeListener("Held", this);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown enum: " + this._queryType.name());
                }
            }
            this._selectNamedBean.registerListeners();
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        SignalHead signalHead = this._selectNamedBean.getNamedBeanIfDirectAddressing();
        if (this._listenersAreRegistered && signalHead != null) {
            switch (this._queryType) {
                case Appearance: 
                case NotAppearance: {
                    signalHead.removePropertyChangeListener("Appearance", this);
                    break;
                }
                case Lit: 
                case NotLit: {
                    signalHead.removePropertyChangeListener("Lit", this);
                    break;
                }
                case Held: 
                case NotHeld: {
                    signalHead.removePropertyChangeListener("Held", this);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown enum: " + this._queryType.name());
                }
            }
            this._selectNamedBean.unregisterListeners();
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ExpressionSignalHead: bean = {}, report = {}", (Object)cdl, report);
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
        this._selectExampleNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
    }

    public static enum QueryType {
        Appearance(Bundle.getMessage("SignalHeadQueryType_Appearance")),
        NotAppearance(Bundle.getMessage("SignalHeadQueryType_NotAppearance")),
        Lit(Bundle.getMessage("SignalHeadQueryType_Lit")),
        NotLit(Bundle.getMessage("SignalHeadQueryType_NotLit")),
        Held(Bundle.getMessage("SignalHeadQueryType_Held")),
        NotHeld(Bundle.getMessage("SignalHeadQueryType_NotHeld"));

        private final String _text;

        private QueryType(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

