/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionSignalMast
extends AbstractDigitalExpression
implements PropertyChangeListener,
VetoableChangeListener {
    private final LogixNG_SelectNamedBean<SignalMast> _selectNamedBean = new LogixNG_SelectNamedBean<SignalMast>(this, SignalMast.class, InstanceManager.getDefault(SignalMastManager.class), this);
    private NamedBeanAddressing _queryAddressing = NamedBeanAddressing.Direct;
    private QueryType _queryType = QueryType.Aspect;
    private String _queryReference = "";
    private String _queryLocalVariable = "";
    private String _queryFormula = "";
    private ExpressionNode _queryExpressionNode;
    private NamedBeanAddressing _aspectAddressing = NamedBeanAddressing.Direct;
    private String _signalMastAspect = "";
    private String _aspectReference = "";
    private String _aspectLocalVariable = "";
    private String _aspectFormula = "";
    private ExpressionNode _aspectExpressionNode;
    private final LogixNG_SelectNamedBean<SignalMast> _selectExampleNamedBean = new LogixNG_SelectNamedBean<SignalMast>(this, SignalMast.class, InstanceManager.getDefault(SignalMastManager.class), this);
    private static final Logger log = LoggerFactory.getLogger(ExpressionSignalMast.class);

    public ExpressionSignalMast(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionSignalMast copy = new ExpressionSignalMast(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        copy.setAspect(this._signalMastAspect);
        copy.setQueryAddressing(this._queryAddressing);
        copy.setQueryType(this._queryType);
        copy.setQueryFormula(this._queryFormula);
        copy.setQueryLocalVariable(this._queryLocalVariable);
        copy.setQueryReference(this._queryReference);
        copy.setAspectAddressing(this._aspectAddressing);
        copy.setAspectFormula(this._aspectFormula);
        copy.setAspectLocalVariable(this._aspectLocalVariable);
        copy.setAspectReference(this._aspectReference);
        this._selectExampleNamedBean.copy(copy._selectExampleNamedBean);
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public LogixNG_SelectNamedBean<SignalMast> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectNamedBean<SignalMast> getSelectExampleNamedBean() {
        return this._selectExampleNamedBean;
    }

    public void setQueryAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._queryAddressing = addressing;
        this.parseQueryFormula();
    }

    public NamedBeanAddressing getQueryAddressing() {
        return this._queryAddressing;
    }

    public void setQueryType(QueryType queryType) {
        this._queryType = queryType;
    }

    public QueryType getQueryType() {
        return this._queryType;
    }

    public void setQueryReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._queryReference = reference;
    }

    public String getQueryReference() {
        return this._queryReference;
    }

    public void setQueryLocalVariable(@Nonnull String localVariable) {
        this._queryLocalVariable = localVariable;
    }

    public String getQueryLocalVariable() {
        return this._queryLocalVariable;
    }

    public void setQueryFormula(@Nonnull String formula) throws ParserException {
        this._queryFormula = formula;
        this.parseQueryFormula();
    }

    public String getQueryFormula() {
        return this._queryFormula;
    }

    private void parseQueryFormula() throws ParserException {
        if (this._queryAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._queryExpressionNode = parser.parseExpression(this._queryFormula);
        } else {
            this._queryExpressionNode = null;
        }
    }

    public void setAspectAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._aspectAddressing = addressing;
        this.parseAspectFormula();
    }

    public NamedBeanAddressing getAspectAddressing() {
        return this._aspectAddressing;
    }

    public void setAspect(String aspect) {
        this._signalMastAspect = aspect == null ? "" : aspect;
    }

    public String getAspect() {
        return this._signalMastAspect;
    }

    public void setAspectReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._aspectReference = reference;
    }

    public String getAspectReference() {
        return this._aspectReference;
    }

    public void setAspectLocalVariable(@Nonnull String localVariable) {
        this._aspectLocalVariable = localVariable;
    }

    public String getAspectLocalVariable() {
        return this._aspectLocalVariable;
    }

    public void setAspectFormula(@Nonnull String formula) throws ParserException {
        this._aspectFormula = formula;
        this.parseAspectFormula();
    }

    public String getAspectFormula() {
        return this._aspectFormula;
    }

    private void parseAspectFormula() throws ParserException {
        if (this._aspectAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._aspectExpressionNode = parser.parseExpression(this._aspectFormula);
        } else {
            this._aspectExpressionNode = null;
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getNewAspect(ConditionalNG conditionalNG) throws JmriException {
        switch (this._aspectAddressing) {
            case Direct: {
                return this._signalMastAspect;
            }
            case Reference: {
                return ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._aspectReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = conditionalNG.getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._aspectLocalVariable), false);
            }
            case Formula: {
                return this._aspectExpressionNode != null ? TypeConversionUtil.convertToString(this._aspectExpressionNode.calculate(conditionalNG.getSymbolTable()), false) : "";
            }
        }
        throw new IllegalArgumentException("invalid _aspectAddressing state: " + this._aspectAddressing.name());
    }

    private QueryType getQuery(ConditionalNG conditionalNG) throws JmriException {
        String oper = "";
        try {
            switch (this._queryAddressing) {
                case Direct: {
                    return this._queryType;
                }
                case Reference: {
                    oper = ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._queryReference);
                    return QueryType.valueOf(oper);
                }
                case LocalVariable: {
                    SymbolTable symbolTable = conditionalNG.getSymbolTable();
                    oper = TypeConversionUtil.convertToString(symbolTable.getValue(this._queryLocalVariable), false);
                    return QueryType.valueOf(oper);
                }
                case Formula: {
                    if (this._aspectExpressionNode != null) {
                        oper = TypeConversionUtil.convertToString(this._queryExpressionNode.calculate(conditionalNG.getSymbolTable()), false);
                        return QueryType.valueOf(oper);
                    }
                    return null;
                }
            }
            throw new IllegalArgumentException("invalid _addressing state: " + this._queryAddressing.name());
        }
        catch (IllegalArgumentException e) {
            throw new JmriException("Unknown query: " + oper, e);
        }
    }

    @Override
    public boolean evaluate() throws JmriException {
        ConditionalNG conditionalNG = this.getConditionalNG();
        SignalMast signalMast = this._selectNamedBean.evaluateNamedBean(conditionalNG);
        if (signalMast == null) {
            return false;
        }
        QueryType query = this.getQuery(conditionalNG);
        boolean result = false;
        switch (query) {
            case Aspect: {
                if (signalMast.getAspect() == null) break;
                result = this.getNewAspect(conditionalNG).equals(signalMast.getAspect());
                break;
            }
            case NotAspect: {
                if (signalMast.getAspect() == null) break;
                result = !this.getNewAspect(conditionalNG).equals(signalMast.getAspect());
                break;
            }
            case Lit: {
                result = signalMast.getLit();
                break;
            }
            case NotLit: {
                result = !signalMast.getLit();
                break;
            }
            case Held: {
                result = signalMast.getHeld();
                break;
            }
            case NotHeld: {
                result = !signalMast.getHeld();
                break;
            }
            case IsPermissiveSmlDisabled: {
                result = signalMast.isPermissiveSmlDisabled();
                break;
            }
            case IsPermissiveSmlNotDisabled: {
                result = !signalMast.isPermissiveSmlDisabled();
                break;
            }
            default: {
                throw new RuntimeException("Unknown enum: " + this._queryType.name());
            }
        }
        return result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "SignalMast_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String aspect;
        String query;
        String namedBean = this._selectNamedBean.getDescription(locale);
        switch (this._queryAddressing) {
            case Direct: {
                query = Bundle.getMessage(locale, "AddressByDirect", this._queryType._text);
                break;
            }
            case Reference: {
                query = Bundle.getMessage(locale, "AddressByReference", this._queryReference);
                break;
            }
            case LocalVariable: {
                query = Bundle.getMessage(locale, "AddressByLocalVariable", this._queryLocalVariable);
                break;
            }
            case Formula: {
                query = Bundle.getMessage(locale, "AddressByFormula", this._queryFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _queryAddressing state: " + this._queryAddressing.name());
            }
        }
        switch (this._aspectAddressing) {
            case Direct: {
                aspect = Bundle.getMessage(locale, "AddressByDirect", this._signalMastAspect);
                break;
            }
            case Reference: {
                aspect = Bundle.getMessage(locale, "AddressByReference", this._aspectReference);
                break;
            }
            case LocalVariable: {
                aspect = Bundle.getMessage(locale, "AddressByLocalVariable", this._aspectLocalVariable);
                break;
            }
            case Formula: {
                aspect = Bundle.getMessage(locale, "AddressByFormula", this._aspectFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._aspectAddressing.name());
            }
        }
        if (this._queryAddressing == NamedBeanAddressing.Direct) {
            if (this._queryType == QueryType.Aspect) {
                return Bundle.getMessage(locale, "SignalMast_LongAspect", namedBean, aspect);
            }
            if (this._queryType == QueryType.NotAspect) {
                return Bundle.getMessage(locale, "SignalMast_LongNotAspect", namedBean, aspect);
            }
            return Bundle.getMessage(locale, "SignalMast_Long", namedBean, query);
        }
        return Bundle.getMessage(locale, "SignalMast_LongUnknownOper", namedBean, query, aspect);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        SignalMast signalMast = this._selectNamedBean.getNamedBeanIfDirectAddressing();
        if (!this._listenersAreRegistered && signalMast != null) {
            switch (this._queryType) {
                case Aspect: 
                case NotAspect: {
                    signalMast.addPropertyChangeListener("Aspect", this);
                    break;
                }
                case Lit: 
                case NotLit: {
                    signalMast.addPropertyChangeListener("Lit", this);
                    break;
                }
                case Held: 
                case NotHeld: {
                    signalMast.addPropertyChangeListener("Held", this);
                    break;
                }
                case IsPermissiveSmlDisabled: 
                case IsPermissiveSmlNotDisabled: {
                    signalMast.addPropertyChangeListener("PermissiveSmlDisabled", this);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown enum: " + this._queryType.name());
                }
            }
            this._selectNamedBean.registerListeners();
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        SignalMast signalMast = this._selectNamedBean.getNamedBeanIfDirectAddressing();
        if (this._listenersAreRegistered && signalMast != null) {
            switch (this._queryType) {
                case Aspect: 
                case NotAspect: {
                    signalMast.removePropertyChangeListener("Aspect", this);
                    break;
                }
                case Lit: 
                case NotLit: {
                    signalMast.removePropertyChangeListener("Lit", this);
                    break;
                }
                case Held: 
                case NotHeld: {
                    signalMast.removePropertyChangeListener("Held", this);
                    break;
                }
                case IsPermissiveSmlDisabled: 
                case IsPermissiveSmlNotDisabled: {
                    signalMast.removePropertyChangeListener("PermissiveSmlDisabled", this);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown enum: " + this._queryType.name());
                }
            }
            this._selectNamedBean.unregisterListeners();
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ExpressionSignalMast: bean = {}, report = {}", (Object)cdl, report);
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
        this._selectExampleNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
    }

    public static enum QueryType {
        Aspect(Bundle.getMessage("SignalMastQueryType_Aspect")),
        NotAspect(Bundle.getMessage("SignalMastQueryType_NotAspect")),
        Lit(Bundle.getMessage("SignalMastQueryType_Lit")),
        NotLit(Bundle.getMessage("SignalMastQueryType_NotLit")),
        Held(Bundle.getMessage("SignalMastQueryType_Held")),
        NotHeld(Bundle.getMessage("SignalMastQueryType_NotHeld")),
        IsPermissiveSmlDisabled(Bundle.getMessage("SignalMastQueryType_IsPermissiveSmlDisabled")),
        IsPermissiveSmlNotDisabled(Bundle.getMessage("SignalMastQueryType_IsPermissiveSmlNotDisabled"));

        private final String _text;

        private QueryType(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

