/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.Transit;
import jmri.TransitManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.Is_IsNot_Enum;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.parser.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionTransit
extends AbstractDigitalExpression
implements PropertyChangeListener {
    private final LogixNG_SelectNamedBean<Transit> _selectNamedBean = new LogixNG_SelectNamedBean<Transit>(this, Transit.class, InstanceManager.getDefault(TransitManager.class), this);
    private Is_IsNot_Enum _is_IsNot = Is_IsNot_Enum.Is;
    private final LogixNG_SelectEnum<TransitState> _selectEnum = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])TransitState.values(), (Enum)TransitState.Idle, (PropertyChangeListener)this);
    private static final Logger log = LoggerFactory.getLogger(ExpressionTransit.class);

    public ExpressionTransit(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionTransit copy = new ExpressionTransit(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        this._selectEnum.copy(copy._selectEnum);
        copy.set_Is_IsNot(this._is_IsNot);
        return manager.registerExpression(copy);
    }

    public LogixNG_SelectNamedBean<Transit> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectEnum<TransitState> getSelectEnum() {
        return this._selectEnum;
    }

    public void set_Is_IsNot(Is_IsNot_Enum is_IsNot) {
        this._is_IsNot = is_IsNot;
    }

    public Is_IsNot_Enum get_Is_IsNot() {
        return this._is_IsNot;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public boolean evaluate() throws JmriException {
        ConditionalNG conditionalNG = this.getConditionalNG();
        Transit transit = this._selectNamedBean.evaluateNamedBean(conditionalNG);
        if (transit == null) {
            return false;
        }
        TransitState checkTransitState = this._selectEnum.evaluateEnum(conditionalNG);
        int currentState = transit.getState();
        if (this._is_IsNot == Is_IsNot_Enum.Is) {
            return currentState == checkTransitState.getID();
        }
        return currentState != checkTransitState.getID();
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Transit_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String state;
        String namedBean = this._selectNamedBean.getDescription(locale);
        if (this._selectEnum.isDirectAddressing()) {
            TransitState transitState = this._selectEnum.getEnum();
            state = Bundle.getMessage(locale, "AddressByDirect", transitState._text);
        } else {
            state = this._selectEnum.getDescription(locale);
        }
        return Bundle.getMessage(locale, "Transit_Long", namedBean, this._is_IsNot.toString(), state);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            this._selectNamedBean.addPropertyChangeListener(this);
            this._selectNamedBean.registerListeners();
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._selectNamedBean.removePropertyChangeListener(this);
            this._selectNamedBean.unregisterListeners();
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ExpressionTransit: bean = {}, report = {}", (Object)cdl, report);
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Expression);
    }

    public static enum TransitState {
        Idle(2, Bundle.getMessage("Transit_StateIdle")),
        Assigned(4, Bundle.getMessage("Transit_StateAssigned"));

        private final int _id;
        private final String _text;

        private TransitState(int id, String text) {
            this._id = id;
            this._text = text;
        }

        public int getID() {
            return this._id;
        }

        public String toString() {
            return this._text;
        }
    }
}

