/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectString;
import jmri.util.FileUtil;

public class FileAsFlag
extends AbstractDigitalExpression
implements PropertyChangeListener {
    private final LogixNG_SelectString _selectFilename = new LogixNG_SelectString(this, this);
    private final LogixNG_SelectEnum<DeleteOrKeep> _selectDeleteOrKeep = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])DeleteOrKeep.values(), (Enum)DeleteOrKeep.Keep, (PropertyChangeListener)this);

    public FileAsFlag(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        FileAsFlag copy = new FileAsFlag(sysName, userName);
        copy.setComment(this.getComment());
        this._selectFilename.copy(copy._selectFilename);
        this._selectDeleteOrKeep.copy(copy._selectDeleteOrKeep);
        return manager.registerExpression(copy);
    }

    public LogixNG_SelectString getSelectFilename() {
        return this._selectFilename;
    }

    public LogixNG_SelectEnum<DeleteOrKeep> getSelectDeleteOrKeep() {
        return this._selectDeleteOrKeep;
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    @Override
    public boolean evaluate() throws JmriException {
        String filename = this._selectFilename.evaluateValue(this.getConditionalNG());
        DeleteOrKeep deleteOrKeep = this._selectDeleteOrKeep.evaluateEnum(this.getConditionalNG());
        if (filename == null) {
            return false;
        }
        try {
            File file = new File(FileUtil.getExternalFilename(filename));
            if (file.exists()) {
                if (deleteOrKeep == DeleteOrKeep.Delete) {
                    Files.delete(file.toPath());
                }
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new JmriException("IOException has occurred: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "FileAsFlag_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String filename = this._selectFilename.getDescription(locale);
        String deleteOrKeep = this._selectDeleteOrKeep.getDescription(locale);
        return Bundle.getMessage(locale, "FileAsFlag_Long", filename, deleteOrKeep);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    public static enum DeleteOrKeep {
        Delete(Bundle.getMessage("FileAsFlag_Delete")),
        Keep(Bundle.getMessage("FileAsFlag_Keep"));

        private final String _text;

        private DeleteOrKeep(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

