/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hold
extends AbstractDigitalExpression
implements FemaleSocketListener {
    private String _triggerExpressionSocketSystemName;
    private String _holdExpressionSocketSystemName;
    private final FemaleDigitalExpressionSocket _triggerExpressionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("Hold_SocketName_Trigger"));
    private final FemaleDigitalExpressionSocket _holdExpressionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("Hold_SocketName_Hold"));
    private boolean _isActive = false;
    private static final Logger log = LoggerFactory.getLogger(Hold.class);

    public Hold(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        Hold copy = new Hold(sysName, userName);
        copy.setComment(this.getComment());
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    @Override
    public boolean evaluate() throws JmriException {
        this._isActive = this._isActive ? this._holdExpressionSocket.evaluate() || this._triggerExpressionSocket.evaluate() : this._triggerExpressionSocket.evaluate();
        return this._isActive;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._triggerExpressionSocket;
            }
            case 1: {
                return this._holdExpressionSocket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 2;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket == this._triggerExpressionSocket) {
            this._triggerExpressionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else if (socket == this._holdExpressionSocket) {
            this._holdExpressionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket == this._triggerExpressionSocket) {
            this._triggerExpressionSocketSystemName = null;
        } else if (socket == this._holdExpressionSocket) {
            this._holdExpressionSocketSystemName = null;
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Hold_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "Hold_Long", this._triggerExpressionSocket.getName(), this._holdExpressionSocket.getName());
    }

    public String getTriggerExpressionSocketSystemName() {
        return this._triggerExpressionSocketSystemName;
    }

    public void setTriggerExpressionSocketSystemName(String systemName) {
        this._triggerExpressionSocketSystemName = systemName;
    }

    public String getHoldActionSocketSystemName() {
        return this._holdExpressionSocketSystemName;
    }

    public void setHoldActionSocketSystemName(String systemName) {
        this._holdExpressionSocketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            MaleSocket maleSocket;
            String socketSystemName;
            if (!this._triggerExpressionSocket.isConnected() || !this._triggerExpressionSocket.getConnectedSocket().getSystemName().equals(this._triggerExpressionSocketSystemName)) {
                socketSystemName = this._triggerExpressionSocketSystemName;
                this._triggerExpressionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    this._triggerExpressionSocket.disconnect();
                    if (maleSocket != null) {
                        this._triggerExpressionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital expression {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._triggerExpressionSocket.getConnectedSocket().setup();
            }
            if (!this._holdExpressionSocket.isConnected() || !this._holdExpressionSocket.getConnectedSocket().getSystemName().equals(this._holdExpressionSocketSystemName)) {
                socketSystemName = this._holdExpressionSocketSystemName;
                this._holdExpressionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._holdExpressionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital expression {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._holdExpressionSocket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }
}

