/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrit.logixng.expressions.Bundle;
import jmri.jmrit.logixng.util.ProtectedTimerTask;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.TimerUnit;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TimerUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timer
extends AbstractDigitalExpression {
    private final Map<ConditionalNG, StateAndTimerTask> _stateAndTimerTask = new HashMap<ConditionalNG, StateAndTimerTask>();
    private int _delay;
    private NamedBeanAddressing _stateAddressing = NamedBeanAddressing.Direct;
    private TimerUnit _unit = TimerUnit.MilliSeconds;
    private String _stateReference = "";
    private String _stateLocalVariable = "";
    private String _stateFormula = "";
    private ExpressionNode _stateExpressionNode;
    private static final Logger log = LoggerFactory.getLogger(Timer.class);

    public Timer(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        Timer copy = new Timer(sysName, userName);
        copy.setComment(this.getComment());
        copy.setDelayAddressing(this._stateAddressing);
        copy.setDelay(this._delay);
        copy.setDelayFormula(this._stateFormula);
        copy.setDelayLocalVariable(this._stateLocalVariable);
        copy.setDelayReference(this._stateReference);
        copy.setUnit(this._unit);
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.COMMON;
    }

    private ProtectedTimerTask getNewTimerTask(final ConditionalNG conditionalNG, final long timerDelay, final long timerStart) throws JmriException {
        return new ProtectedTimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                try {
                    Timer timer = Timer.this;
                    synchronized (timer) {
                        StateAndTimerTask stateAndTimerTask = Timer.this._stateAndTimerTask.get(conditionalNG);
                        stateAndTimerTask._timerTask = null;
                        long currentTime = System.currentTimeMillis();
                        long currentTimerTime = currentTime - timerStart;
                        if (currentTimerTime < timerDelay) {
                            Timer.this.scheduleTimer(conditionalNG, timerDelay, timerStart);
                        } else {
                            stateAndTimerTask._currentState = State.COMPLETED;
                            if (conditionalNG.isListenersRegistered()) {
                                conditionalNG.execute();
                            }
                        }
                    }
                }
                catch (RuntimeException | JmriException e) {
                    log.error("Exception thrown", (Throwable)e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTimer(ConditionalNG conditionalNG, long timerDelay, long timerStart) throws JmriException {
        Timer timer = this;
        synchronized (timer) {
            StateAndTimerTask stateAndTimerTask = this._stateAndTimerTask.get(conditionalNG);
            if (stateAndTimerTask._timerTask != null) {
                stateAndTimerTask._timerTask.stopTimer();
            }
            long currentTime = System.currentTimeMillis();
            long currentTimerTime = currentTime - timerStart;
            stateAndTimerTask._timerTask = this.getNewTimerTask(conditionalNG, timerDelay, timerStart);
            TimerUtil.schedule((TimerTask)stateAndTimerTask._timerTask, timerDelay - currentTimerTime);
        }
    }

    private long getNewDelay(ConditionalNG conditionalNG) throws JmriException {
        switch (this._stateAddressing) {
            case Direct: {
                return this._delay;
            }
            case Reference: {
                return TypeConversionUtil.convertToLong(ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._stateReference));
            }
            case LocalVariable: {
                SymbolTable symbolTable = conditionalNG.getSymbolTable();
                return TypeConversionUtil.convertToLong(symbolTable.getValue(this._stateLocalVariable));
            }
            case Formula: {
                return this._stateExpressionNode != null ? TypeConversionUtil.convertToLong(this._stateExpressionNode.calculate(conditionalNG.getSymbolTable())) : 0L;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._stateAddressing.name());
    }

    @Override
    public boolean evaluate() throws JmriException {
        Timer timer = this;
        synchronized (timer) {
            ConditionalNG conditionalNG = this.getConditionalNG();
            StateAndTimerTask stateAndTimerTask = this._stateAndTimerTask.computeIfAbsent(conditionalNG, o -> new StateAndTimerTask());
            switch (stateAndTimerTask._currentState) {
                case RUNNING: {
                    return false;
                }
                case COMPLETED: {
                    stateAndTimerTask._currentState = State.IDLE;
                    return true;
                }
                case IDLE: {
                    stateAndTimerTask._currentState = State.RUNNING;
                    if (stateAndTimerTask._timerTask != null) {
                        stateAndTimerTask._timerTask.stopTimer();
                    }
                    long timerStart = System.currentTimeMillis();
                    long timerDelay = this.getNewDelay(conditionalNG) * this._unit.getMultiply();
                    this.scheduleTimer(conditionalNG, timerDelay, timerStart);
                    return false;
                }
            }
            throw new UnsupportedOperationException("currentState has invalid state: " + stateAndTimerTask._currentState.name());
        }
    }

    public void setDelayAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._stateAddressing = addressing;
        this.parseDelayFormula();
    }

    public NamedBeanAddressing getDelayAddressing() {
        return this._stateAddressing;
    }

    public int getDelay() {
        return this._delay;
    }

    public void setDelay(int delay) {
        this._delay = delay;
    }

    public void setDelayReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._stateReference = reference;
    }

    public String getDelayReference() {
        return this._stateReference;
    }

    public void setDelayLocalVariable(@Nonnull String localVariable) {
        this._stateLocalVariable = localVariable;
    }

    public String getDelayLocalVariable() {
        return this._stateLocalVariable;
    }

    public void setDelayFormula(@Nonnull String formula) throws ParserException {
        this._stateFormula = formula;
        this.parseDelayFormula();
    }

    public String getDelayFormula() {
        return this._stateFormula;
    }

    private void parseDelayFormula() throws ParserException {
        if (this._stateAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._stateExpressionNode = parser.parseExpression(this._stateFormula);
        } else {
            this._stateExpressionNode = null;
        }
    }

    public TimerUnit getUnit() {
        return this._unit;
    }

    public void setUnit(TimerUnit unit) {
        this._unit = unit;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Timer_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String delay;
        switch (this._stateAddressing) {
            case Direct: {
                delay = Bundle.getMessage(locale, "Timer_DelayByDirect", this._unit.getTimeWithUnit(this._delay));
                break;
            }
            case Reference: {
                delay = Bundle.getMessage(locale, "Timer_DelayByReference", this._stateReference, this._unit.toString());
                break;
            }
            case LocalVariable: {
                delay = Bundle.getMessage(locale, "Timer_DelayByLocalVariable", this._stateLocalVariable, this._unit.toString());
                break;
            }
            case Formula: {
                delay = Bundle.getMessage(locale, "Timer_DelayByFormula", this._stateFormula, this._unit.toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._stateAddressing.name());
            }
        }
        return Bundle.getMessage(locale, "Timer_Long", delay);
    }

    @Override
    public void setup() {
    }

    private static enum State {
        IDLE,
        RUNNING,
        COMPLETED;

    }

    private static class StateAndTimerTask {
        ProtectedTimerTask _timerTask;
        State _currentState = State.IDLE;

        private StateAndTimerTask() {
        }
    }
}

