/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.configurexml;

import jmri.InstanceManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.expressions.ExpressionScript;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import jmri.script.configurexml.ScriptEngineSelectorXml;
import org.jdom2.Content;
import org.jdom2.Element;

public class ExpressionScriptXml
extends AbstractNamedBeanManagerConfigXML {
    @Override
    public Element store(Object o) {
        ExpressionScript p = (ExpressionScript)o;
        Element element = new Element("ExpressionScript");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        ScriptEngineSelectorXml scriptEngineSelectorXml = new ScriptEngineSelectorXml();
        element.addContent((Content)new Element("operationAddressing").addContent(p.getOperationAddressing().name()));
        element.addContent((Content)new Element("operationType").addContent(p.getOperationType().name()));
        element.addContent((Content)new Element("operationReference").addContent(p.getOperationReference()));
        element.addContent((Content)new Element("operationLocalVariable").addContent(p.getOperationLocalVariable()));
        element.addContent((Content)new Element("operationFormula").addContent(p.getOperationFormula()));
        element.addContent((Content)new Element("scriptAddressing").addContent(p.getScriptAddressing().name()));
        element.addContent((Content)new Element("script").addContent(p.getScript()));
        element.addContent((Content)new Element("scriptReference").addContent(p.getScriptReference()));
        element.addContent((Content)new Element("scriptLocalVariable").addContent(p.getScriptLocalVariable()));
        element.addContent((Content)new Element("scriptFormula").addContent(p.getScriptFormula()));
        element.addContent((Content)new Element("registerListenerScript").addContent(p.getRegisterListenerScript()));
        element.addContent((Content)new Element("unregisterListenerScript").addContent(p.getUnregisterListenerScript()));
        element.addContent((Content)scriptEngineSelectorXml.store(p.getScriptEngineSelector(), "scriptLanguage"));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        Element elem;
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ExpressionScript h = new ExpressionScript(sys, uname);
        this.loadCommon(h, shared);
        ScriptEngineSelectorXml scriptEngineSelectorXml = new ScriptEngineSelectorXml();
        try {
            Element unregisterListenerScriptElement;
            Element registerListenerScriptElement;
            Element scriptElement;
            Element queryType;
            elem = shared.getChild("operationAddressing");
            if (elem != null) {
                h.setOperationAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((queryType = shared.getChild("operationType")) != null) {
                if ("JythonCommand".equals(queryType.getTextTrim())) {
                    h.setOperationType(ExpressionScript.OperationType.SingleLineCommand);
                } else {
                    h.setOperationType(ExpressionScript.OperationType.valueOf(queryType.getTextTrim()));
                }
            }
            if ((elem = shared.getChild("operationReference")) != null) {
                h.setOperationReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationLocalVariable")) != null) {
                h.setOperationLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationFormula")) != null) {
                h.setOperationFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("scriptAddressing")) != null) {
                h.setScriptAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((scriptElement = shared.getChild("script")) != null) {
                h.setScript(scriptElement.getText());
            }
            if ((elem = shared.getChild("scriptReference")) != null) {
                h.setScriptReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("scriptLocalVariable")) != null) {
                h.setScriptLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("scriptFormula")) != null) {
                h.setScriptFormula(elem.getTextTrim());
            }
            if ((registerListenerScriptElement = shared.getChild("registerListenerScript")) != null) {
                h.setRegisterListenerScript(registerListenerScriptElement.getText());
            }
            if ((unregisterListenerScriptElement = shared.getChild("unregisterListenerScript")) != null) {
                h.setUnregisterListenerScript(unregisterListenerScriptElement.getText());
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        elem = shared.getChild("scriptLanguage");
        if (elem != null) {
            scriptEngineSelectorXml.load(elem, h.getScriptEngineSelector());
        }
        InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(h);
        return true;
    }
}

