/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.configurexml;

import jmri.InstanceManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.expressions.Timer;
import jmri.jmrit.logixng.util.TimerUnit;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class TimerXml
extends AbstractNamedBeanManagerConfigXML {
    @Override
    public Element store(Object o) {
        Timer p = (Timer)o;
        Element element = new Element("Timer");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        element.addContent((Content)new Element("delayAddressing").addContent(p.getDelayAddressing().name()));
        element.addContent((Content)new Element("delay").addContent(Integer.toString(p.getDelay())));
        element.addContent((Content)new Element("delayReference").addContent(p.getDelayReference()));
        element.addContent((Content)new Element("delayLocalVariable").addContent(p.getDelayLocalVariable()));
        element.addContent((Content)new Element("delayFormula").addContent(p.getDelayFormula()));
        element.addContent((Content)new Element("unit").addContent(p.getUnit().name()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        Timer h = new Timer(sys, uname);
        this.loadCommon(h, shared);
        Element delayElement = shared.getChild("delay");
        int delay = 0;
        if (delayElement != null) {
            delay = Integer.parseInt(delayElement.getText());
        }
        h.setDelay(delay);
        Element unit = shared.getChild("unit");
        if (unit != null) {
            h.setUnit(TimerUnit.valueOf(unit.getTextTrim()));
        }
        try {
            Element elem = shared.getChild("delayAddressing");
            if (elem != null) {
                h.setDelayAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("delayReference")) != null) {
                h.setDelayReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("delayLocalVariable")) != null) {
                h.setDelayLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("delayFormula")) != null) {
                h.setDelayFormula(elem.getTextTrim());
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(h);
        return true;
    }
}

