/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.swing;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.expressions.ConnectionName;
import jmri.jmrit.logixng.expressions.swing.AbstractDigitalExpressionSwing;
import jmri.jmrit.logixng.expressions.swing.Bundle;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.jmrix.JmrixConfigPane;
import jmri.jmrix.StreamConnectionConfig;
import jmri.util.swing.JComboBoxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionNameSwing
extends AbstractDigitalExpressionSwing {
    private final ConnectionConfigManager manager = InstanceManager.getDefault(ConnectionConfigManager.class);
    private JComboBox<String> _manufacturerComboBox;
    private JComboBox<String> _connectionComboBox;
    private ConnectionConfig[] _connectionConfigs;
    private static final Logger log = LoggerFactory.getLogger(ConnectionNameSwing.class);

    public ConnectionNameSwing() {
    }

    public ConnectionNameSwing(JDialog dialog) {
        super.setJDialog(dialog);
    }

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ConnectionName action = object != null ? (ConnectionName)object : new ConnectionName("IQDE1", null);
        String[] manufactureNameList = this.manager.getConnectionManufacturers();
        this._connectionConfigs = this.manager.getConnections();
        this.panel = new JPanel();
        String selectedManufacturer = action.getManufacturer();
        if ((selectedManufacturer == null || selectedManufacturer.isBlank() || JmrixConfigPane.NONE_SELECTED.equals(selectedManufacturer)) && this._connectionConfigs.length > 0) {
            selectedManufacturer = this._connectionConfigs[0].getManufacturer();
        }
        JPanel manufacturerPanel = new JPanel();
        manufacturerPanel.setLayout(new BoxLayout(manufacturerPanel, 1));
        JPanel mLabel = new JPanel();
        mLabel.add(new JLabel(Bundle.getMessage("ExpressionConnection_Manufacturer")));
        manufacturerPanel.add(mLabel);
        this._manufacturerComboBox = new JComboBox();
        manufacturerPanel.add(this._manufacturerComboBox);
        for (String manuName : manufactureNameList) {
            this._manufacturerComboBox.addItem(manuName);
            if (!manuName.equals(selectedManufacturer)) continue;
            this._manufacturerComboBox.setSelectedItem(selectedManufacturer);
        }
        if (this._manufacturerComboBox.getSelectedIndex() == -1) {
            this._manufacturerComboBox.setSelectedIndex(0);
        }
        JPanel connectionNamePanel = new JPanel();
        connectionNamePanel.setLayout(new BoxLayout(connectionNamePanel, 1));
        JPanel cLabel = new JPanel();
        cLabel.add(new JLabel(Bundle.getMessage("ExpressionConnection_Connection")));
        connectionNamePanel.add(cLabel);
        this._connectionComboBox = new JComboBox();
        connectionNamePanel.add(this._connectionComboBox);
        this._manufacturerComboBox.addActionListener(evt -> this.updateConnectionComboBox(action));
        this.updateConnectionComboBox(action);
        JComboBoxUtil.setupComboBoxMaxRows(this._manufacturerComboBox);
        JComboBoxUtil.setupComboBoxMaxRows(this._connectionComboBox);
        this.panel.add(manufacturerPanel);
        this.panel.add(connectionNamePanel);
    }

    private void updateConnectionComboBox(ConnectionName action) {
        String selectedManufacturer = (String)this._manufacturerComboBox.getSelectedItem();
        String[] classConnectionNameList = this.manager.getConnectionTypes(selectedManufacturer);
        String selectedConnectionName = null;
        if (selectedManufacturer.equals(action.getManufacturer())) {
            selectedConnectionName = action.getConnectionName();
        }
        if (selectedConnectionName == null || selectedConnectionName.isBlank() || JmrixConfigPane.NONE_SELECTED.equals(selectedConnectionName)) {
            for (int i = 0; i < this._connectionConfigs.length; ++i) {
                if (!this._connectionConfigs[i].getManufacturer().equals(selectedManufacturer)) continue;
                selectedConnectionName = this._connectionConfigs[i].name();
            }
        }
        this._connectionComboBox.removeAllItems();
        this._connectionComboBox.addItem(JmrixConfigPane.NONE_SELECTED);
        for (String className : classConnectionNameList) {
            try {
                Class<?> cl = Class.forName(className);
                ConnectionConfig config = (ConnectionConfig)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (config instanceof StreamConnectionConfig || config == null) continue;
                this._connectionComboBox.addItem(config.name());
                if (!config.name().equals(selectedConnectionName)) continue;
                this._connectionComboBox.setSelectedItem(selectedConnectionName);
            }
            catch (NullPointerException e) {
                log.error("Attempt to load {} failed.", (Object)className, (Object)e);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error("Attempt to load {} failed", (Object)className, (Object)e);
            }
        }
        JDialog dialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this._manufacturerComboBox);
        if (dialog != null) {
            dialog.pack();
        }
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ConnectionName action = new ConnectionName(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof ConnectionName)) {
            throw new IllegalArgumentException("object must be an ConnectionName but is a: " + object.getClass().getName());
        }
        ConnectionName action = (ConnectionName)object;
        if (this._manufacturerComboBox.getSelectedIndex() != -1) {
            action.setManufacturer(this._manufacturerComboBox.getItemAt(this._manufacturerComboBox.getSelectedIndex()));
        }
        if (this._connectionComboBox.getSelectedIndex() != -1) {
            action.setConnectionName(this._connectionComboBox.getItemAt(this._connectionComboBox.getSelectedIndex()));
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ConnectionName_Short");
    }

    @Override
    public void dispose() {
    }
}

