/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.expressions.ExpressionMemory;
import jmri.jmrit.logixng.expressions.swing.AbstractDigitalExpressionSwing;
import jmri.jmrit.logixng.expressions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectTableSwing;
import jmri.util.CompareUtil;
import jmri.util.swing.BeanSelectPanel;
import jmri.util.swing.JComboBoxUtil;

public class ExpressionMemorySwing
extends AbstractDigitalExpressionSwing {
    private LogixNG_SelectTableSwing selectTableSwing;
    private BeanSelectPanel<Memory> _memoryBeanPanel;
    private JComboBox<ExpressionMemory.MemoryOperation> _memoryOperationComboBox;
    private JComboBox<CompareUtil.CompareType> _variableCompareTypeComboBox;
    private JCheckBox _caseInsensitiveCheckBox;
    private JTabbedPane _tabbedPane;
    private JTabbedPane _tabbedPaneCompareTo;
    private BeanSelectPanel<Memory> _compareToMemoryBeanPanel;
    private JPanel _compareToConstant;
    private JPanel _compareToMemory;
    private JPanel _compareToLocalVariable;
    private JPanel _compareToTable;
    private JPanel _compareToRegEx;
    private JTextField _compareToConstantTextField;
    private JTextField _compareToLocalVariableTextField;
    private JTextField _compareToRegExTextField;

    private void enableDisableCompareTo() {
        ExpressionMemory.MemoryOperation mo = this._memoryOperationComboBox.getItemAt(this._memoryOperationComboBox.getSelectedIndex());
        boolean enable = mo.hasExtraValue();
        this._tabbedPaneCompareTo.setEnabled(enable);
        ((JPanel)this._tabbedPaneCompareTo.getSelectedComponent()).getComponent(0).setEnabled(enable);
        boolean regEx = mo == ExpressionMemory.MemoryOperation.MatchRegex || mo == ExpressionMemory.MemoryOperation.NotMatchRegex;
        this._tabbedPane.setEnabledAt(0, !regEx);
        this._tabbedPane.setEnabledAt(1, regEx);
        this._tabbedPane.setSelectedIndex(regEx ? 1 : 0);
    }

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ExpressionMemory expression = (ExpressionMemory)object;
        this.selectTableSwing = new LogixNG_SelectTableSwing(this.getJDialog(), this);
        this.panel = new JPanel();
        this._memoryBeanPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(MemoryManager.class), null);
        JPanel operationAndCasePanel = new JPanel();
        operationAndCasePanel.setLayout(new GridBagLayout());
        GridBagConstraints constraint = new GridBagConstraints();
        constraint.gridwidth = 2;
        constraint.gridheight = 1;
        constraint.gridx = 0;
        constraint.gridy = 0;
        constraint.anchor = 13;
        this._memoryOperationComboBox = new JComboBox();
        for (ExpressionMemory.MemoryOperation memoryOperation : ExpressionMemory.MemoryOperation.values()) {
            this._memoryOperationComboBox.addItem(memoryOperation);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._memoryOperationComboBox);
        operationAndCasePanel.add(this._memoryOperationComboBox, constraint);
        this._memoryOperationComboBox.addActionListener(e -> this.enableDisableCompareTo());
        constraint.gridy = 1;
        operationAndCasePanel.add(Box.createVerticalStrut(8), constraint);
        constraint.gridwidth = 1;
        constraint.gridx = 0;
        constraint.gridy = 2;
        constraint.anchor = 13;
        operationAndCasePanel.add((Component)new JLabel(Bundle.getMessage("ExpressionMemory_CompareType") + " "), constraint);
        constraint.gridx = 1;
        constraint.anchor = 17;
        this._variableCompareTypeComboBox = new JComboBox();
        for (Enum enum_ : CompareUtil.CompareType.values()) {
            this._variableCompareTypeComboBox.addItem((CompareUtil.CompareType)enum_);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._variableCompareTypeComboBox);
        operationAndCasePanel.add(this._variableCompareTypeComboBox, constraint);
        this._variableCompareTypeComboBox.addActionListener(e -> {
            CompareUtil.CompareType type = this._variableCompareTypeComboBox.getItemAt(this._variableCompareTypeComboBox.getSelectedIndex());
            this._caseInsensitiveCheckBox.setEnabled(type != CompareUtil.CompareType.Number);
        });
        constraint.gridwidth = 2;
        constraint.gridx = 0;
        constraint.gridy = 3;
        constraint.anchor = 17;
        this._caseInsensitiveCheckBox = new JCheckBox(Bundle.getMessage("ExpressionMemory_CaseInsensitive"));
        operationAndCasePanel.add((Component)this._caseInsensitiveCheckBox, constraint);
        this._tabbedPane = new JTabbedPane();
        this._tabbedPaneCompareTo = new JTabbedPane();
        this._tabbedPane.addTab("", this._tabbedPaneCompareTo);
        this._compareToConstant = new JPanel();
        this._compareToMemory = new JPanel();
        this._compareToTable = expression != null ? this.selectTableSwing.createPanel(expression.getSelectTable()) : this.selectTableSwing.createPanel(null);
        this._compareToLocalVariable = new JPanel();
        this._compareToRegEx = new JPanel();
        this._tabbedPaneCompareTo.addTab(ExpressionMemory.CompareTo.Value.toString(), this._compareToConstant);
        this._tabbedPaneCompareTo.addTab(ExpressionMemory.CompareTo.Memory.toString(), this._compareToMemory);
        this._tabbedPaneCompareTo.addTab(ExpressionMemory.CompareTo.LocalVariable.toString(), this._compareToLocalVariable);
        this._tabbedPaneCompareTo.addTab(ExpressionMemory.CompareTo.Table.toString(), this._compareToTable);
        this._tabbedPane.addTab(ExpressionMemory.CompareTo.RegEx.toString(), this._compareToRegEx);
        this._compareToConstantTextField = new JTextField(30);
        this._compareToConstant.add(this._compareToConstantTextField);
        this._compareToMemoryBeanPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(MemoryManager.class), null);
        this._compareToMemory.add(this._compareToMemoryBeanPanel);
        this._compareToLocalVariableTextField = new JTextField(30);
        this._compareToLocalVariable.add(this._compareToLocalVariableTextField);
        this._compareToRegExTextField = new JTextField(30);
        this._compareToRegEx.add(this._compareToRegExTextField);
        if (expression != null) {
            if (expression.getSelectNamedBean().getNamedBean() != null) {
                this._memoryBeanPanel.setDefaultNamedBean(expression.getSelectNamedBean().getNamedBean().getBean());
            }
            if (expression.getSelectOtherMemoryNamedBean().getNamedBean() != null) {
                this._compareToMemoryBeanPanel.setDefaultNamedBean(expression.getSelectOtherMemoryNamedBean().getNamedBean().getBean());
            }
            switch (expression.getCompareTo()) {
                case RegEx: 
                case Value: {
                    this._tabbedPaneCompareTo.setSelectedComponent(this._compareToConstant);
                    break;
                }
                case Memory: {
                    this._tabbedPaneCompareTo.setSelectedComponent(this._compareToMemory);
                    break;
                }
                case Table: {
                    this._tabbedPaneCompareTo.setSelectedComponent(this._compareToTable);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneCompareTo.setSelectedComponent(this._compareToLocalVariable);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + expression.getCompareTo().name());
                }
            }
            this._memoryOperationComboBox.setSelectedItem((Object)expression.getMemoryOperation());
            this._variableCompareTypeComboBox.setSelectedItem((Object)expression.getCompareType());
            this._caseInsensitiveCheckBox.setSelected(expression.getCaseInsensitive());
            this._compareToConstantTextField.setText(expression.getConstantValue());
            this._compareToLocalVariableTextField.setText(expression.getLocalVariable());
            this._compareToRegExTextField.setText(expression.getRegEx());
        }
        JComponent[] components = new JComponent[]{this._memoryBeanPanel, operationAndCasePanel, this._tabbedPane};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ExpressionMemory_Components"), components);
        for (JComponent jComponent : componentList) {
            this.panel.add(jComponent);
        }
        this.enableDisableCompareTo();
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        ExpressionMemory expression = new ExpressionMemory("IQDE1", null);
        return this.selectTableSwing.validate(expression.getSelectTable(), errorMessages);
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ExpressionMemory expression = new ExpressionMemory(systemName, userName);
        this.updateObject(expression);
        return InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(expression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof ExpressionMemory)) {
            throw new IllegalArgumentException("object must be an ExpressionMemory but is a: " + object.getClass().getName());
        }
        ExpressionMemory expression = (ExpressionMemory)object;
        Memory memory = this._memoryBeanPanel.getNamedBean();
        if (memory != null) {
            NamedBeanHandle<Memory> handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory);
            expression.getSelectNamedBean().setNamedBean((Memory)((Object)handle));
        } else {
            expression.getSelectNamedBean().removeNamedBean();
        }
        expression.setMemoryOperation(this._memoryOperationComboBox.getItemAt(this._memoryOperationComboBox.getSelectedIndex()));
        expression.setCompareType(this._variableCompareTypeComboBox.getItemAt(this._variableCompareTypeComboBox.getSelectedIndex()));
        expression.setCaseInsensitive(this._caseInsensitiveCheckBox.isSelected());
        if (!this._compareToMemoryBeanPanel.isEmpty() && this._tabbedPane.getSelectedComponent() == this._tabbedPaneCompareTo && this._tabbedPaneCompareTo.getSelectedComponent() == this._compareToMemory) {
            Memory otherMemory = this._compareToMemoryBeanPanel.getNamedBean();
            if (otherMemory != null) {
                NamedBeanHandle<Memory> handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(otherMemory.getDisplayName(), otherMemory);
                expression.getSelectOtherMemoryNamedBean().setNamedBean((Memory)((Object)handle));
            } else {
                expression.getSelectOtherMemoryNamedBean().removeNamedBean();
            }
        } else {
            expression.getSelectOtherMemoryNamedBean().removeNamedBean();
        }
        if (this._tabbedPane.getSelectedComponent() == this._tabbedPaneCompareTo) {
            if (this._tabbedPaneCompareTo.getSelectedComponent() == this._compareToConstant) {
                expression.setCompareTo(ExpressionMemory.CompareTo.Value);
                expression.setConstantValue(this._compareToConstantTextField.getText());
            } else if (this._tabbedPaneCompareTo.getSelectedComponent() == this._compareToMemory) {
                expression.setCompareTo(ExpressionMemory.CompareTo.Memory);
            } else if (this._tabbedPaneCompareTo.getSelectedComponent() == this._compareToTable) {
                expression.setCompareTo(ExpressionMemory.CompareTo.Table);
            } else {
                if (this._tabbedPaneCompareTo.getSelectedComponent() != this._compareToLocalVariable) throw new IllegalArgumentException("_tabbedPaneLight has unknown selection");
                expression.setCompareTo(ExpressionMemory.CompareTo.LocalVariable);
                expression.setLocalVariable(this._compareToLocalVariableTextField.getText());
            }
        } else {
            expression.setCompareTo(ExpressionMemory.CompareTo.RegEx);
            expression.setRegEx(this._compareToRegExTextField.getText());
        }
        this.selectTableSwing.updateObject(expression.getSelectTable());
    }

    @Override
    public String toString() {
        return Bundle.getMessage("Memory_Short");
    }

    @Override
    public boolean canClose() {
        return this.selectTableSwing.canClose();
    }

    @Override
    public void dispose() {
        this.selectTableSwing.dispose();
    }
}

