/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.expressions.ExpressionScript;
import jmri.jmrit.logixng.expressions.swing.AbstractDigitalExpressionSwing;
import jmri.jmrit.logixng.expressions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.script.ScriptEngineSelector;
import jmri.script.swing.ScriptEngineSelectorSwing;
import jmri.script.swing.ScriptFileChooser;
import jmri.util.FileUtil;
import jmri.util.swing.JComboBoxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionScriptSwing
extends AbstractDigitalExpressionSwing {
    public static final int NUM_COLUMNS_TEXT_FIELDS = 20;
    private JTabbedPane _tabbedPaneOperationType;
    private JPanel _panelOperationTypeDirect;
    private JPanel _panelOperationTypeReference;
    private JPanel _panelOperationTypeLocalVariable;
    private JPanel _panelOperationTypeFormula;
    private JComboBox<ExpressionScript.OperationType> _operationComboBox;
    private JTextField _scriptOperationReferenceTextField;
    private JTextField _scriptOperationLocalVariableTextField;
    private JTextField _scriptOperationFormulaTextField;
    private JTabbedPane _tabbedPaneScriptType;
    private JPanel _panelScriptTypeDirect;
    private JPanel _panelScriptTypeReference;
    private JPanel _panelScriptTypeLocalVariable;
    private JPanel _panelScriptTypeFormula;
    private ScriptFileChooser scriptFileChooser;
    private JTextField _scriptTextField;
    private JTextField _scriptReferenceTextField;
    private JTextField _scriptLocalVariableTextField;
    private JTextField _scriptFormulaTextField;
    private JLabel _registerListenerLabel;
    private JLabel _unregisterListenerLabel;
    private JTextField _registerListener;
    private JTextField _unregisterListener;
    private ScriptEngineSelectorSwing _scriptEngineSelectorSwing;
    private static final Logger log = LoggerFactory.getLogger(ExpressionScriptSwing.class);

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        Serializable c2;
        ExpressionScript expression = (ExpressionScript)object;
        this._scriptEngineSelectorSwing = expression != null ? new ScriptEngineSelectorSwing(expression.getScriptEngineSelector()) : new ScriptEngineSelectorSwing(new ScriptEngineSelector());
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JPanel expressionPanel = new JPanel();
        this._tabbedPaneOperationType = new JTabbedPane();
        this._panelOperationTypeDirect = new JPanel();
        this._panelOperationTypeDirect.setLayout(new BoxLayout(this._panelOperationTypeDirect, 1));
        this._panelOperationTypeReference = new JPanel();
        this._panelOperationTypeReference.setLayout(new BoxLayout(this._panelOperationTypeReference, 1));
        this._panelOperationTypeLocalVariable = new JPanel();
        this._panelOperationTypeLocalVariable.setLayout(new BoxLayout(this._panelOperationTypeLocalVariable, 1));
        this._panelOperationTypeFormula = new JPanel();
        this._panelOperationTypeFormula.setLayout(new BoxLayout(this._panelOperationTypeFormula, 1));
        this._tabbedPaneOperationType.addTab(NamedBeanAddressing.Direct.toString(), this._panelOperationTypeDirect);
        this._tabbedPaneOperationType.addTab(NamedBeanAddressing.Reference.toString(), this._panelOperationTypeReference);
        this._tabbedPaneOperationType.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelOperationTypeLocalVariable);
        this._tabbedPaneOperationType.addTab(NamedBeanAddressing.Formula.toString(), this._panelOperationTypeFormula);
        this._operationComboBox = new JComboBox();
        for (ExpressionScript.OperationType e2 : ExpressionScript.OperationType.values()) {
            this._operationComboBox.addItem(e2);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._operationComboBox);
        this._panelOperationTypeDirect.add(new JLabel(Bundle.getMessage("ExpressionScript_Operation")));
        this._panelOperationTypeDirect.add(this._operationComboBox);
        this._scriptOperationReferenceTextField = new JTextField();
        this._scriptOperationReferenceTextField.setColumns(20);
        this._panelOperationTypeReference.add(new JLabel(Bundle.getMessage("ExpressionScript_Operation")));
        this._panelOperationTypeReference.add(this._scriptOperationReferenceTextField);
        this._scriptOperationLocalVariableTextField = new JTextField();
        this._scriptOperationLocalVariableTextField.setColumns(20);
        this._panelOperationTypeLocalVariable.add(new JLabel(Bundle.getMessage("ExpressionScript_Operation")));
        this._panelOperationTypeLocalVariable.add(this._scriptOperationLocalVariableTextField);
        this._scriptOperationFormulaTextField = new JTextField();
        this._scriptOperationFormulaTextField.setColumns(20);
        this._panelOperationTypeFormula.add(new JLabel(Bundle.getMessage("ExpressionScript_Operation")));
        this._panelOperationTypeFormula.add(this._scriptOperationFormulaTextField);
        this._tabbedPaneScriptType = new JTabbedPane();
        this._panelScriptTypeDirect = new JPanel();
        this._panelScriptTypeReference = new JPanel();
        this._panelScriptTypeReference.setLayout(new BoxLayout(this._panelScriptTypeReference, 1));
        this._panelScriptTypeLocalVariable = new JPanel();
        this._panelScriptTypeLocalVariable.setLayout(new BoxLayout(this._panelScriptTypeLocalVariable, 1));
        this._panelScriptTypeFormula = new JPanel();
        this._panelScriptTypeFormula.setLayout(new BoxLayout(this._panelScriptTypeFormula, 1));
        this._tabbedPaneScriptType.addTab(NamedBeanAddressing.Direct.toString(), this._panelScriptTypeDirect);
        this._tabbedPaneScriptType.addTab(NamedBeanAddressing.Reference.toString(), this._panelScriptTypeReference);
        this._tabbedPaneScriptType.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelScriptTypeLocalVariable);
        this._tabbedPaneScriptType.addTab(NamedBeanAddressing.Formula.toString(), this._panelScriptTypeFormula);
        JButton _expressionSelectFileButton = new JButton("...");
        _expressionSelectFileButton.setMaximumSize(_expressionSelectFileButton.getPreferredSize());
        _expressionSelectFileButton.setToolTipText(Bundle.getMessage("FileButtonHint"));
        _expressionSelectFileButton.addActionListener(e -> {
            this.scriptFileChooser = new ScriptFileChooser(FileUtil.getScriptsPath());
            this.scriptFileChooser.rescanCurrentDirectory();
            int retVal = this.scriptFileChooser.showOpenDialog(null);
            if (retVal == 0) {
                try {
                    this._scriptTextField.setText(FileUtil.getPortableFilename(this.scriptFileChooser.getSelectedFile().getCanonicalPath()));
                }
                catch (IOException ex) {
                    log.error("exception setting file location", (Throwable)ex);
                    this._scriptTextField.setText("");
                }
            }
        });
        this._panelScriptTypeDirect.add(_expressionSelectFileButton);
        JPanel _scriptTextPanel = new JPanel();
        _scriptTextPanel.setLayout(new BoxLayout(_scriptTextPanel, 1));
        this._scriptTextField = new JTextField(30);
        _scriptTextPanel.add(new JLabel(Bundle.getMessage("ExpressionScript_Script")));
        _scriptTextPanel.add(this._scriptTextField);
        this._panelScriptTypeDirect.add(_scriptTextPanel);
        this._scriptReferenceTextField = new JTextField();
        this._scriptReferenceTextField.setColumns(20);
        this._panelScriptTypeReference.add(new JLabel(Bundle.getMessage("ExpressionScript_Script")));
        this._panelScriptTypeReference.add(this._scriptReferenceTextField);
        this._scriptLocalVariableTextField = new JTextField();
        this._scriptLocalVariableTextField.setColumns(20);
        this._panelScriptTypeLocalVariable.add(new JLabel(Bundle.getMessage("ExpressionScript_Script")));
        this._panelScriptTypeLocalVariable.add(this._scriptLocalVariableTextField);
        this._scriptFormulaTextField = new JTextField();
        this._scriptFormulaTextField.setColumns(20);
        this._panelScriptTypeFormula.add(new JLabel(Bundle.getMessage("ExpressionScript_Script")));
        this._panelScriptTypeFormula.add(this._scriptFormulaTextField);
        if (expression != null) {
            switch (expression.getOperationAddressing()) {
                case Direct: {
                    this._tabbedPaneOperationType.setSelectedComponent(this._panelOperationTypeDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneOperationType.setSelectedComponent(this._panelOperationTypeReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneOperationType.setSelectedComponent(this._panelOperationTypeLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneOperationType.setSelectedComponent(this._panelOperationTypeFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + expression.getOperationAddressing().name());
                }
            }
            this._operationComboBox.setSelectedItem((Object)expression.getOperationType());
            this._scriptOperationReferenceTextField.setText(expression.getOperationReference());
            this._scriptOperationLocalVariableTextField.setText(expression.getOperationLocalVariable());
            this._scriptOperationFormulaTextField.setText(expression.getOperationFormula());
            switch (expression.getScriptAddressing()) {
                case Direct: {
                    this._tabbedPaneScriptType.setSelectedComponent(this._panelScriptTypeDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneScriptType.setSelectedComponent(this._panelScriptTypeReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneScriptType.setSelectedComponent(this._panelScriptTypeLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneScriptType.setSelectedComponent(this._panelScriptTypeFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + expression.getScriptAddressing().name());
                }
            }
            this._scriptTextField.setText(expression.getScript());
            this._scriptReferenceTextField.setText(expression.getScriptReference());
            this._scriptLocalVariableTextField.setText(expression.getScriptLocalVariable());
            this._scriptFormulaTextField.setText(expression.getScriptFormula());
        }
        JComponent[] components = new JComponent[]{this._tabbedPaneOperationType, this._tabbedPaneScriptType};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ExpressionScript_Components"), components);
        for (Serializable c2 : componentList) {
            expressionPanel.add((Component)c2);
        }
        this.panel.add(expressionPanel);
        JPanel listernerPanel = new JPanel();
        this.panel.add(listernerPanel);
        this._registerListenerLabel = new JLabel(Bundle.getMessage("ExpressionScript_RegisterListener"));
        this._unregisterListenerLabel = new JLabel(Bundle.getMessage("ExpressionScript_UnregisterListener"));
        this._registerListener = new JTextField(30);
        this._unregisterListener = new JTextField(30);
        if (expression != null) {
            this._registerListener.setText(expression.getRegisterListenerScript());
            this._unregisterListener.setText(expression.getUnregisterListenerScript());
        }
        listernerPanel.setLayout(new GridBagLayout());
        c2 = new GridBagConstraints();
        ((GridBagConstraints)c2).gridwidth = 1;
        ((GridBagConstraints)c2).gridheight = 1;
        ((GridBagConstraints)c2).gridx = 0;
        ((GridBagConstraints)c2).gridy = 0;
        ((GridBagConstraints)c2).anchor = 13;
        listernerPanel.add((Component)this._registerListenerLabel, c2);
        this._registerListenerLabel.setLabelFor(this._registerListener);
        ((GridBagConstraints)c2).gridy = 1;
        listernerPanel.add((Component)this._unregisterListenerLabel, c2);
        this._unregisterListenerLabel.setLabelFor(this._unregisterListener);
        ((GridBagConstraints)c2).gridx = 1;
        ((GridBagConstraints)c2).gridy = 0;
        ((GridBagConstraints)c2).anchor = 17;
        listernerPanel.add((Component)this._registerListener, c2);
        ((GridBagConstraints)c2).gridy = 1;
        listernerPanel.add((Component)this._unregisterListener, c2);
        JPanel scriptSelectorPanel = new JPanel();
        scriptSelectorPanel.add(new JLabel(Bundle.getMessage("ExpressionScript_ScriptSelector")));
        scriptSelectorPanel.add(this._scriptEngineSelectorSwing.getComboBox());
        this.panel.add(scriptSelectorPanel);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        block9: {
            ExpressionScript expression = new ExpressionScript("IQDE1", null);
            try {
                if (this._tabbedPaneOperationType.getSelectedComponent() == this._panelOperationTypeReference) {
                    expression.setOperationReference(this._scriptOperationReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return false;
            }
            try {
                expression.setScriptFormula(this._scriptFormulaTextField.getText());
                if (this._tabbedPaneScriptType.getSelectedComponent() == this._panelScriptTypeDirect) {
                    expression.setScriptAddressing(NamedBeanAddressing.Direct);
                    break block9;
                }
                if (this._tabbedPaneScriptType.getSelectedComponent() == this._panelScriptTypeReference) {
                    expression.setScriptAddressing(NamedBeanAddressing.Reference);
                    break block9;
                }
                if (this._tabbedPaneScriptType.getSelectedComponent() == this._panelScriptTypeLocalVariable) {
                    expression.setScriptAddressing(NamedBeanAddressing.LocalVariable);
                    break block9;
                }
                if (this._tabbedPaneScriptType.getSelectedComponent() == this._panelScriptTypeFormula) {
                    expression.setScriptAddressing(NamedBeanAddressing.Formula);
                    break block9;
                }
                throw new IllegalArgumentException("_tabbedPaneScriptType has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
            }
        }
        return errorMessages.isEmpty();
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ExpressionScript expression = new ExpressionScript(systemName, userName);
        this.updateObject(expression);
        return InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(expression);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        ExpressionScript expression;
        block15: {
            if (!(object instanceof ExpressionScript)) {
                throw new IllegalArgumentException("object must be an ExpressionScript but is a: " + object.getClass().getName());
            }
            expression = (ExpressionScript)object;
            try {
                if (this._tabbedPaneOperationType.getSelectedComponent() == this._panelOperationTypeDirect) {
                    expression.setOperationAddressing(NamedBeanAddressing.Direct);
                    expression.setOperationType((ExpressionScript.OperationType)((Object)this._operationComboBox.getSelectedItem()));
                } else if (this._tabbedPaneOperationType.getSelectedComponent() == this._panelOperationTypeReference) {
                    expression.setOperationAddressing(NamedBeanAddressing.Reference);
                    expression.setOperationReference(this._scriptOperationReferenceTextField.getText());
                } else if (this._tabbedPaneOperationType.getSelectedComponent() == this._panelOperationTypeLocalVariable) {
                    expression.setOperationAddressing(NamedBeanAddressing.LocalVariable);
                    expression.setOperationLocalVariable(this._scriptOperationLocalVariableTextField.getText());
                } else if (this._tabbedPaneOperationType.getSelectedComponent() == this._panelOperationTypeFormula) {
                    expression.setOperationAddressing(NamedBeanAddressing.Formula);
                    expression.setOperationFormula(this._scriptOperationFormulaTextField.getText());
                } else {
                    throw new IllegalArgumentException("_tabbedPaneOperationType has unknown selection");
                }
                if (this._tabbedPaneScriptType.getSelectedComponent() == this._panelScriptTypeDirect) {
                    expression.setScriptAddressing(NamedBeanAddressing.Direct);
                    expression.setScript(this._scriptTextField.getText());
                    break block15;
                }
                if (this._tabbedPaneScriptType.getSelectedComponent() == this._panelScriptTypeReference) {
                    expression.setScriptAddressing(NamedBeanAddressing.Reference);
                    expression.setScriptReference(this._scriptReferenceTextField.getText());
                    break block15;
                }
                if (this._tabbedPaneScriptType.getSelectedComponent() == this._panelScriptTypeLocalVariable) {
                    expression.setScriptAddressing(NamedBeanAddressing.LocalVariable);
                    expression.setScriptLocalVariable(this._scriptLocalVariableTextField.getText());
                    break block15;
                }
                if (this._tabbedPaneScriptType.getSelectedComponent() == this._panelScriptTypeFormula) {
                    expression.setScriptAddressing(NamedBeanAddressing.Formula);
                    expression.setScriptFormula(this._scriptFormulaTextField.getText());
                    break block15;
                }
                throw new IllegalArgumentException("_tabbedPaneAspectType has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
        expression.setRegisterListenerScript(this._registerListener.getText());
        expression.setUnregisterListenerScript(this._unregisterListener.getText());
        this._scriptEngineSelectorSwing.update();
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ExpressionScript_Short");
    }

    @Override
    public void dispose() {
    }
}

