/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.swing;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.expressions.LogData;
import jmri.jmrit.logixng.expressions.swing.AbstractDigitalExpressionSwing;
import jmri.jmrit.logixng.expressions.swing.Bundle;
import jmri.jmrit.logixng.expressions.swing.LogDataTableModel;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;

public class LogDataSwing
extends AbstractDigitalExpressionSwing {
    private JComboBox<ResultType> _resultType;
    private JCheckBox _logToLogCheckBox;
    private JCheckBox _logToScriptOutputCheckBox;
    private JComboBox<LogData.FormatType> _formatType;
    private JTextField _format;
    private JTable _logDataTable;
    private LogDataTableModel _logDataTableModel;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        if (object != null && !(object instanceof LogData)) {
            throw new IllegalArgumentException("object is not a LogData: " + object.getClass().getName());
        }
        LogData logData = (LogData)object;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JPanel resultTypePanel = new JPanel();
        this._resultType = new JComboBox();
        for (ResultType formatType : ResultType.values()) {
            this._resultType.addItem(formatType);
        }
        resultTypePanel.add(new JLabel(Bundle.getMessage("LogData_ResultType")));
        resultTypePanel.add(this._resultType);
        this.panel.add(resultTypePanel);
        this._logToLogCheckBox = new JCheckBox(Bundle.getMessage("LogData_LogToLog"));
        this._logToLogCheckBox.setSelected(true);
        this.panel.add(this._logToLogCheckBox);
        this._logToScriptOutputCheckBox = new JCheckBox(Bundle.getMessage("LogData_LogToScriptOutput"));
        this.panel.add(this._logToScriptOutputCheckBox);
        JPanel formatTypePanel = new JPanel();
        this._formatType = new JComboBox();
        for (LogData.FormatType formatType : LogData.FormatType.values()) {
            this._formatType.addItem(formatType);
        }
        formatTypePanel.add(new JLabel(Bundle.getMessage("LogData_FormatType")));
        formatTypePanel.add(this._formatType);
        this.panel.add(formatTypePanel);
        JPanel formatPanel = new JPanel();
        this._format = new JTextField(20);
        formatPanel.add(new JLabel(Bundle.getMessage("LogData_Format")));
        formatPanel.add(this._format);
        this.panel.add(formatPanel);
        if (logData != null) {
            this._resultType.setSelectedItem((Object)ResultType.parseResult(logData.getResult()));
            this._logToLogCheckBox.setSelected(logData.getLogToLog());
            this._logToScriptOutputCheckBox.setSelected(logData.getLogToScriptOutput());
            this._formatType.setSelectedItem((Object)logData.getFormatType());
            this._format.setText(logData.getFormat());
        }
        this._logDataTable = new JTable();
        if (logData != null) {
            ArrayList<LogData.Data> dataList = new ArrayList<LogData.Data>(logData.getDataList());
            this._logDataTableModel = new LogDataTableModel(dataList);
        } else {
            this._logDataTableModel = new LogDataTableModel(null);
        }
        this._logDataTable.setModel(this._logDataTableModel);
        this._logDataTable.setDefaultRenderer(LogData.DataType.class, new LogDataTableModel.CellRenderer());
        this._logDataTable.setDefaultEditor(LogData.DataType.class, new LogDataTableModel.DataTypeCellEditor());
        this._logDataTableModel.setColumnsForComboBoxes(this._logDataTable);
        this._logDataTable.setDefaultRenderer(JButton.class, new ButtonRenderer());
        this._logDataTable.setDefaultEditor(JButton.class, new ButtonEditor(new JButton()));
        JButton testButton = new JButton("XXXXXX");
        this._logDataTable.setRowHeight(testButton.getPreferredSize().height);
        TableColumn deleteColumn = this._logDataTable.getColumnModel().getColumn(3);
        deleteColumn.setMinWidth(testButton.getPreferredSize().width);
        deleteColumn.setMaxWidth(testButton.getPreferredSize().width);
        deleteColumn.setResizable(false);
        TableColumn dummyColumn = this._logDataTable.getColumnModel().getColumn(3);
        dummyColumn.setMinWidth(0);
        dummyColumn.setPreferredWidth(0);
        dummyColumn.setMaxWidth(0);
        JScrollPane scrollpane = new JScrollPane(this._logDataTable);
        scrollpane.setPreferredSize(new Dimension(400, 200));
        this.panel.add(scrollpane);
        JButton add = new JButton(Bundle.getMessage("LogData_TableAdd"));
        buttonPanel.add(add);
        add.addActionListener(e -> this._logDataTableModel.add());
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        for (LogData.Data data : this._logDataTableModel.getDataList()) {
            if (data.getDataType() != LogData.DataType.Formula) continue;
            try {
                HashMap<String, Variable> variables = new HashMap<String, Variable>();
                RecursiveDescentParser parser = new RecursiveDescentParser(variables);
                parser.parseExpression(data.getData());
            }
            catch (ParserException e) {
                errorMessages.add(e.getLocalizedMessage());
            }
        }
        return errorMessages.isEmpty();
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        LogData expression = new LogData(systemName, userName);
        this.updateObject(expression);
        return InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(expression);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof LogData)) {
            throw new IllegalArgumentException("object is not a LogData: " + object.getClass().getName());
        }
        LogData logData = (LogData)object;
        logData.setResult(this._resultType.getItemAt(this._resultType.getSelectedIndex()).getResult());
        logData.setLogToLog(this._logToLogCheckBox.isSelected());
        logData.setLogToScriptOutput(this._logToScriptOutputCheckBox.isSelected());
        logData.setFormatType(this._formatType.getItemAt(this._formatType.getSelectedIndex()));
        logData.setFormat(this._format.getText());
        this._logDataTable.editCellAt(0, 2);
        logData.getDataList().clear();
        for (LogData.Data data : this._logDataTableModel.getDataList()) {
            logData.getDataList().add(data);
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("LogData_Short");
    }

    @Override
    public void dispose() {
    }

    public static enum ResultType {
        True(Bundle.getMessage("LogData_ReturnType_True"), true),
        False(Bundle.getMessage("LogData_ReturnType_False"), false);

        private final String _text;
        private boolean _result;

        private ResultType(String text, boolean result) {
            this._text = text;
            this._result = result;
        }

        public String toString() {
            return this._text;
        }

        public boolean getResult() {
            return this._result;
        }

        public static ResultType parseResult(boolean result) {
            return result ? True : False;
        }
    }
}

