/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.expressions.swing;

import java.util.HashMap;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.StringExpressionManager;
import jmri.jmrit.logixng.expressions.StringFormula;
import jmri.jmrit.logixng.expressions.swing.AbstractStringExpressionSwing;
import jmri.jmrit.logixng.expressions.swing.Bundle;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringFormulaSwing
extends AbstractStringExpressionSwing {
    private JTextField _formula;
    private static final Logger log = LoggerFactory.getLogger(StringFormulaSwing.class);

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        StringFormula expression = (StringFormula)object;
        this.panel = new JPanel();
        JLabel label = new JLabel(Bundle.getMessage("StringFormula_Formula"));
        this._formula = new JTextField();
        this._formula.setColumns(40);
        if (expression != null) {
            this._formula.setText(expression.getFormula());
        }
        this.panel.add(label);
        this.panel.add(this._formula);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        if (this._formula.getText().isEmpty()) {
            return true;
        }
        try {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            parser.parseExpression(this._formula.getText());
        }
        catch (ParserException ex) {
            errorMessages.add(Bundle.getMessage("StringFormula_InvalidFormula", this._formula.getText()));
            log.error("Invalid formula '{}'. Error: ", (Object)this._formula.getText(), (Object)ex);
            return false;
        }
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        StringFormula expression = new StringFormula(systemName, userName);
        this.updateObject(expression);
        return InstanceManager.getDefault(StringExpressionManager.class).registerExpression(expression);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof StringFormula)) {
            throw new IllegalArgumentException("object must be an StringFormula but is a: " + object.getClass().getName());
        }
        StringFormula expression = (StringFormula)object;
        try {
            expression.setFormula(this._formula.getText());
        }
        catch (ParserException ex) {
            log.error("Error when parsing formula", (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("StringFormula_Short");
    }

    @Override
    public void dispose() {
    }
}

