/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFemaleSocket
implements FemaleSocket {
    private Base _parent;
    protected final FemaleSocketListener _listener;
    private MaleSocket _socket = null;
    private String _name = null;
    private boolean _listenersAreRegistered = false;
    boolean _enableListeners = true;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final Logger log = LoggerFactory.getLogger(AbstractFemaleSocket.class);

    public AbstractFemaleSocket(Base parent, FemaleSocketListener listener, String name) {
        if (!this.validateName(name)) {
            throw new IllegalArgumentException("the name is not valid: " + name);
        }
        if (listener == null) {
            throw new IllegalArgumentException("FemaleSocketListener is null");
        }
        this._parent = parent;
        this._listener = listener;
        this._name = name;
    }

    @Override
    public void setEnableListeners(boolean enable) {
        this._enableListeners = enable;
    }

    @Override
    public boolean getEnableListeners() {
        return this._enableListeners;
    }

    @Override
    public Base getParent() {
        return this._parent;
    }

    @Override
    public void setParent(@Nonnull Base parent) {
        this._parent = parent;
    }

    @Override
    public boolean setParentForAllChildren(List<String> errors) {
        if (this.isConnected()) {
            this.getConnectedSocket().setParent(this);
            return this.getConnectedSocket().setParentForAllChildren(errors);
        }
        return true;
    }

    @Override
    public void connect(MaleSocket socket) throws SocketAlreadyConnectedException {
        if (socket == null) {
            throw new NullPointerException("socket cannot be null");
        }
        if (this._listenersAreRegistered) {
            throw new UnsupportedOperationException("A socket must not be connected when listeners are registered");
        }
        if (this.isConnected()) {
            throw new SocketAlreadyConnectedException("Socket is already connected");
        }
        if (!this.isCompatible(socket)) {
            throw new IllegalArgumentException("Socket " + socket.getClass().getName() + " is not compatible with " + this.getClass().getName());
        }
        this._socket = socket;
        this._socket.setParent(this);
        this._listener.connected(this);
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, "SocketConnected", null, this._socket));
    }

    @Override
    public void disconnect() {
        MaleSocket maleSocket = this._socket;
        if (this._socket == null) {
            return;
        }
        if (this._listenersAreRegistered) {
            throw new UnsupportedOperationException("A socket must not be disconnected when listeners are registered");
        }
        this._socket.setParent(null);
        this._socket = null;
        this._listener.disconnected(this);
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, "SocketDisconnected", maleSocket, null));
    }

    @Override
    public MaleSocket getConnectedSocket() {
        return this._socket;
    }

    @Override
    public boolean isConnected() {
        return this._socket != null;
    }

    @Override
    public final boolean validateName(String name, boolean ignoreDuplicateErrors) {
        int i;
        if (name.isEmpty()) {
            return false;
        }
        if (!Character.isLetter(name.charAt(0))) {
            return false;
        }
        for (i = 0; i < name.length(); ++i) {
            if (Character.isLetterOrDigit(name.charAt(i)) || name.charAt(i) == '_') continue;
            return false;
        }
        if (!ignoreDuplicateErrors && this._parent != null) {
            for (i = 0; i < this._parent.getChildCount(); ++i) {
                FemaleSocket child = this._parent.getChild(i);
                if (child == this || !name.equals(child.getName())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setName(String name, boolean ignoreDuplicateErrors) {
        if (!this.validateName(name, ignoreDuplicateErrors)) {
            throw new IllegalArgumentException("the name is not valid: " + name);
        }
        this._name = name;
        this._listener.socketNameChanged(this);
    }

    @Override
    public String getName() {
        return this._name;
    }

    public abstract void disposeMe();

    @Override
    public final void dispose() {
        if (this._listenersAreRegistered) {
            throw new UnsupportedOperationException("This is not currently supported");
        }
        if (this.isConnected()) {
            MaleSocket aSocket = this.getConnectedSocket();
            this.disconnect();
            aSocket.dispose();
        }
        this.disposeMe();
    }

    protected void registerListenersForThisClass() {
    }

    protected void unregisterListenersForThisClass() {
    }

    @Override
    public void registerListeners() {
        if (!this._enableListeners) {
            return;
        }
        this._listenersAreRegistered = true;
        this.registerListenersForThisClass();
        if (this.isConnected()) {
            this.getConnectedSocket().registerListeners();
        }
    }

    @Override
    public void unregisterListeners() {
        if (!this._enableListeners) {
            return;
        }
        this.unregisterListenersForThisClass();
        if (this.isConnected()) {
            this.getConnectedSocket().unregisterListeners();
        }
        this._listenersAreRegistered = false;
    }

    @Override
    public final boolean isActive() {
        return this.isEnabled() && (this._parent == null || this._parent.isActive());
    }

    @Override
    public Category getCategory() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public FemaleSocket getChild(int index) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public String getUserName() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void setUserName(String s) throws NamedBean.BadUserNameException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public String getComment() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void setComment(String s) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public String getSystemName() {
        return this.getParent().getSystemName();
    }

    @Override
    public final ConditionalNG getConditionalNG() {
        if (this._parent == null) {
            return null;
        }
        return this._parent.getConditionalNG();
    }

    @Override
    public final LogixNG getLogixNG() {
        if (this._parent == null) {
            return null;
        }
        return this._parent.getLogixNG();
    }

    @Override
    public final Base getRoot() {
        if (this._parent == null) {
            return null;
        }
        return this._parent.getRoot();
    }

    protected void printTreeRow(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String currentIndent, MutableInt lineNumber) {
        if (settings._printLineNumbers) {
            writer.append(String.format("%8d:  ", lineNumber.addAndGet(1)));
        }
        writer.append(currentIndent);
        writer.append(this.getLongDescription(locale));
        writer.println();
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, PrintWriter writer, String indent, MutableInt lineNumber) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String indent, MutableInt lineNumber) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String indent, String currentIndent, MutableInt lineNumber) {
        this.printTreeRow(settings, locale, writer, currentIndent, lineNumber);
        if (this.isConnected()) {
            this.getConnectedSocket().printTree(settings, locale, writer, indent, currentIndent + indent, lineNumber);
        } else {
            if (settings._printLineNumbers) {
                writer.append(String.format("%8d:  ", lineNumber.addAndGet(1)));
            }
            writer.append(currentIndent);
            writer.append(indent);
            if (settings._printNotConnectedSockets) {
                writer.append("Socket not connected");
            }
            writer.println();
        }
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="Specific log message format")
    public void getUsageTree(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("** {} :: {}", (Object)level, (Object)this.getLongDescription());
        ++level;
        if (this.isConnected()) {
            this.getConnectedSocket().getUsageTree(level, bean, report, cdl);
        }
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener, String name, String listenerRef) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener, String name, String listenerRef) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void updateListenerRef(PropertyChangeListener l, String newName) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String getListenerRef(PropertyChangeListener l) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public ArrayList<String> getListenerRefs() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int getNumPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners().length;
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListenersByReference(String name) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void forEntireTree(Base.RunnableWithBase r) {
        r.run(this);
        if (this.isConnected()) {
            this.getConnectedSocket().forEntireTree(r);
        }
    }

    @Override
    public void forEntireTreeWithException(Base.RunnableWithBaseThrowException r) throws Exception {
        r.run(this);
        if (this.isConnected()) {
            this.getConnectedSocket().forEntireTreeWithException(r);
        }
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Base deepCopyChildren(Base original, Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void getListenerRefsIncludingChildren(List<String> list) {
        if (this.isConnected()) {
            this.getConnectedSocket().getListenerRefsIncludingChildren(list);
        }
    }

    @Override
    public boolean hasChild(@Nonnull Base b) {
        return this.isConnected() && this.getConnectedSocket() == b;
    }
}

