/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.AbortConditionalNGExecutionException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.swing.ErrorHandlingDialog;
import jmri.jmrit.logixng.implementation.swing.ErrorHandlingDialog_MultiLine;
import jmri.util.LoggingUtil;
import jmri.util.ThreadingUtil;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMaleSocket
implements MaleSocket {
    private final Base _object;
    private boolean _locked = false;
    private boolean _system = false;
    protected final List<SymbolTable.VariableData> _localVariables = new ArrayList<SymbolTable.VariableData>();
    private final BaseManager<? extends NamedBean> _manager;
    private Base _parent;
    private MaleSocket.ErrorHandlingType _errorHandlingType = MaleSocket.ErrorHandlingType.Default;
    private boolean _catchAbortExecution;
    private boolean _listen = true;
    private static final Logger log = LoggerFactory.getLogger(AbstractMaleSocket.class);

    public AbstractMaleSocket(BaseManager<? extends NamedBean> manager, Base object) {
        this._manager = manager;
        this._object = object;
    }

    @Override
    public final Base getObject() {
        return this._object;
    }

    @Override
    public final Base getRoot() {
        return this._object.getRoot();
    }

    @Override
    public boolean isLocked() {
        if (this._object instanceof MaleSocket) {
            return ((MaleSocket)this._object).isLocked();
        }
        return this._locked;
    }

    @Override
    public void setLocked(boolean locked) {
        if (this._object instanceof MaleSocket) {
            ((MaleSocket)this._object).setLocked(locked);
        }
        this._locked = locked;
    }

    @Override
    public boolean isSystem() {
        if (this._object instanceof MaleSocket) {
            return ((MaleSocket)this._object).isSystem();
        }
        return this._system;
    }

    @Override
    public void setSystem(boolean system) {
        if (this._object instanceof MaleSocket) {
            ((MaleSocket)this._object).setSystem(system);
        }
        this._system = system;
    }

    @Override
    public final Category getCategory() {
        return this._object.getCategory();
    }

    @Override
    public final FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        return this._object.getChild(index);
    }

    @Override
    public final int getChildCount() {
        return this._object.getChildCount();
    }

    @Override
    public final String getShortDescription(Locale locale) {
        return this._object.getShortDescription(locale);
    }

    @Override
    public final String getLongDescription(Locale locale) {
        Object s = this._object.getLongDescription(locale);
        if (!this._listen) {
            s = (String)s + " ::: " + Base.getNoListenString();
        }
        return s;
    }

    @Override
    public final String getUserName() {
        return this._object.getUserName();
    }

    @Override
    public final void setUserName(String s) throws NamedBean.BadUserNameException {
        this._object.setUserName(s);
    }

    @Override
    public final String getSystemName() {
        return this._object.getSystemName();
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener l, String name, String listenerRef) {
        this._object.addPropertyChangeListener(l, name, listenerRef);
    }

    @Override
    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener l, String name, String listenerRef) {
        this._object.addPropertyChangeListener(propertyName, l, name, listenerRef);
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this._object.addPropertyChangeListener(l);
    }

    @Override
    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this._object.addPropertyChangeListener(propertyName, l);
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this._object.removePropertyChangeListener(l);
    }

    @Override
    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this._object.removePropertyChangeListener(propertyName, l);
    }

    @Override
    public final void updateListenerRef(PropertyChangeListener l, String newName) {
        this._object.updateListenerRef(l, newName);
    }

    @Override
    public final void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        this._object.vetoableChange(evt);
    }

    @Override
    public final String getListenerRef(PropertyChangeListener l) {
        return this._object.getListenerRef(l);
    }

    @Override
    public final ArrayList<String> getListenerRefs() {
        return this._object.getListenerRefs();
    }

    @Override
    public final int getNumPropertyChangeListeners() {
        return this._object.getNumPropertyChangeListeners();
    }

    @Override
    public final synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        return this._object.getPropertyChangeListeners();
    }

    @Override
    public final synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this._object.getPropertyChangeListeners(propertyName);
    }

    @Override
    public final PropertyChangeListener[] getPropertyChangeListenersByReference(String name) {
        return this._object.getPropertyChangeListenersByReference(name);
    }

    @Override
    public String getComment() {
        return this._object.getComment();
    }

    @Override
    public void setComment(String comment) {
        this._object.setComment(comment);
    }

    @Override
    public boolean getListen() {
        if (this.getObject() instanceof MaleSocket) {
            return ((MaleSocket)this.getObject()).getListen();
        }
        return this._listen;
    }

    @Override
    public void setListen(boolean listen) {
        if (this.getObject() instanceof MaleSocket) {
            ((MaleSocket)this.getObject()).setListen(listen);
        }
        this._listen = listen;
    }

    @Override
    public boolean getCatchAbortExecution() {
        return this._catchAbortExecution;
    }

    @Override
    public void setCatchAbortExecution(boolean catchAbortExecution) {
        this._catchAbortExecution = catchAbortExecution;
    }

    @Override
    public void addLocalVariable(String name, SymbolTable.InitialValueType initialValueType, String initialValueData) {
        if (this.getObject() instanceof MaleSocket) {
            ((MaleSocket)this.getObject()).addLocalVariable(name, initialValueType, initialValueData);
        } else {
            this._localVariables.add(new SymbolTable.VariableData(name, initialValueType, initialValueData));
        }
    }

    @Override
    public void addLocalVariable(SymbolTable.VariableData variableData) {
        if (this.getObject() instanceof MaleSocket) {
            ((MaleSocket)this.getObject()).addLocalVariable(variableData);
        } else {
            this._localVariables.add(variableData);
        }
    }

    @Override
    public void clearLocalVariables() {
        if (this.getObject() instanceof MaleSocket) {
            ((MaleSocket)this.getObject()).clearLocalVariables();
        } else {
            this._localVariables.clear();
        }
    }

    @Override
    public List<SymbolTable.VariableData> getLocalVariables() {
        if (this.getObject() instanceof MaleSocket) {
            return ((MaleSocket)this.getObject()).getLocalVariables();
        }
        return this._localVariables;
    }

    @Override
    public Base getParent() {
        return this._parent;
    }

    @Override
    public void setParent(Base parent) {
        this._parent = parent;
    }

    @Override
    public final ConditionalNG getConditionalNG() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getConditionalNG();
    }

    @Override
    public final LogixNG getLogixNG() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getLogixNG();
    }

    @Override
    public final boolean setParentForAllChildren(List<String> errors) {
        boolean result = true;
        for (int i = 0; i < this.getChildCount(); ++i) {
            FemaleSocket femaleSocket = this.getChild(i);
            if (!femaleSocket.isConnected()) continue;
            MaleSocket connectedSocket = femaleSocket.getConnectedSocket();
            connectedSocket.setParent(femaleSocket);
            result = result && connectedSocket.setParentForAllChildren(errors);
        }
        return result;
    }

    protected abstract void registerListenersForThisClass();

    protected abstract void unregisterListenersForThisClass();

    @Override
    public final void registerListeners() {
        if (this.getObject() instanceof MaleSocket) {
            this.getObject().registerListeners();
        } else if (this._listen) {
            this.registerListenersForThisClass();
            for (int i = 0; i < this.getChildCount(); ++i) {
                this.getChild(i).registerListeners();
            }
        }
    }

    @Override
    public final void unregisterListeners() {
        if (this.getObject() instanceof MaleSocket) {
            this.getObject().unregisterListeners();
        } else {
            this.unregisterListenersForThisClass();
            for (int i = 0; i < this.getChildCount(); ++i) {
                this.getChild(i).unregisterListeners();
            }
        }
    }

    @Override
    public final boolean isActive() {
        return this.isEnabled() && (this.getParent() == null || this.getParent().isActive());
    }

    protected void printTreeRow(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String currentIndent, MutableInt lineNumber) {
        if (!(this.getObject() instanceof AbstractMaleSocket)) {
            String comment = this.getComment();
            if (comment != null) {
                comment = comment.replaceAll("\\r\\n", "\\n");
                comment = comment.replaceAll("\\r", "\\n");
                for (String s : comment.split("\\n", 0)) {
                    if (settings._printLineNumbers) {
                        writer.append(String.format("%8d:  ", lineNumber.addAndGet(1)));
                    }
                    writer.append(currentIndent);
                    writer.append("// ");
                    writer.append(s);
                    writer.println();
                }
            }
            if (settings._printLineNumbers) {
                writer.append(String.format("%8d:  ", lineNumber.addAndGet(1)));
            }
            writer.append(currentIndent);
            writer.append(this.getLongDescription(locale));
            if (settings._printSystemNames) {
                writer.append(" ::: ");
                writer.append(this.getSystemName());
            }
            if (settings._printDisplayName) {
                writer.append(" ::: ");
                writer.append(Bundle.getMessage("LabelDisplayName"));
                writer.append(" ");
                writer.append(((NamedBean)((Object)this)).getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME));
            } else if (!settings._hideUserName && this.getUserName() != null) {
                writer.append(" ::: ");
                writer.append(Bundle.getMessage("LabelUserName"));
                writer.append(" ");
                writer.append(this.getUserName());
            }
            if (settings._printErrorHandling) {
                writer.append(" ::: ");
                writer.append(this.getErrorHandlingType().toString());
            }
            if (!this.isEnabled()) {
                writer.append(" ::: ");
                writer.append(Bundle.getMessage("AbstractMaleSocket_Disabled"));
            }
            if (this.isLocked()) {
                writer.append(" ::: ");
                writer.append(Bundle.getMessage("AbstractMaleSocket_Locked"));
            }
            if (this.isSystem()) {
                writer.append(" ::: ");
                writer.append(Bundle.getMessage("AbstractMaleSocket_System"));
            }
            writer.println();
        }
    }

    protected void printLocalVariable(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String currentIndent, MutableInt lineNumber, SymbolTable.VariableData localVariable) {
        if (settings._printLineNumbers) {
            writer.append(String.format("%8d:  ", lineNumber.addAndGet(1)));
        }
        writer.append(currentIndent);
        writer.append("   ::: ");
        writer.append(Bundle.getMessage(locale, "PrintLocalVariable", localVariable._name, localVariable._initialValueType.toString(), localVariable._initialValueData));
        writer.println();
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, PrintWriter writer, String indent, MutableInt lineNumber) {
        this.printTree(settings, Locale.getDefault(), writer, indent, "", lineNumber);
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String indent, MutableInt lineNumber) {
        this.printTree(settings, locale, writer, indent, "", lineNumber);
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String indent, String currentIndent, MutableInt lineNumber) {
        this.printTreeRow(settings, locale, writer, currentIndent, lineNumber);
        if (settings._printLocalVariables) {
            for (SymbolTable.VariableData localVariable : this._localVariables) {
                this.printLocalVariable(settings, locale, writer, currentIndent, lineNumber, localVariable);
            }
        }
        if (this.getObject() instanceof MaleSocket) {
            this.getObject().printTree(settings, locale, writer, indent, currentIndent, lineNumber);
        } else {
            for (int i = 0; i < this.getChildCount(); ++i) {
                this.getChild(i).printTree(settings, locale, writer, indent, currentIndent + indent, lineNumber);
            }
        }
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="Specific log message format")
    public void getUsageTree(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        if (!(this.getObject() instanceof AbstractMaleSocket)) {
            log.debug("*@ {} :: {}", (Object)level, (Object)this.getLongDescription());
            this._object.getUsageDetail(level, bean, report, cdl);
        }
        if (this.getObject() instanceof MaleSocket) {
            this.getObject().getUsageTree(level, bean, report, cdl);
        } else {
            ++level;
            for (int i = 0; i < this.getChildCount(); ++i) {
                this.getChild(i).getUsageTree(level, bean, report, cdl);
            }
        }
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
    }

    @Override
    public BaseManager<? extends NamedBean> getManager() {
        return this._manager;
    }

    @Override
    public final Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        MaleSocket maleSocket = (MaleSocket)this.getObject().getDeepCopy(systemNames, userNames);
        maleSocket.setComment(this.getComment());
        if (maleSocket.getDebugConfig() != null) {
            maleSocket.setDebugConfig(maleSocket.getDebugConfig().getCopy());
        }
        maleSocket.setEnabledFlag(this.isEnabled());
        maleSocket.setListen(this.getListen());
        maleSocket.setErrorHandlingType(this.getErrorHandlingType());
        maleSocket.setLocked(this.isLocked());
        maleSocket.setSystem(false);
        maleSocket.setCatchAbortExecution(this.getCatchAbortExecution());
        for (SymbolTable.VariableData data : this._localVariables) {
            maleSocket.addLocalVariable(data._name, data._initialValueType, data._initialValueData);
        }
        return maleSocket;
    }

    @Override
    public final Base deepCopyChildren(Base original, Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        this.getObject().deepCopyChildren(original, systemNames, userNames);
        return this;
    }

    protected abstract void disposeMe();

    @Override
    public final void dispose() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChild(i).dispose();
        }
        this.disposeMe();
    }

    @Override
    public MaleSocket.ErrorHandlingType getErrorHandlingType() {
        if (this.getObject() instanceof MaleSocket) {
            return ((MaleSocket)this.getObject()).getErrorHandlingType();
        }
        return this._errorHandlingType;
    }

    @Override
    public void setErrorHandlingType(MaleSocket.ErrorHandlingType errorHandlingType) {
        if (this.getObject() instanceof MaleSocket) {
            ((MaleSocket)this.getObject()).setErrorHandlingType(errorHandlingType);
        } else {
            this._errorHandlingType = errorHandlingType;
        }
    }

    @Override
    public void handleError(Base item, String message, JmriException e, Logger log) throws JmriException {
        if (!this._catchAbortExecution && e instanceof AbortConditionalNGExecutionException) {
            throw e;
        }
        MaleSocket.ErrorHandlingType errorHandlingType = this.getErrorHandlingType();
        if (errorHandlingType == MaleSocket.ErrorHandlingType.Default) {
            errorHandlingType = InstanceManager.getDefault(LogixNGPreferences.class).getErrorHandlingType();
        }
        switch (errorHandlingType) {
            case ShowDialogBox: {
                boolean abort = ThreadingUtil.runOnGUIwithReturn(() -> {
                    ErrorHandlingDialog dialog = new ErrorHandlingDialog();
                    return dialog.showDialog(item, message);
                });
                if (!abort) break;
                throw new AbortConditionalNGExecutionException(this, e);
            }
            case LogError: {
                log.error("item {}, {} thrown an exception: {}", new Object[]{item.toString(), this.getObject().toString(), e, e});
                break;
            }
            case LogErrorOnce: {
                LoggingUtil.warnOnce(log, "item {}, {} thrown an exception: {}", item.toString(), this.getObject().toString(), e, e);
                break;
            }
            case ThrowException: {
                throw e;
            }
            case AbortExecution: {
                log.error("item {}, {} thrown an exception: {}", new Object[]{item.toString(), this.getObject().toString(), e, e});
                throw new AbortConditionalNGExecutionException(this, e);
            }
            default: {
                throw e;
            }
        }
    }

    @Override
    public void handleError(Base item, String message, List<String> messageList, JmriException e, Logger log) throws JmriException {
        MaleSocket.ErrorHandlingType errorHandlingType = this.getErrorHandlingType();
        if (errorHandlingType == MaleSocket.ErrorHandlingType.Default) {
            errorHandlingType = InstanceManager.getDefault(LogixNGPreferences.class).getErrorHandlingType();
        }
        switch (errorHandlingType) {
            case ShowDialogBox: {
                boolean abort = ThreadingUtil.runOnGUIwithReturn(() -> {
                    ErrorHandlingDialog_MultiLine dialog = new ErrorHandlingDialog_MultiLine();
                    return dialog.showDialog(item, message, messageList);
                });
                if (!abort) break;
                throw new AbortConditionalNGExecutionException(this, e);
            }
            case LogError: {
                log.error("item {}, {} thrown an exception: {}", new Object[]{item.toString(), this.getObject().toString(), e, e});
                break;
            }
            case LogErrorOnce: {
                LoggingUtil.warnOnce(log, "item {}, {} thrown an exception: {}", item.toString(), this.getObject().toString(), e, e);
                break;
            }
            case ThrowException: {
                throw e;
            }
            case AbortExecution: {
                log.error("item {}, {} thrown an exception: {}", new Object[]{item.toString(), this.getObject().toString(), e, e});
                throw new AbortConditionalNGExecutionException(this, e);
            }
            default: {
                throw e;
            }
        }
    }

    @Override
    public void handleError(Base item, String message, RuntimeException e, Logger log) throws JmriException {
        MaleSocket.ErrorHandlingType errorHandlingType = this.getErrorHandlingType();
        if (errorHandlingType == MaleSocket.ErrorHandlingType.Default) {
            errorHandlingType = InstanceManager.getDefault(LogixNGPreferences.class).getErrorHandlingType();
        }
        switch (errorHandlingType) {
            case ShowDialogBox: {
                boolean abort = ThreadingUtil.runOnGUIwithReturn(() -> {
                    ErrorHandlingDialog dialog = new ErrorHandlingDialog();
                    return dialog.showDialog(item, message);
                });
                if (!abort) break;
                throw new AbortConditionalNGExecutionException(this, e);
            }
            case LogError: {
                log.error("item {}, {} thrown an exception: {}", new Object[]{item.toString(), this.getObject().toString(), e, e});
                break;
            }
            case LogErrorOnce: {
                LoggingUtil.warnOnce(log, "item {}, {} thrown an exception: {}", item.toString(), this.getObject().toString(), e, e);
                break;
            }
            case ThrowException: {
                throw e;
            }
            case AbortExecution: {
                throw new AbortConditionalNGExecutionException(this, e);
            }
            default: {
                throw e;
            }
        }
    }

    @Override
    public void getListenerRefsIncludingChildren(List<String> list) {
        list.addAll(this.getListenerRefs());
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChild(i).getListenerRefsIncludingChildren(list);
        }
    }

    @Override
    public boolean hasChild(@Nonnull Base b) {
        return this.getObject() == b;
    }

    public String toString() {
        return this.getObject().toString();
    }
}

