/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.implementation.AbstractNamedBean;
import jmri.jmrit.logixng.AnonymousTable;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.Table;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultAnonymousTable;
import jmri.jmrit.logixng.implementation.DefaultCsvNamedTable;
import jmri.util.FileUtil;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.io.input.CharSequenceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNamedTable
extends AbstractNamedBean
implements NamedTable {
    private int _state = 1;
    protected final AnonymousTable _internalTable;
    private static final Logger log = LoggerFactory.getLogger(AbstractNamedTable.class);

    public AbstractNamedTable(@Nonnull String sys, @CheckForNull String user, int numRows, int numColumns) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._internalTable = new DefaultAnonymousTable(numRows, numColumns);
    }

    public AbstractNamedTable(@Nonnull String systemName, @CheckForNull String userName, @Nonnull Object[][] data) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(systemName, userName);
        Manager.NameValidity isNameValid = InstanceManager.getDefault(NamedTableManager.class).validSystemNameFormat(this.mSystemName);
        if (isNameValid != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("system name is not valid");
        }
        this._internalTable = new DefaultAnonymousTable(data);
    }

    public AbstractNamedTable(@Nonnull String systemName, @CheckForNull String userName, @Nonnull String fileName, @Nonnull Object[][] data) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(systemName, userName);
        Manager.NameValidity isNameValid = InstanceManager.getDefault(NamedTableManager.class).validSystemNameFormat(this.mSystemName);
        if (isNameValid != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("system name is not valid");
        }
        this._internalTable = new DefaultAnonymousTable(data);
    }

    @Nonnull
    private static NamedTable loadFromCSV(@Nonnull String systemName, @CheckForNull String userName, @CheckForNull String fileName, @Nonnull List<List<String>> lines, boolean registerInManager, Table.CsvType csvType) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        int rowCount;
        NamedTableManager manager = InstanceManager.getDefault(NamedTableManager.class);
        if (userName != null && userName.isEmpty()) {
            userName = null;
        }
        int numRows = lines.size() - 1;
        if (lines.get(lines.size() - 1).isEmpty()) {
            --numRows;
        }
        int numColumns = 0;
        Object[][] csvCells = new String[numRows + 1][];
        for (rowCount = 0; rowCount < numRows + 1; ++rowCount) {
            csvCells[rowCount] = lines.get(rowCount).toArray(new String[0]);
            numColumns = Math.max(numColumns, csvCells[rowCount].length);
        }
        log.debug("about to verify csvCells -- size is {}", (Object)numRows);
        for (rowCount = 0; rowCount < numRows + 1; ++rowCount) {
            String[] cells = csvCells[rowCount];
            if (cells.length >= numColumns) continue;
            String[] newCells = new String[numColumns];
            System.arraycopy(cells, 0, newCells, 0, cells.length);
            csvCells[rowCount] = newCells;
            for (int i = cells.length; i < numColumns; ++i) {
                newCells[i] = "";
            }
            csvCells[rowCount] = newCells;
        }
        DefaultCsvNamedTable table = new DefaultCsvNamedTable(systemName, userName, fileName, csvCells, csvType);
        if (registerInManager) {
            manager.register(table);
        }
        return table;
    }

    private static List<List<String>> parseCSV(Reader rdr, CSVFormat format) throws IOException {
        ArrayList<List<String>> returnList = new ArrayList<List<String>>();
        CSVParser records = format.parse(rdr);
        records.forEach(record -> {
            ArrayList currentList = new ArrayList();
            Iterator itemList = record.iterator();
            itemList.forEachRemaining(item -> currentList.add(item));
            returnList.add(currentList);
        });
        return returnList;
    }

    @Nonnull
    public static NamedTable loadTableFromCSV_Text(@Nonnull String systemName, @CheckForNull String userName, @Nonnull String text, boolean registerInManager, Table.CsvType csvType) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException, IOException {
        CharSequenceReader rdr = new CharSequenceReader((CharSequence)text);
        List<List<String>> lines = AbstractNamedTable.parseCSV((Reader)rdr, CSVFormat.TDF);
        return AbstractNamedTable.loadFromCSV(systemName, userName, null, lines, registerInManager, csvType);
    }

    @Nonnull
    public static NamedTable loadTableFromCSV_File(@Nonnull String systemName, @CheckForNull String userName, @Nonnull String fileName, boolean registerInManager, Table.CsvType csvType) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException, IOException {
        List<List<String>> lines = AbstractNamedTable.readIt(FileUtil.getFile(fileName), csvType);
        return AbstractNamedTable.loadFromCSV(systemName, userName, fileName, lines, registerInManager, csvType);
    }

    @Nonnull
    public static NamedTable loadTableFromCSV_File(@Nonnull String systemName, @CheckForNull String userName, @Nonnull File file, boolean registerInManager, Table.CsvType csvType) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException, IOException {
        List<List<String>> lines = AbstractNamedTable.readIt(file, csvType);
        return AbstractNamedTable.loadFromCSV(systemName, userName, file.getPath(), lines, registerInManager, csvType);
    }

    private static List<List<String>> readIt(File infile, Table.CsvType csvType) throws IOException {
        List<List<String>> returnList = null;
        FileInputStream in = null;
        in = FileUtils.openInputStream((File)infile);
        BOMInputStream bomInputStream = new BOMInputStream((InputStream)in);
        if (bomInputStream.hasBOM()) {
            log.debug("Input file has a Byte Order Marker attached");
        }
        InputStreamReader rdr = new InputStreamReader((InputStream)bomInputStream);
        BufferedReader buffered = new BufferedReader(rdr);
        CSVFormat format = null;
        if (csvType == Table.CsvType.TABBED) {
            format = CSVFormat.TDF;
        } else if (csvType == Table.CsvType.COMMA) {
            format = CSVFormat.RFC4180;
        } else if (csvType == Table.CsvType.SEMICOLON) {
            format = CSVFormat.Builder.create((CSVFormat)CSVFormat.RFC4180).setDelimiter(';').build();
        } else {
            buffered.close();
            throw new IOException("Unrecognized CSV Format");
        }
        returnList = AbstractNamedTable.parseCSV(buffered, format);
        rdr.close();
        return returnList;
    }

    @Override
    public void storeTableAsCSV(@Nonnull File file) throws FileNotFoundException {
        this._internalTable.storeTableAsCSV(file, this.getSystemName(), this.getUserName());
    }

    @Override
    public void storeTableAsCSV(@Nonnull File file, @CheckForNull String systemName, @CheckForNull String userName) throws FileNotFoundException {
        this._internalTable.storeTableAsCSV(file, systemName, userName);
    }

    @Override
    public void setState(int s) throws JmriException {
        this._state = s;
    }

    @Override
    public int getState() {
        return this._state;
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameTable");
    }

    @Override
    public Object getCell(int row, int column) {
        return this._internalTable.getCell(row, column);
    }

    @Override
    public void setCell(Object value, int row, int column) {
        this._internalTable.setCell(value, row, column);
    }

    @Override
    public int numRows() {
        return this._internalTable.numRows();
    }

    @Override
    public int numColumns() {
        return this._internalTable.numColumns();
    }

    @Override
    public int getRowNumber(String rowName) {
        return this._internalTable.getRowNumber(rowName);
    }

    @Override
    public int getColumnNumber(String columnName) {
        return this._internalTable.getColumnNumber(columnName);
    }
}

