/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.InvokeOnGuiThread;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrit.logixng.AnalogActionBean;
import jmri.jmrit.logixng.AnalogActionFactory;
import jmri.jmrit.logixng.AnalogActionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleAnalogActionSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.MaleAnalogActionSocket;
import jmri.jmrit.logixng.MaleAnalogActionSocketFactory;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.implementation.AbstractBaseManager;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultFemaleAnalogActionSocket;
import jmri.jmrit.logixng.implementation.DefaultMaleAnalogActionSocket;
import jmri.util.LoggingUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAnalogActionManager
extends AbstractBaseManager<MaleAnalogActionSocket>
implements AnalogActionManager {
    private final Map<Category, List<Class<? extends Base>>> actionClassList = new HashMap<Category, List<Class<? extends Base>>>();
    private MaleSocket _lastRegisteredBean;
    static volatile DefaultAnalogActionManager _instance = null;
    private static final Logger log = LoggerFactory.getLogger(DefaultAnalogActionManager.class);

    public DefaultAnalogActionManager() {
        InstanceManager.getDefault(LogixNG_Manager.class).registerManager(this);
        for (AnalogActionFactory actionFactory : ServiceLoader.load(AnalogActionFactory.class)) {
            actionFactory.init();
        }
        for (Category category : Category.values()) {
            this.actionClassList.put(category, new ArrayList());
        }
        for (AnalogActionFactory actionFactory : ServiceLoader.load(AnalogActionFactory.class)) {
            actionFactory.getClasses().forEach(entry -> this.actionClassList.get(entry.getKey()).add((Class)entry.getValue()));
        }
        for (MaleAnalogActionSocketFactory maleSocketFactory : ServiceLoader.load(MaleAnalogActionSocketFactory.class)) {
            this._maleSocketFactories.add(maleSocketFactory);
        }
    }

    @Override
    public Class<? extends MaleSocket> getMaleSocketClass() {
        return DefaultMaleAnalogActionSocket.class;
    }

    protected MaleAnalogActionSocket createMaleActionSocket(AnalogActionBean action) {
        DefaultMaleAnalogActionSocket socket = new DefaultMaleAnalogActionSocket((BaseManager<? extends NamedBean>)this, action);
        action.setParent(socket);
        return socket;
    }

    @Override
    public MaleSocket getLastRegisteredMaleSocket() {
        return this._lastRegisteredBean;
    }

    @Override
    public MaleAnalogActionSocket registerBean(MaleAnalogActionSocket maleSocket) {
        MaleAnalogActionSocket bean = super.registerBean(maleSocket);
        this._lastRegisteredBean = maleSocket;
        return bean;
    }

    @Override
    public MaleAnalogActionSocket registerAction(@Nonnull AnalogActionBean action) throws IllegalArgumentException {
        if (action instanceof MaleAnalogActionSocket) {
            throw new IllegalArgumentException("registerAction() cannot register a MaleAnalogActionSocket. Use the method register() instead.");
        }
        if (this.validSystemNameFormat(action.getSystemName()) != Manager.NameValidity.VALID) {
            log.warn("SystemName {} is not in the correct format", (Object)action.getSystemName());
            throw new IllegalArgumentException(String.format("System name is invalid: %s", action.getSystemName()));
        }
        this.updateAutoNumber(action.getSystemName());
        MaleAnalogActionSocket maleSocket = this.createMaleActionSocket(action);
        return this.registerBean(maleSocket);
    }

    @Override
    public int getXMLOrder() {
        return 360;
    }

    @Override
    public String getBeanTypeHandled() {
        return Bundle.getMessage("BeanNameAnalogAction");
    }

    @Override
    public void deleteAnalogAction(MaleAnalogActionSocket x) {
        this.deregister(x);
        x.dispose();
    }

    @Override
    public char typeLetter() {
        return 'Q';
    }

    @Override
    public FemaleAnalogActionSocket createFemaleSocket(Base parent, FemaleSocketListener listener, String socketName) {
        return new DefaultFemaleAnalogActionSocket(parent, listener, socketName);
    }

    @Override
    public Map<Category, List<Class<? extends Base>>> getActionClasses() {
        return this.actionClassList;
    }

    @Override
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameAnalogActions" : "BeanNameAnalogAction");
    }

    @InvokeOnGuiThread
    public static DefaultAnalogActionManager instance() {
        if (!ThreadingUtil.isGUIThread()) {
            LoggingUtil.warnOnce(log, "instance() called on wrong thread", new Object[0]);
        }
        if (_instance == null) {
            _instance = new DefaultAnalogActionManager();
        }
        return _instance;
    }

    @Override
    public Class<MaleAnalogActionSocket> getNamedBeanClass() {
        return MaleAnalogActionSocket.class;
    }

    @Override
    protected MaleAnalogActionSocket castBean(MaleSocket maleSocket) {
        return (MaleAnalogActionSocket)maleSocket;
    }
}

