/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.jmrit.logixng.AnonymousTable;
import jmri.jmrit.logixng.Table;

public class DefaultAnonymousTable
implements AnonymousTable {
    private final int _numRows;
    private final int _numColumns;
    private final Object[][] _data;
    private final Map<String, Integer> rowNames = new HashMap<String, Integer>();
    private final Map<String, Integer> columnNames = new HashMap<String, Integer>();

    public DefaultAnonymousTable(int numRows, int numColumns) {
        this._numRows = numRows;
        this._numColumns = numColumns;
        this._data = new Object[numRows + 1][numColumns + 1];
        this.setupTable();
    }

    public DefaultAnonymousTable(@Nonnull Object[][] data) {
        this._numRows = data.length - 1;
        this._numColumns = data[0].length - 1;
        this._data = data;
        for (int row = 0; row < this._data.length; ++row) {
            if (this._numColumns + 1 == this._data[row].length) continue;
            throw new IllegalArgumentException("All rows in table must have same number of columns");
        }
        this.setupTable();
    }

    private void setupTable() {
        Object cell;
        int i;
        for (i = 0; i <= this._numRows; ++i) {
            cell = this._data[i][0];
            if (cell == null || !(cell instanceof String)) continue;
            this.rowNames.put(cell.toString(), i);
        }
        for (i = 0; i <= this._numColumns; ++i) {
            cell = this._data[0][i];
            if (cell == null || !(cell instanceof String)) continue;
            this.columnNames.put(cell.toString(), i);
        }
    }

    @Override
    public void storeTableAsCSV(@Nonnull File file) throws FileNotFoundException {
        this.storeTableAsCSV(file, null, null);
    }

    @Override
    public void storeTableAsCSV(@Nonnull File file, @CheckForNull String systemName, @CheckForNull String userName) throws FileNotFoundException {
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)));){
            writer.format("%s\t%s%n", systemName, userName);
            for (int row = 0; row <= this._numRows; ++row) {
                for (int column = 0; column <= this._numColumns; ++column) {
                    if (column > 0) {
                        writer.print("\t");
                    }
                    if (this._data[row][column] == null) continue;
                    writer.print(this._data[row][column].toString());
                }
                writer.println();
            }
        }
    }

    @Override
    public Object getCell(int row, int column) {
        return this._data[row][column];
    }

    @Override
    public void setCell(Object value, int row, int column) {
        this._data[row][column] = value;
    }

    @Override
    public int numRows() {
        return this._numRows;
    }

    @Override
    public int numColumns() {
        return this._numColumns;
    }

    @Override
    public int getRowNumber(String rowName) {
        Integer rowNumber = this.rowNames.get(rowName);
        if (rowNumber == null) {
            try {
                int row = Integer.parseInt(rowName);
                if (row >= 0 && row <= this._numRows) {
                    return row;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            return rowNumber;
        }
        throw new Table.RowNotFoundException(rowName);
    }

    @Override
    public int getColumnNumber(String columnName) {
        Integer columnNumber = this.columnNames.get(columnName);
        if (columnNumber == null) {
            try {
                int column = Integer.parseInt(columnName);
                if (column >= 0 && column <= this._numColumns) {
                    return column;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            return columnNumber;
        }
        throw new Table.ColumnNotFoundException(columnName);
    }

    @Override
    public void insertColumn(int col) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void deleteColumn(int col) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void insertRow(int row) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void deleteRow(int row) {
        throw new UnsupportedOperationException("Not supported");
    }
}

