/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.Clipboard;
import jmri.jmrit.logixng.Debugable;
import jmri.jmrit.logixng.FemaleAnySocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.implementation.AbstractMaleSocket;
import jmri.jmrit.logixng.implementation.ClipboardMany;
import jmri.jmrit.logixng.implementation.DefaultFemaleAnySocket;

public class DefaultClipboard
extends AbstractBase
implements Clipboard {
    private ClipboardMany _clipboardItems = new ClipboardMany("", null);
    private final FemaleAnySocket _femaleSocket = new DefaultFemaleAnySocket(this, new FemaleSocketListener(){

        @Override
        public void connected(FemaleSocket socket) {
        }

        @Override
        public void disconnected(FemaleSocket socket) {
        }
    }, "A");

    public DefaultClipboard() {
        super("IQClipboard");
        this._femaleSocket.setEnableListeners(false);
        try {
            this._femaleSocket.connect(new MaleRootSocket(null));
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("Program error", ex);
        }
        if (!this._femaleSocket.setParentForAllChildren(new ArrayList<String>())) {
            throw new RuntimeException("Failed to set parent for all children");
        }
        this._clipboardItems.setParent(this._femaleSocket.getConnectedSocket());
    }

    @Override
    public boolean isEmpty() {
        return this._clipboardItems.getChildCount() == 0;
    }

    @Override
    public boolean add(MaleSocket maleSocket, List<String> errors) {
        this._clipboardItems.ensureFreeSocketAtTop();
        try {
            this._clipboardItems.getChild(0).connect(maleSocket);
            return this._clipboardItems.setParentForAllChildren(errors);
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("Cannot add socket", ex);
        }
    }

    @Override
    public MaleSocket fetchTopItem() {
        if (!this.isEmpty()) {
            MaleSocket maleSocket = this._clipboardItems.getChild(0).getConnectedSocket();
            this._clipboardItems.getChild(0).disconnect();
            return maleSocket;
        }
        return null;
    }

    @Override
    public MaleSocket getTopItem() {
        if (!this.isEmpty()) {
            return this._clipboardItems.getChild(0).getConnectedSocket();
        }
        return null;
    }

    @Override
    public FemaleSocket getFemaleSocket() {
        return this._femaleSocket;
    }

    @Override
    public void moveItemToTop(MaleSocket maleSocket) {
        this._clipboardItems.ensureFreeSocketAtTop();
        if (maleSocket.getParent() != null) {
            if (!(maleSocket.getParent() instanceof FemaleSocket)) {
                throw new UnsupportedOperationException("maleSocket.parent() is not a female socket");
            }
            ((FemaleSocket)maleSocket.getParent()).disconnect();
        }
        try {
            this._clipboardItems.getChild(0).connect(maleSocket);
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new UnsupportedOperationException("Cannot move item to clipboard", ex);
        }
    }

    @Override
    public void setup() {
        this._clipboardItems.setup();
    }

    public boolean replaceClipboardItems(ClipboardMany clipboardItems, List<String> errors) {
        this._clipboardItems = clipboardItems;
        this._femaleSocket.disconnect();
        try {
            this._femaleSocket.connect(new MaleRootSocket(null));
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("Program error", ex);
        }
        boolean result = this._femaleSocket.setParentForAllChildren(errors);
        this._clipboardItems.setParent(this._femaleSocket.getConnectedSocket());
        return result;
    }

    @Override
    protected void registerListenersForThisClass() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    protected void unregisterListenersForThisClass() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    protected void disposeMe() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setState(int s) throws JmriException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int getState() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String getBeanType() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String getShortDescription(Locale locale) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String getLongDescription(Locale locale) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Base getParent() {
        return null;
    }

    @Override
    public void setParent(Base parent) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int getChildCount() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Category getCategory() {
        throw new UnsupportedOperationException("Not supported");
    }

    private class MaleRootSocket
    extends AbstractMaleSocket {
        public MaleRootSocket(BaseManager<? extends NamedBean> manager) {
            super(manager, DefaultClipboard.this._clipboardItems);
        }

        @Override
        protected void registerListenersForThisClass() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        protected void unregisterListenersForThisClass() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        protected void disposeMe() {
            DefaultClipboard.this._clipboardItems.dispose();
        }

        @Override
        public void setEnabled(boolean enable) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void setEnabledFlag(boolean enable) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public boolean isEnabled() {
            return DefaultClipboard.this._clipboardItems.isEnabled();
        }

        @Override
        public void setDebugConfig(Debugable.DebugConfig config) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public Debugable.DebugConfig getDebugConfig() {
            return null;
        }

        @Override
        public Debugable.DebugConfig createDebugConfig() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public String getComment() {
            return DefaultClipboard.this._clipboardItems.getComment();
        }

        @Override
        public void setComment(String s) throws NamedBean.BadUserNameException {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

