/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrit.logixng.AbortConditionalNGExecutionException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.ConditionalNG_Manager;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.ExitException;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.InlineLogixNG;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.ModuleManager;
import jmri.jmrit.logixng.PassThruException;
import jmri.jmrit.logixng.ReturnException;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.Stack;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultFemaleDigitalActionSocket;
import jmri.jmrit.logixng.implementation.DefaultStack;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import jmri.jmrit.logixng.implementation.ExecuteLock;
import jmri.jmrit.logixng.util.LogixNG_Thread;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConditionalNG
extends AbstractBase
implements ConditionalNG,
FemaleSocketListener {
    private final LogixNG_Thread _thread;
    private int _startupThreadId;
    private Base _parent = null;
    private String _socketSystemName = null;
    private final FemaleDigitalActionSocket _femaleSocket;
    private boolean _enabled = true;
    private boolean _executeAtStartup = true;
    private final ExecuteLock _executeLock = new ExecuteLock();
    private boolean _runDelayed = true;
    private final Stack _stack = new DefaultStack();
    private SymbolTable _symbolTable;
    private static final Logger log = LoggerFactory.getLogger(DefaultConditionalNG.class);

    public DefaultConditionalNG(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        this(sys, user, 0);
    }

    public DefaultConditionalNG(String sys, String user, int threadID) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._startupThreadId = threadID;
        this._thread = LogixNG_Thread.getThread(threadID);
        this._thread.setThreadInUse();
        Manager.NameValidity isNameValid = InstanceManager.getDefault(ConditionalNG_Manager.class).validSystemNameFormat(this.mSystemName);
        if (isNameValid != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("system name is not valid");
        }
        this._femaleSocket = new DefaultFemaleDigitalActionSocket(this, this, "A");
    }

    @Override
    public LogixNG_Thread getCurrentThread() {
        return this._thread;
    }

    @Override
    public int getStartupThreadId() {
        return this._startupThreadId;
    }

    @Override
    public void setStartupThreadId(int threadId) {
        int oldStartupThreadId = this._startupThreadId;
        this._startupThreadId = threadId;
        this.firePropertyChange("Thread", oldStartupThreadId, this._startupThreadId);
    }

    @Override
    public Base getParent() {
        return this._parent;
    }

    @Override
    public void setParent(Base parent) {
        this._parent = parent;
        if (this.isActive()) {
            this.registerListeners();
        } else {
            this.unregisterListeners();
        }
    }

    @Override
    public FemaleDigitalActionSocket getFemaleSocket() {
        return this._femaleSocket;
    }

    @Override
    public void setRunDelayed(boolean value) {
        this._runDelayed = value;
    }

    @Override
    public boolean getRunDelayed() {
        return this._runDelayed;
    }

    private void runOnLogixNG_Thread(@Nonnull ThreadingUtil.ThreadAction ta, boolean allowRunDelayed) {
        if (this._runDelayed && allowRunDelayed) {
            this._thread.runOnLogixNGEventually(ta);
        } else {
            this._thread.runOnLogixNG(ta);
        }
    }

    @Override
    public void execute() {
        if ((this._executeAtStartup || !this.getLogixNG().isStartup()) && this._executeLock.once()) {
            this.runOnLogixNG_Thread(new ExecuteTask(this, this._executeLock, null), true);
        }
    }

    @Override
    public void execute(boolean allowRunDelayed) {
        if (this._executeLock.once()) {
            this.runOnLogixNG_Thread(new ExecuteTask(this, this._executeLock, null), allowRunDelayed);
        }
    }

    @Override
    public void execute(FemaleDigitalActionSocket socket) {
        this.runOnLogixNG_Thread(() -> DefaultConditionalNG.internalExecute(this, socket), true);
    }

    public static void executeModule(Module module, Map<String, Object> parameters) throws IllegalArgumentException {
        if (module == null) {
            throw new IllegalArgumentException("The parameter \"module\" is null");
        }
        if (!(module.getRootSocket() instanceof DefaultFemaleDigitalActionSocket)) {
            throw new IllegalArgumentException("The module " + module.getDisplayName() + " is not a DigitalActionModule");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("The parameter \"parameters\" is null");
        }
        LogixNG_Thread thread = LogixNG_Thread.getThread(0);
        DefaultConditionalNG conditionalNG = new DefaultConditionalNG("IQC0000000", null);
        InternalFemaleSocket socket = new InternalFemaleSocket(conditionalNG, module, parameters);
        thread.runOnLogixNGEventually(() -> DefaultConditionalNG.internalExecute(conditionalNG, socket));
    }

    private static void internalExecute(ConditionalNG conditionalNG, FemaleDigitalActionSocket femaleSocket) {
        if (conditionalNG.isEnabled()) {
            DefaultSymbolTable newSymbolTable = new DefaultSymbolTable(conditionalNG);
            try {
                conditionalNG.setCurrentConditionalNG(conditionalNG);
                conditionalNG.setSymbolTable(newSymbolTable);
                LogixNG logixNG = conditionalNG.getLogixNG();
                InlineLogixNG inlineLogixNG = null;
                if (logixNG != null) {
                    inlineLogixNG = logixNG.getInlineLogixNG();
                }
                if (inlineLogixNG != null) {
                    ArrayList<SymbolTable.VariableData> localVariables = new ArrayList<SymbolTable.VariableData>();
                    localVariables.add(new SymbolTable.VariableData("__InlineLogixNG__", SymbolTable.InitialValueType.String, inlineLogixNG.getNameString()));
                    localVariables.add(new SymbolTable.VariableData("__Editor__", SymbolTable.InitialValueType.String, inlineLogixNG.getEditorName()));
                    newSymbolTable.createSymbols(localVariables);
                }
                if (femaleSocket != null) {
                    femaleSocket.execute();
                } else {
                    conditionalNG.getFemaleSocket().execute();
                }
            }
            catch (ExitException | ReturnException logixNG) {
            }
            catch (PassThruException e) {
                log.info("ConditionalNG {} was aborted during execute: {}", new Object[]{conditionalNG.getSystemName(), e.getCause(), e.getCause()});
            }
            catch (AbortConditionalNGExecutionException e) {
                if (InstanceManager.getDefault(LogixNGPreferences.class).getShowSystemNameInException()) {
                    log.warn("ConditionalNG {} was aborted during execute in the item {}: {}", new Object[]{conditionalNG.getSystemName(), e.getMaleSocket().getSystemName(), e.getCause(), e.getCause()});
                } else {
                    log.warn("ConditionalNG {} was aborted during execute: {}", new Object[]{conditionalNG.getSystemName(), e.getCause(), e.getCause()});
                }
            }
            catch (RuntimeException | JmriException e) {
                log.warn("ConditionalNG {} got an exception during execute: {}", new Object[]{conditionalNG.getSystemName(), e, e});
            }
            conditionalNG.setSymbolTable(newSymbolTable.getPrevSymbolTable());
        }
    }

    @Override
    public void setCurrentConditionalNG(ConditionalNG conditionalNG) {
        if (this != conditionalNG) {
            throw new UnsupportedOperationException("The new conditionalNG must be the same as myself");
        }
        for (Module m : InstanceManager.getDefault(ModuleManager.class).getNamedBeanSet()) {
            m.setCurrentConditionalNG(conditionalNG);
        }
    }

    @Override
    public Stack getStack() {
        return this._stack;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this._symbolTable;
    }

    @Override
    public void setSymbolTable(SymbolTable symbolTable) {
        this._symbolTable = symbolTable;
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameConditionalNG");
    }

    @Override
    public void setState(int s) throws JmriException {
        log.warn("Unexpected call to setState in DefaultConditionalNG.");
    }

    @Override
    public int getState() {
        log.warn("Unexpected call to getState in DefaultConditionalNG.");
        return 1;
    }

    @Override
    public void connected(FemaleSocket socket) {
        this._socketSystemName = socket.getConnectedSocket().getSystemName();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        this._socketSystemName = null;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return "ConditionalNG: " + this.getDisplayName();
    }

    @Override
    public String getLongDescription(Locale locale) {
        if (this._thread.getThreadId() != 0) {
            return "ConditionalNG: " + this.getDisplayName() + " on thread " + this._thread.getThreadName();
        }
        return "ConditionalNG: " + this.getDisplayName();
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        if (index != 0) {
            throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
        }
        return this._femaleSocket;
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public Category getCategory() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void setSocketSystemName(String systemName) {
        if (systemName == null || !systemName.equals(this._socketSystemName)) {
            this._femaleSocket.disconnect();
        }
        this._socketSystemName = systemName;
    }

    @Override
    public String getSocketSystemName() {
        return this._socketSystemName;
    }

    @Override
    public final void setup() {
        if (!this._femaleSocket.isConnected() || !this._femaleSocket.getConnectedSocket().getSystemName().equals(this._socketSystemName)) {
            this._femaleSocket.disconnect();
            if (this._socketSystemName != null) {
                try {
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(this._socketSystemName);
                    if (maleSocket != null) {
                        this._femaleSocket.connect(maleSocket);
                        maleSocket.setup();
                    }
                    log.error("digital action is not found: {}", (Object)this._socketSystemName);
                }
                catch (SocketAlreadyConnectedException ex) {
                    throw new RuntimeException("socket is already connected");
                }
            }
        } else {
            this._femaleSocket.setup();
        }
    }

    @Override
    public final void disposeMe() {
        this._femaleSocket.dispose();
    }

    @Override
    public void setEnabled(boolean enable) {
        this._enabled = enable;
        if (this.isActive()) {
            LogixNG logixNG = this.getLogixNG();
            if (logixNG != null && logixNG.isActive()) {
                this.registerListeners();
                if (this._executeAtStartup) {
                    this.execute();
                }
            }
        } else {
            this.unregisterListeners();
        }
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public void setExecuteAtStartup(boolean value) {
        this._executeAtStartup = value;
    }

    @Override
    public boolean isExecuteAtStartup() {
        return this._executeAtStartup;
    }

    @Override
    public synchronized boolean isListenersRegistered() {
        return this._listenersAreRegistered;
    }

    @Override
    public synchronized void registerListenersForThisClass() {
        this._listenersAreRegistered = true;
    }

    @Override
    public synchronized void unregisterListenersForThisClass() {
        this._listenersAreRegistered = false;
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean existsInTree() {
        return true;
    }

    private static class ExecuteTask
    implements ThreadingUtil.ThreadAction {
        private final ConditionalNG _conditionalNG;
        private final ExecuteLock _executeLock;
        private final FemaleDigitalActionSocket _localFemaleSocket;

        public ExecuteTask(ConditionalNG conditionalNG, ExecuteLock executeLock, FemaleDigitalActionSocket femaleSocket) {
            this._conditionalNG = conditionalNG;
            this._executeLock = executeLock;
            this._localFemaleSocket = femaleSocket;
        }

        @Override
        public void run() {
            while (this._executeLock.loop()) {
                DefaultConditionalNG.internalExecute(this._conditionalNG, this._localFemaleSocket);
            }
        }
    }

    private static class InternalFemaleSocket
    extends DefaultFemaleDigitalActionSocket {
        private final ConditionalNG _conditionalNG;
        private final Module _module;
        private final Map<String, Object> _parameters;

        public InternalFemaleSocket(ConditionalNG conditionalNG, Module module, Map<String, Object> parameters) {
            super(null, new FemaleSocketListener(){

                @Override
                public void connected(FemaleSocket socket) {
                }

                @Override
                public void disconnected(FemaleSocket socket) {
                }
            }, "A");
            this._conditionalNG = conditionalNG;
            this._module = module;
            this._parameters = parameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws JmriException {
            FemaleSocket socket = this._module.getRootSocket();
            if (!(socket instanceof DefaultFemaleDigitalActionSocket)) {
                throw new IllegalArgumentException("The module " + this._module.getDisplayName() + " is not a DigitalActionModule");
            }
            InternalFemaleSocket internalFemaleSocket = this;
            synchronized (internalFemaleSocket) {
                SymbolTable oldSymbolTable = this._conditionalNG.getSymbolTable();
                DefaultSymbolTable newSymbolTable = new DefaultSymbolTable(this._conditionalNG);
                ArrayList<Module.ParameterData> _parameterData = new ArrayList<Module.ParameterData>();
                for (Module.Parameter parameter : this._module.getParameters()) {
                    _parameterData.add(new Module.ParameterData(parameter.getName(), SymbolTable.InitialValueType.None, "", Module.ReturnValueType.None, ""));
                }
                newSymbolTable.createSymbols(this._conditionalNG.getSymbolTable(), _parameterData);
                for (Map.Entry entry : this._parameters.entrySet()) {
                    newSymbolTable.setValue((String)entry.getKey(), entry.getValue());
                }
                this._conditionalNG.setSymbolTable(newSymbolTable);
                ((DefaultFemaleDigitalActionSocket)socket).execute();
                this._conditionalNG.setSymbolTable(oldSymbolTable);
            }
        }
    }
}

