/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.InvokeOnGuiThread;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionBean;
import jmri.jmrit.logixng.DigitalActionFactory;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.MaleDigitalActionSocket;
import jmri.jmrit.logixng.MaleDigitalActionSocketFactory;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.implementation.AbstractBaseManager;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultFemaleDigitalActionSocket;
import jmri.jmrit.logixng.implementation.DefaultMaleDigitalActionSocket;
import jmri.util.LoggingUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDigitalActionManager
extends AbstractBaseManager<MaleDigitalActionSocket>
implements DigitalActionManager {
    private final Map<Category, List<Class<? extends Base>>> actionClassList = new HashMap<Category, List<Class<? extends Base>>>();
    private MaleSocket _lastRegisteredBean;
    static volatile DefaultDigitalActionManager _instance = null;
    private static final Logger log = LoggerFactory.getLogger(DefaultDigitalActionManager.class);

    public DefaultDigitalActionManager() {
        InstanceManager.getDefault(LogixNG_Manager.class).registerManager(this);
        for (DigitalActionFactory actionFactory : ServiceLoader.load(DigitalActionFactory.class)) {
            actionFactory.init();
        }
        for (Category category : Category.values()) {
            this.actionClassList.put(category, new ArrayList());
        }
        for (DigitalActionFactory actionFactory : ServiceLoader.load(DigitalActionFactory.class)) {
            actionFactory.getActionClasses().forEach(entry -> this.actionClassList.get(entry.getKey()).add((Class)entry.getValue()));
        }
        for (MaleDigitalActionSocketFactory maleSocketFactory : ServiceLoader.load(MaleDigitalActionSocketFactory.class)) {
            this._maleSocketFactories.add(maleSocketFactory);
        }
    }

    @Override
    public Class<? extends MaleSocket> getMaleSocketClass() {
        return DefaultMaleDigitalActionSocket.class;
    }

    protected MaleDigitalActionSocket createMaleActionSocket(DigitalActionBean action) {
        DefaultMaleDigitalActionSocket socket = new DefaultMaleDigitalActionSocket((BaseManager<? extends NamedBean>)this, action);
        action.setParent(socket);
        return socket;
    }

    @Override
    public MaleSocket getLastRegisteredMaleSocket() {
        return this._lastRegisteredBean;
    }

    @Override
    public MaleDigitalActionSocket registerBean(MaleDigitalActionSocket maleSocket) {
        MaleDigitalActionSocket bean = super.registerBean(maleSocket);
        this._lastRegisteredBean = maleSocket;
        return bean;
    }

    @Override
    public MaleDigitalActionSocket registerAction(@Nonnull DigitalActionBean action) throws IllegalArgumentException {
        if (action instanceof MaleDigitalActionSocket) {
            throw new IllegalArgumentException("registerAction() cannot register a MaleDigitalActionSocket. Use the method register() instead.");
        }
        if (this.validSystemNameFormat(action.getSystemName()) != Manager.NameValidity.VALID) {
            log.warn("SystemName {} is not in the correct format", (Object)action.getSystemName());
            throw new IllegalArgumentException(String.format("System name is invalid: %s", action.getSystemName()));
        }
        this.updateAutoNumber(action.getSystemName());
        MaleDigitalActionSocket maleSocket = this.createMaleActionSocket(action);
        return this.registerBean(maleSocket);
    }

    @Override
    public int getXMLOrder() {
        return 330;
    }

    @Override
    public char typeLetter() {
        return 'Q';
    }

    @Override
    public FemaleDigitalActionSocket createFemaleSocket(Base parent, FemaleSocketListener listener, String socketName) {
        return new DefaultFemaleDigitalActionSocket(parent, listener, socketName);
    }

    @Override
    public Map<Category, List<Class<? extends Base>>> getActionClasses() {
        return this.actionClassList;
    }

    @Override
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameDigitalActions" : "BeanNameDigitalAction");
    }

    @Override
    public void deleteDigitalAction(MaleDigitalActionSocket x) {
        this.deregister(x);
        x.dispose();
    }

    @InvokeOnGuiThread
    public static DefaultDigitalActionManager instance() {
        if (!ThreadingUtil.isGUIThread()) {
            LoggingUtil.warnOnce(log, "instance() called on wrong thread", new Object[0]);
        }
        if (_instance == null) {
            _instance = new DefaultDigitalActionManager();
        }
        return _instance;
    }

    @Override
    public Class<MaleDigitalActionSocket> getNamedBeanClass() {
        return MaleDigitalActionSocket.class;
    }

    @Override
    protected MaleDigitalActionSocket castBean(MaleSocket maleSocket) {
        return (MaleDigitalActionSocket)maleSocket;
    }
}

