/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.CheckForNull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.AnalogExpressionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleAnalogExpressionSocket;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleGenericExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.FemaleStringExpressionSocket;
import jmri.jmrit.logixng.MaleAnalogExpressionSocket;
import jmri.jmrit.logixng.MaleDigitalExpressionSocket;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.MaleStringExpressionSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.StringExpressionManager;
import jmri.jmrit.logixng.implementation.AbstractFemaleSocket;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultFemaleAnalogExpressionSocket;
import jmri.jmrit.logixng.implementation.DefaultFemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.implementation.DefaultFemaleStringExpressionSocket;

public class DefaultFemaleGenericExpressionSocket
extends AbstractFemaleSocket
implements FemaleGenericExpressionSocket,
FemaleSocketListener {
    private FemaleGenericExpressionSocket.SocketType _socketType;
    private FemaleGenericExpressionSocket.SocketType _currentSocketType;
    private FemaleSocket _currentActiveSocket;
    private final FemaleAnalogExpressionSocket _analogSocket = new DefaultFemaleAnalogExpressionSocket(this, this, "A");
    private final FemaleDigitalExpressionSocket _digitalSocket = new DefaultFemaleDigitalExpressionSocket(this, this, "D");
    private final FemaleStringExpressionSocket _stringSocket = new DefaultFemaleStringExpressionSocket(this, this, "S");
    private boolean _do_i18n;

    public DefaultFemaleGenericExpressionSocket(FemaleGenericExpressionSocket.SocketType socketType, Base parent, FemaleSocketListener listener, String name) {
        super(parent, listener, name);
        this._socketType = socketType;
        this._currentSocketType = socketType;
        switch (this._socketType) {
            case ANALOG: {
                this._currentActiveSocket = this._analogSocket;
                break;
            }
            case DIGITAL: {
                this._currentActiveSocket = this._digitalSocket;
                break;
            }
            case STRING: {
                this._currentActiveSocket = this._stringSocket;
                break;
            }
            case GENERIC: {
                this._currentActiveSocket = null;
                break;
            }
            default: {
                throw new RuntimeException("_socketType has invalid value: " + socketType.name());
            }
        }
    }

    @Override
    public FemaleSocket getCurrentActiveSocket() {
        return this._currentActiveSocket;
    }

    @Override
    public boolean isCompatible(MaleSocket socket) {
        return socket instanceof MaleAnalogExpressionSocket || socket instanceof MaleDigitalExpressionSocket || socket instanceof MaleStringExpressionSocket;
    }

    @Override
    public void setSocketType(FemaleGenericExpressionSocket.SocketType socketType) throws SocketAlreadyConnectedException {
        if (socketType == this._socketType) {
            return;
        }
        if (this._currentActiveSocket != null && this._currentActiveSocket.isConnected()) {
            throw new SocketAlreadyConnectedException("Socket is already connected");
        }
        switch (socketType) {
            case DIGITAL: {
                this._socketType = FemaleGenericExpressionSocket.SocketType.DIGITAL;
                this._currentSocketType = FemaleGenericExpressionSocket.SocketType.DIGITAL;
                this._currentActiveSocket = this._digitalSocket;
                break;
            }
            case ANALOG: {
                this._socketType = FemaleGenericExpressionSocket.SocketType.ANALOG;
                this._currentSocketType = FemaleGenericExpressionSocket.SocketType.ANALOG;
                this._currentActiveSocket = this._analogSocket;
                break;
            }
            case STRING: {
                this._socketType = FemaleGenericExpressionSocket.SocketType.STRING;
                this._currentSocketType = FemaleGenericExpressionSocket.SocketType.STRING;
                this._currentActiveSocket = this._stringSocket;
                break;
            }
            case GENERIC: {
                this._socketType = FemaleGenericExpressionSocket.SocketType.GENERIC;
                this._currentSocketType = FemaleGenericExpressionSocket.SocketType.GENERIC;
                this._currentActiveSocket = null;
                break;
            }
            default: {
                throw new RuntimeException("socketType has invalid value: " + socketType.name());
            }
        }
    }

    @Override
    public FemaleGenericExpressionSocket.SocketType getSocketType() {
        return this._socketType;
    }

    public void setDoI18N(boolean do_i18n) {
        this._do_i18n = do_i18n;
    }

    public boolean getDoI18N() {
        return this._do_i18n;
    }

    @Override
    @CheckForNull
    public Object evaluateGeneric() throws JmriException {
        if (this.isConnected()) {
            switch (this._currentSocketType) {
                case DIGITAL: {
                    return ((MaleDigitalExpressionSocket)this.getConnectedSocket()).evaluate();
                }
                case ANALOG: {
                    return ((MaleAnalogExpressionSocket)this.getConnectedSocket()).evaluate();
                }
                case STRING: {
                    return ((MaleStringExpressionSocket)this.getConnectedSocket()).evaluate();
                }
            }
            throw new RuntimeException("_currentSocketType has invalid value: " + this._currentSocketType.name());
        }
        return null;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "DefaultFemaleGenericExpressionSocket_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "DefaultFemaleGenericExpressionSocket_Long", this.getName());
    }

    private void addClassesToMap(Map<Category, List<Class<? extends Base>>> destinationClasses, Map<Category, List<Class<? extends Base>>> sourceClasses) {
        for (Category category : Category.values()) {
            if (sourceClasses.get(category) == null) continue;
            for (Class<? extends Base> clazz : sourceClasses.get(category)) {
                destinationClasses.get(category).add(clazz);
            }
        }
    }

    @Override
    public Map<Category, List<Class<? extends Base>>> getConnectableClasses() {
        HashMap<Category, List<Class<? extends Base>>> classes = new HashMap<Category, List<Class<? extends Base>>>();
        for (Category category : Category.values()) {
            classes.put(category, new ArrayList());
        }
        this.addClassesToMap(classes, InstanceManager.getDefault(AnalogExpressionManager.class).getExpressionClasses());
        this.addClassesToMap(classes, InstanceManager.getDefault(DigitalExpressionManager.class).getExpressionClasses());
        this.addClassesToMap(classes, InstanceManager.getDefault(StringExpressionManager.class).getExpressionClasses());
        return classes;
    }

    @Override
    public void connect(MaleSocket socket) throws SocketAlreadyConnectedException {
        if (socket == null) {
            throw new NullPointerException("socket cannot be null");
        }
        if (this._currentActiveSocket != null) {
            if (this._currentActiveSocket.isConnected()) {
                throw new SocketAlreadyConnectedException("Socket is already connected");
            }
            this._currentActiveSocket.connect(socket);
            this._listener.connected(this);
            return;
        }
        if (this._digitalSocket.isCompatible(socket)) {
            this._currentSocketType = FemaleGenericExpressionSocket.SocketType.DIGITAL;
            this._currentActiveSocket = this._digitalSocket;
        } else if (this._analogSocket.isCompatible(socket)) {
            this._currentSocketType = FemaleGenericExpressionSocket.SocketType.ANALOG;
            this._currentActiveSocket = this._analogSocket;
        } else if (this._stringSocket.isCompatible(socket)) {
            this._currentSocketType = FemaleGenericExpressionSocket.SocketType.STRING;
            this._currentActiveSocket = this._stringSocket;
        } else {
            throw new IllegalArgumentException("Socket is not compatible");
        }
        this._currentActiveSocket.connect(socket);
        this._listener.connected(this);
    }

    @Override
    public void disconnect() {
        if (this._currentActiveSocket != null && this._currentActiveSocket.isConnected()) {
            this._currentActiveSocket.disconnect();
            this._listener.disconnected(this);
        }
    }

    @Override
    public MaleSocket getConnectedSocket() {
        if (this._currentActiveSocket != null) {
            return this._currentActiveSocket.getConnectedSocket();
        }
        return null;
    }

    @Override
    public boolean isConnected() {
        return this._currentActiveSocket != null && this._currentActiveSocket.isConnected();
    }

    @Override
    public void connected(FemaleSocket socket) {
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (this._socketType == FemaleGenericExpressionSocket.SocketType.GENERIC) {
            this._currentActiveSocket = null;
        }
    }

    @Override
    public void disposeMe() {
    }
}

