/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.implementation.AbstractNamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.GlobalVariable;
import jmri.jmrit.logixng.GlobalVariableManager;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGlobalVariable
extends AbstractNamedBean
implements GlobalVariable {
    private Object _value;
    private SymbolTable.InitialValueType _initialValueType = SymbolTable.InitialValueType.None;
    private String _initialValueData;
    private static final Logger log = LoggerFactory.getLogger(DefaultGlobalVariable.class);

    public DefaultGlobalVariable(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        Manager.NameValidity isNameValid = InstanceManager.getDefault(GlobalVariableManager.class).validSystemNameFormat(this.mSystemName);
        if (isNameValid != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("system name is not valid");
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void setUserName(@CheckForNull String s) throws NamedBean.BadUserNameException {
        if (s == null || !SymbolTable.validateName(s)) {
            throw new NamedBean.BadUserNameException(Bundle.getMessage(Locale.ENGLISH, "VariableNameIsNotValid", s), Bundle.getMessage(Locale.getDefault(), "VariableNameIsNotValid", s));
        }
        super.setUserName(s);
    }

    @Override
    public void initialize() throws JmriException {
        CopyOnWriteArrayList value;
        DefaultSymbolTable symbolTable = new DefaultSymbolTable();
        switch (this._initialValueType) {
            case Array: {
                Object newArray = SymbolTable.getInitialValue(SymbolTable.Type.Global, this.getUserName(), this._initialValueType, this._initialValueData, symbolTable, symbolTable.getSymbols());
                value = new CopyOnWriteArrayList((List)newArray);
                break;
            }
            case Map: {
                value = new ConcurrentHashMap();
                break;
            }
            default: {
                value = SymbolTable.getInitialValue(SymbolTable.Type.Global, this.getUserName(), this._initialValueType, this._initialValueData, symbolTable, symbolTable.getSymbols());
            }
        }
        if (value != this._value) {
            this.setValue(value);
        }
    }

    @Override
    public void setValue(Object value) {
        Object old = this._value;
        LogixNGPreferences prefs = InstanceManager.getDefault(LogixNGPreferences.class);
        this._value = prefs.getStrictTypingLocalVariables() ? SymbolTable.validateStrictTyping(this._initialValueType, this._value, value) : value;
        this.firePropertyChange("value", old, this._value);
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    @Override
    public void setInitialValueType(SymbolTable.InitialValueType type) {
        this._initialValueType = type;
    }

    @Override
    public SymbolTable.InitialValueType getInitialValueType() {
        return this._initialValueType;
    }

    @Override
    public void setInitialValueData(String value) {
        this._initialValueData = value;
    }

    @Override
    public String getInitialValueData() {
        return this._initialValueData;
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameGlobalVariable");
    }

    @Override
    public void setState(int s) throws JmriException {
        log.warn("Unexpected call to setState in DefaultGlobalVariable.");
    }

    @Override
    public int getState() {
        log.warn("Unexpected call to getState in DefaultGlobalVariable.");
        return 1;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return "GlobalVariable";
    }

    @Override
    public String getLongDescription(Locale locale) {
        return "GlobalVariable: " + this.getDisplayName();
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Category getCategory() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public Base getParent() {
        return null;
    }

    @Override
    public void setParent(Base parent) {
        throw new UnsupportedOperationException("A GlobalVariable cannot have a parent");
    }

    @Override
    public boolean setParentForAllChildren(List<String> errors) {
        throw new UnsupportedOperationException("A GlobalVariable cannot have a parent");
    }

    @Override
    public LogixNG getLogixNG() {
        return null;
    }

    @Override
    public ConditionalNG getConditionalNG() {
        return null;
    }

    @Override
    public final Base getRoot() {
        return this;
    }

    @Override
    public void registerListeners() {
    }

    @Override
    public void unregisterListeners() {
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, PrintWriter writer, String indent, MutableInt lineNumber) {
        this.printTree(settings, Locale.getDefault(), writer, indent, "", lineNumber);
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String indent, MutableInt lineNumber) {
        this.printTree(settings, locale, writer, indent, "", lineNumber);
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String indent, String currentIndent, MutableInt lineNumber) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Base deepCopyChildren(Base original, Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setup() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="Specific log message format")
    public void getUsageTree(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("** {} :: {}", (Object)level, (Object)this.getClass().getName());
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void getListenerRefsIncludingChildren(List<String> list) {
        list.addAll(this.getListenerRefs());
    }
}

