/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.PrintWriter;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.InstanceManager;
import jmri.InvokeOnGuiThread;
import jmri.Manager;
import jmri.jmrit.logixng.GlobalVariable;
import jmri.jmrit.logixng.GlobalVariableManager;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultGlobalVariable;
import jmri.managers.AbstractManager;
import jmri.util.LoggingUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGlobalVariableManager
extends AbstractManager<GlobalVariable>
implements GlobalVariableManager {
    static volatile DefaultGlobalVariableManager _instance = null;
    private static final Logger log = LoggerFactory.getLogger(DefaultGlobalVariableManager.class);

    public DefaultGlobalVariableManager() {
        InstanceManager.getDefault(LogixNGPreferences.class);
    }

    @Override
    public int getXMLOrder() {
        return 280;
    }

    @Override
    public char typeLetter() {
        return 'Q';
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(String systemName) {
        return LogixNG_Manager.validSystemNameFormat(this.getSubSystemNamePrefix(), systemName);
    }

    @Override
    public GlobalVariable createGlobalVariable(String systemName, String userName) throws IllegalArgumentException {
        GlobalVariable x;
        if (userName != null && !userName.isEmpty() && (x = this.getByUserName(userName)) != null) {
            return null;
        }
        x = this.getBySystemName(systemName);
        if (x != null) {
            return null;
        }
        if (this.validSystemNameFormat(systemName) != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("SystemName " + systemName + " is not in the correct format");
        }
        x = new DefaultGlobalVariable(systemName, userName);
        this.register(x);
        this.updateAutoNumber(systemName);
        return x;
    }

    @Override
    public GlobalVariable createGlobalVariable(String userName) throws IllegalArgumentException {
        return this.createGlobalVariable(this.getAutoSystemName(), userName);
    }

    @Override
    public GlobalVariable getGlobalVariable(String name) {
        GlobalVariable x = this.getByUserName(name);
        if (x != null) {
            return x;
        }
        return this.getBySystemName(name);
    }

    @Override
    public GlobalVariable getByUserName(String name) {
        return (GlobalVariable)this._tuser.get(name);
    }

    @Override
    public GlobalVariable getBySystemName(String name) {
        return (GlobalVariable)this._tsys.get(name);
    }

    @Override
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameGlobalVariables" : "BeanNameGlobalVariable");
    }

    @Override
    public void deleteGlobalVariable(GlobalVariable x) {
        this.deregister(x);
        x.dispose();
    }

    @Override
    public void printTree(Locale locale, PrintWriter writer, String indent) {
        for (GlobalVariable globalVariable : this.getNamedBeanSet()) {
            writer.append(String.format("Global variable: System name: %s, User name: %s, Initial value type: %s, Initial value data: %s", globalVariable.getSystemName(), globalVariable.getUserName(), globalVariable.getInitialValueType().toString(), globalVariable.getInitialValueData()));
            writer.println();
        }
        writer.println();
    }

    @InvokeOnGuiThread
    public static DefaultGlobalVariableManager instance() {
        if (!ThreadingUtil.isGUIThread()) {
            LoggingUtil.warnOnce(log, "instance() called on wrong thread", new Object[0]);
        }
        if (_instance == null) {
            _instance = new DefaultGlobalVariableManager();
        }
        return _instance;
    }

    @Override
    public Class<GlobalVariable> getNamedBeanClass() {
        return GlobalVariable.class;
    }

    @OverridingMethodsMustInvokeSuper
    public void fireVetoableChange(String p, Object old) throws PropertyVetoException {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, p, old, null);
        for (VetoableChangeListener vc : this.vetoableChangeSupport.getVetoableChangeListeners()) {
            vc.vetoableChange(evt);
        }
    }

    @Override
    public final void deleteBean(@Nonnull GlobalVariable globalVariable, @Nonnull String property) throws PropertyVetoException {
        this.fireVetoableChange(property, globalVariable);
        if ("DoDelete".equals(property)) {
            this.deregister(globalVariable);
            globalVariable.dispose();
        }
    }
}

