/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.prefs.Preferences;
import jmri.beans.PreferencesBean;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.IfThenElse;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileUtils;

public final class DefaultLogixNGPreferences
extends PreferencesBean
implements LogixNGPreferences {
    private static final String START_LOGIXNG_ON_LOAD = "startLogixNGOnStartup";
    private static final String INSTALL_DEBUGGER = "installDebugger";
    private static final String SHOW_SYSTEM_USER_NAMES = "showSystemUserNames";
    private static final String ERROR_HANDLING_TYPE = "errorHandlingType";
    private static final String TREE_EDITOR_HIGHLIGHT_ROW = "treeEditorHighlightRow";
    private static final String SHOW_SYSTEM_NAME_IN_EXCEPTION = "showSystemNameInExceptions";
    private static final String STRICT_TYPING_GLOBAL_VARIABLES = "strictTypingGlobalVariables";
    private static final String STRICT_TYPING_LOCAL_VARIABLES = "strictTypingLocalVariables";
    private static final String IF_THEN_ELSE_EXECUTE_TYPE_DEFAULT = "ifThenElseExecuteTypeDefault";
    private static final String LOG_ALL_BEFORE = "logAllBefore";
    private static final String LOG_ALL_AFTER = "logAllAfter";
    private boolean _startLogixNGOnLoad = true;
    private boolean _showSystemUserNames = false;
    private boolean _installDebugger = true;
    private MaleSocket.ErrorHandlingType _errorHandlingType = MaleSocket.ErrorHandlingType.ShowDialogBox;
    private boolean _treeEditorHighlightRow = false;
    private boolean _showSystemNameInException = false;
    private boolean _strictTypingGlobalVariables = false;
    private boolean _strictTypingLocalVariables = false;
    private IfThenElse.ExecuteType _ifThenElseExecuteTypeDefault = IfThenElse.ExecuteType.ExecuteOnChange;
    private boolean _logAllBefore = false;
    private boolean _logAllAfter = false;

    public DefaultLogixNGPreferences() {
        super(ProfileManager.getDefault().getActiveProfile());
        Preferences sharedPreferences = ProfileUtils.getPreferences(super.getProfile(), this.getClass(), true);
        this.readPreferences(sharedPreferences);
    }

    private void readPreferences(Preferences sharedPreferences) {
        this._startLogixNGOnLoad = sharedPreferences.getBoolean(START_LOGIXNG_ON_LOAD, this._startLogixNGOnLoad);
        this._installDebugger = sharedPreferences.getBoolean(INSTALL_DEBUGGER, this._installDebugger);
        this._showSystemUserNames = sharedPreferences.getBoolean(SHOW_SYSTEM_USER_NAMES, this._showSystemUserNames);
        this._errorHandlingType = MaleSocket.ErrorHandlingType.valueOf(sharedPreferences.get(ERROR_HANDLING_TYPE, this._errorHandlingType.name()));
        this._treeEditorHighlightRow = sharedPreferences.getBoolean(TREE_EDITOR_HIGHLIGHT_ROW, this._treeEditorHighlightRow);
        this._showSystemNameInException = sharedPreferences.getBoolean(SHOW_SYSTEM_NAME_IN_EXCEPTION, this._showSystemNameInException);
        this._strictTypingGlobalVariables = sharedPreferences.getBoolean(STRICT_TYPING_GLOBAL_VARIABLES, this._strictTypingGlobalVariables);
        this._strictTypingLocalVariables = sharedPreferences.getBoolean(STRICT_TYPING_LOCAL_VARIABLES, this._strictTypingLocalVariables);
        this._ifThenElseExecuteTypeDefault = IfThenElse.ExecuteType.valueOf(sharedPreferences.get(IF_THEN_ELSE_EXECUTE_TYPE_DEFAULT, this._ifThenElseExecuteTypeDefault.name()));
        this._logAllBefore = sharedPreferences.getBoolean(LOG_ALL_BEFORE, this._logAllBefore);
        this._logAllAfter = sharedPreferences.getBoolean(LOG_ALL_AFTER, this._logAllAfter);
        this.setIsDirty(false);
    }

    @Override
    public boolean compareValuesDifferent(LogixNGPreferences prefs) {
        if (this.getStartLogixNGOnStartup() != prefs.getStartLogixNGOnStartup()) {
            return true;
        }
        if (this.getInstallDebugger() != prefs.getInstallDebugger()) {
            return true;
        }
        if (this.getShowSystemUserNames() != prefs.getShowSystemUserNames()) {
            return true;
        }
        if (this.getTreeEditorHighlightRow() != prefs.getTreeEditorHighlightRow()) {
            return true;
        }
        if (this.getShowSystemNameInException() != prefs.getShowSystemNameInException()) {
            return true;
        }
        if (this.getStrictTypingGlobalVariables() != prefs.getStrictTypingGlobalVariables()) {
            return true;
        }
        if (this.getStrictTypingLocalVariables() != prefs.getStrictTypingLocalVariables()) {
            return true;
        }
        if (this.getIfThenElseExecuteTypeDefault() != prefs.getIfThenElseExecuteTypeDefault()) {
            return true;
        }
        if (this.getLogAllBefore() != prefs.getLogAllBefore()) {
            return true;
        }
        if (this.getLogAllAfter() != prefs.getLogAllAfter()) {
            return true;
        }
        return this.getErrorHandlingType() != prefs.getErrorHandlingType();
    }

    @Override
    public void apply(LogixNGPreferences prefs) {
        this.setStartLogixNGOnStartup(prefs.getStartLogixNGOnStartup());
        this.setInstallDebugger(prefs.getInstallDebugger());
        this.setShowSystemUserNames(prefs.getShowSystemUserNames());
        this.setErrorHandlingType(prefs.getErrorHandlingType());
        this.setTreeEditorHighlightRow(prefs.getTreeEditorHighlightRow());
        this.setShowSystemNameInException(prefs.getShowSystemNameInException());
        this.setStrictTypingGlobalVariables(prefs.getStrictTypingGlobalVariables());
        this.setStrictTypingLocalVariables(prefs.getStrictTypingLocalVariables());
        this.setIfThenElseExecuteTypeDefault(prefs.getIfThenElseExecuteTypeDefault());
        this.setLogAllBefore(prefs.getLogAllBefore());
        this.setLogAllAfter(prefs.getLogAllAfter());
    }

    @Override
    public void save() {
        Preferences sharedPreferences = ProfileUtils.getPreferences(this.getProfile(), this.getClass(), true);
        sharedPreferences.putBoolean(START_LOGIXNG_ON_LOAD, this.getStartLogixNGOnStartup());
        sharedPreferences.putBoolean(INSTALL_DEBUGGER, this.getInstallDebugger());
        sharedPreferences.putBoolean(SHOW_SYSTEM_USER_NAMES, this.getShowSystemUserNames());
        sharedPreferences.put(ERROR_HANDLING_TYPE, this.getErrorHandlingType().name());
        sharedPreferences.putBoolean(TREE_EDITOR_HIGHLIGHT_ROW, this.getTreeEditorHighlightRow());
        sharedPreferences.putBoolean(SHOW_SYSTEM_NAME_IN_EXCEPTION, this.getShowSystemNameInException());
        sharedPreferences.putBoolean(STRICT_TYPING_GLOBAL_VARIABLES, this.getStrictTypingGlobalVariables());
        sharedPreferences.putBoolean(STRICT_TYPING_LOCAL_VARIABLES, this.getStrictTypingLocalVariables());
        sharedPreferences.put(IF_THEN_ELSE_EXECUTE_TYPE_DEFAULT, this.getIfThenElseExecuteTypeDefault().name());
        sharedPreferences.putBoolean(LOG_ALL_BEFORE, this.getLogAllBefore());
        sharedPreferences.putBoolean(LOG_ALL_AFTER, this.getLogAllAfter());
        this.setIsDirty(false);
    }

    @Override
    public void setStartLogixNGOnStartup(boolean value) {
        this._startLogixNGOnLoad = value;
        this.setIsDirty(true);
    }

    @Override
    public boolean getStartLogixNGOnStartup() {
        return this._startLogixNGOnLoad;
    }

    @Override
    public void setShowSystemUserNames(boolean value) {
        this._showSystemUserNames = value;
        this.setIsDirty(true);
    }

    @Override
    public boolean getShowSystemUserNames() {
        return this._showSystemUserNames;
    }

    @Override
    public void setInstallDebugger(boolean value) {
        this._installDebugger = value;
        this.setIsDirty(true);
    }

    @Override
    public boolean getInstallDebugger() {
        return this._installDebugger;
    }

    @Override
    public void setErrorHandlingType(MaleSocket.ErrorHandlingType type) {
        this._errorHandlingType = type;
        this.setIsDirty(true);
    }

    @Override
    public MaleSocket.ErrorHandlingType getErrorHandlingType() {
        return this._errorHandlingType;
    }

    @Override
    public void setTreeEditorHighlightRow(boolean value) {
        this._treeEditorHighlightRow = value;
        this.setIsDirty(true);
    }

    @Override
    public boolean getTreeEditorHighlightRow() {
        return this._treeEditorHighlightRow;
    }

    @Override
    public void setShowSystemNameInException(boolean value) {
        this._showSystemNameInException = value;
        this.setIsDirty(true);
    }

    @Override
    public boolean getShowSystemNameInException() {
        return this._showSystemNameInException;
    }

    @Override
    public void setStrictTypingGlobalVariables(boolean value) {
        this._strictTypingGlobalVariables = value;
        this.setIsDirty(true);
    }

    @Override
    public boolean getStrictTypingGlobalVariables() {
        return this._strictTypingGlobalVariables;
    }

    @Override
    public void setStrictTypingLocalVariables(boolean value) {
        this._strictTypingLocalVariables = value;
        this.setIsDirty(true);
    }

    @Override
    public boolean getStrictTypingLocalVariables() {
        return this._strictTypingLocalVariables;
    }

    @Override
    public void setIfThenElseExecuteTypeDefault(IfThenElse.ExecuteType value) {
        this._ifThenElseExecuteTypeDefault = value;
        this.setIsDirty(true);
    }

    @Override
    public IfThenElse.ExecuteType getIfThenElseExecuteTypeDefault() {
        return this._ifThenElseExecuteTypeDefault;
    }

    @Override
    public void setLogAllBefore(boolean value) {
        this._logAllBefore = value;
        this.setIsDirty(true);
    }

    @Override
    public boolean getLogAllBefore() {
        return this._logAllBefore;
    }

    @Override
    public void setLogAllAfter(boolean value) {
        this._logAllAfter = value;
        this.setIsDirty(true);
    }

    @Override
    public boolean getLogAllAfter() {
        return this._logAllAfter;
    }
}

